/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.jaxb.reflection.runtime;

import java.io.IOException;
import javax.xml.bind.ValidationEvent;
import javax.xml.bind.helpers.ValidationEventImpl;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.jvnet.jaxb.reflection.impl.api.AccessorException;
import org.jvnet.jaxb.reflection.model.runtime.RuntimeLeafInfo;
import org.jvnet.jaxb.reflection.model.runtime.RuntimeTypeInfo;
import org.jvnet.jaxb.reflection.runtime.JAXBContextImpl;
import org.jvnet.jaxb.reflection.runtime.JaxBeanInfo;
import org.jvnet.jaxb.reflection.runtime.Messages;
import org.jvnet.jaxb.reflection.runtime.Name;
import org.jvnet.jaxb.reflection.runtime.Transducer;
import org.jvnet.jaxb.reflection.runtime.XMLSerializer;
import org.jvnet.jaxb.reflection.runtime.unmarshaller.Loader;
import org.jvnet.jaxb.reflection.runtime.unmarshaller.TextLoader;
import org.jvnet.jaxb.reflection.runtime.unmarshaller.UnmarshallingContext;
import org.jvnet.jaxb.reflection.runtime.unmarshaller.XsiTypeLoader;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class LeafBeanInfoImpl<BeanT>
extends JaxBeanInfo<BeanT> {
    private final Loader loader;
    private final Loader loaderWithSubst;
    private final Transducer<BeanT> xducer;
    private final Name tagName;

    public LeafBeanInfoImpl(JAXBContextImpl jAXBContextImpl, RuntimeLeafInfo runtimeLeafInfo) {
        super(jAXBContextImpl, (RuntimeTypeInfo)runtimeLeafInfo, runtimeLeafInfo.getClazz(), runtimeLeafInfo.getTypeNames(), runtimeLeafInfo.isElement(), true, false);
        this.xducer = runtimeLeafInfo.getTransducer();
        this.loader = new TextLoader(this.xducer);
        this.loaderWithSubst = new XsiTypeLoader(this);
        this.tagName = this.isElement() ? jAXBContextImpl.nameBuilder.createElementName(runtimeLeafInfo.getElementName()) : null;
    }

    @Override
    public QName getTypeName(BeanT BeanT) {
        QName qName = this.xducer.getTypeName(BeanT);
        if (qName != null) {
            return qName;
        }
        return super.getTypeName(BeanT);
    }

    @Override
    public final String getElementNamespaceURI(BeanT BeanT) {
        return this.tagName.nsUri;
    }

    @Override
    public final String getElementLocalName(BeanT BeanT) {
        return this.tagName.localName;
    }

    @Override
    public BeanT createInstance(UnmarshallingContext unmarshallingContext) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final boolean reset(BeanT BeanT, UnmarshallingContext unmarshallingContext) {
        return false;
    }

    @Override
    public final String getId(BeanT BeanT, XMLSerializer xMLSerializer) {
        return null;
    }

    @Override
    public final void serializeBody(BeanT BeanT, XMLSerializer xMLSerializer) throws SAXException, IOException, XMLStreamException {
        try {
            this.xducer.writeText(xMLSerializer, BeanT, null);
        }
        catch (AccessorException accessorException) {
            xMLSerializer.reportError(null, accessorException);
        }
    }

    @Override
    public final void serializeAttributes(BeanT BeanT, XMLSerializer xMLSerializer) {
    }

    @Override
    public final void serializeRoot(BeanT BeanT, XMLSerializer xMLSerializer) throws SAXException, IOException, XMLStreamException {
        if (this.tagName == null) {
            xMLSerializer.reportError((ValidationEvent)new ValidationEventImpl(1, Messages.UNABLE_TO_MARSHAL_NON_ELEMENT.format(BeanT.getClass().getName()), null, null));
        } else {
            xMLSerializer.startElement(this.tagName, BeanT);
            xMLSerializer.childAsSoleContent(BeanT, null);
            xMLSerializer.endElement();
        }
    }

    @Override
    public final void serializeURIs(BeanT BeanT, XMLSerializer xMLSerializer) throws SAXException {
        if (this.xducer.useNamespace()) {
            try {
                this.xducer.declareNamespace(BeanT, xMLSerializer);
            }
            catch (AccessorException accessorException) {
                xMLSerializer.reportError(null, accessorException);
            }
        }
    }

    @Override
    public final Loader getLoader(JAXBContextImpl jAXBContextImpl, boolean bl) {
        if (bl) {
            return this.loaderWithSubst;
        }
        return this.loader;
    }

    @Override
    public Transducer<BeanT> getTransducer() {
        return this.xducer;
    }
}

