/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.jaxb.reflection.model.impl;

import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.annotation.XmlRegistry;
import javax.xml.bind.annotation.XmlSchema;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.namespace.QName;
import org.jvnet.jaxb.reflection.impl.util.Which;
import org.jvnet.jaxb.reflection.model.annotation.AnnotationReader;
import org.jvnet.jaxb.reflection.model.annotation.ClassLocatable;
import org.jvnet.jaxb.reflection.model.annotation.Locatable;
import org.jvnet.jaxb.reflection.model.core.ErrorHandler;
import org.jvnet.jaxb.reflection.model.core.NonElement;
import org.jvnet.jaxb.reflection.model.core.PropertyInfo;
import org.jvnet.jaxb.reflection.model.core.PropertyKind;
import org.jvnet.jaxb.reflection.model.core.Ref;
import org.jvnet.jaxb.reflection.model.core.RegistryInfo;
import org.jvnet.jaxb.reflection.model.core.TypeInfo;
import org.jvnet.jaxb.reflection.model.core.TypeInfoSet;
import org.jvnet.jaxb.reflection.model.impl.ArrayInfoImpl;
import org.jvnet.jaxb.reflection.model.impl.BuiltinLeafInfoImpl;
import org.jvnet.jaxb.reflection.model.impl.ClassInfoImpl;
import org.jvnet.jaxb.reflection.model.impl.ElementInfoImpl;
import org.jvnet.jaxb.reflection.model.impl.EnumLeafInfoImpl;
import org.jvnet.jaxb.reflection.model.impl.Messages;
import org.jvnet.jaxb.reflection.model.impl.RegistryInfoImpl;
import org.jvnet.jaxb.reflection.model.impl.TypeInfoSetImpl;
import org.jvnet.jaxb.reflection.model.nav.Navigator;
import org.jvnet.jaxb.reflection.runtime.IllegalAnnotationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelBuilder<T, C, F, M> {
    final TypeInfoSetImpl<T, C, F, M> typeInfoSet;
    public final AnnotationReader<T, C, F, M> reader;
    public final Navigator<T, C, F, M> nav;
    private final Map<QName, TypeInfo> typeNames = new HashMap<QName, TypeInfo>();
    public final String defaultNsUri;
    final Map<String, RegistryInfoImpl<T, C, F, M>> registries = new HashMap<String, RegistryInfoImpl<T, C, F, M>>();
    private final Map<C, C> subclassReplacements;
    private ErrorHandler errorHandler;
    private boolean hadError;
    public boolean hasSwaRef;
    private final ErrorHandler proxyErrorHandler = new ErrorHandler(){

        public void error(IllegalAnnotationException illegalAnnotationException) {
            ModelBuilder.this.reportError(illegalAnnotationException);
        }
    };
    private boolean linked;

    public ModelBuilder(AnnotationReader<T, C, F, M> annotationReader, Navigator<T, C, F, M> navigator, Map<C, C> map, String string) {
        this.reader = annotationReader;
        this.nav = navigator;
        this.subclassReplacements = map;
        if (string == null) {
            string = "";
        }
        this.defaultNsUri = string;
        annotationReader.setErrorHandler(this.proxyErrorHandler);
        this.typeInfoSet = this.createTypeInfoSet();
    }

    protected TypeInfoSetImpl<T, C, F, M> createTypeInfoSet() {
        return new TypeInfoSetImpl<T, C, F, M>(this.nav, this.reader, BuiltinLeafInfoImpl.createLeaves(this.nav));
    }

    public NonElement<T, C> getClassInfo(C c, Locatable locatable) {
        return this.getClassInfo(c, false, locatable);
    }

    public NonElement<T, C> getClassInfo(C c, boolean bl, Locatable locatable) {
        XmlSeeAlso xmlSeeAlso;
        assert (c != null);
        T[] TArray = this.typeInfoSet.getClassInfo(c);
        if (TArray != null) {
            return TArray;
        }
        if (this.nav.isEnum(c)) {
            xmlSeeAlso = this.createEnumLeafInfo(c, locatable);
            this.typeInfoSet.add((EnumLeafInfoImpl<T, C, F, M>)xmlSeeAlso);
            TArray = xmlSeeAlso;
            this.addTypeName((NonElement<T, C>)TArray);
        } else {
            boolean bl2 = this.subclassReplacements.containsKey(c);
            if (bl2 && !bl) {
                TArray = this.getClassInfo(this.subclassReplacements.get(c), locatable);
            } else if (this.reader.hasClassAnnotation(c, XmlTransient.class) || bl2) {
                TArray = this.getClassInfo(this.nav.getSuperClass(c), bl, new ClassLocatable<C>(locatable, c, this.nav));
            } else {
                T[] TArray2 = this.createClassInfo(c, locatable);
                this.typeInfoSet.add((ClassInfoImpl<T, C, F, M>)TArray2);
                for (PropertyInfo<T, C> propertyInfo : TArray2.getProperties()) {
                    TypeInfo typeInfo;
                    Object object;
                    if (propertyInfo.kind() == PropertyKind.REFERENCE && !this.registries.containsKey(object = this.nav.getPackageName(TArray2.getClazz())) && (typeInfo = this.nav.findClass((String)object + ".ObjectFactory", TArray2.getClazz())) != null) {
                        this.addRegistry(typeInfo, (Locatable)((Object)propertyInfo));
                    }
                    object = propertyInfo.ref().iterator();
                    while (object.hasNext()) {
                        typeInfo = (TypeInfo)object.next();
                    }
                }
                TArray2.getBaseClass();
                TArray = TArray2;
                this.addTypeName((NonElement<T, C>)TArray);
            }
        }
        xmlSeeAlso = this.reader.getClassAnnotation(XmlSeeAlso.class, c, locatable);
        if (xmlSeeAlso != null) {
            for (Object object : this.reader.getClassArrayValue((Annotation)xmlSeeAlso, "value")) {
                this.getTypeInfo(object, (Locatable)xmlSeeAlso);
            }
        }
        return TArray;
    }

    private void addTypeName(NonElement<T, C> nonElement) {
        QName qName = nonElement.getTypeName();
        if (qName == null) {
            return;
        }
        TypeInfo typeInfo = this.typeNames.put(qName, nonElement);
        if (typeInfo != null) {
            this.reportError(new IllegalAnnotationException(Messages.CONFLICTING_XML_TYPE_MAPPING.format(nonElement.getTypeName()), typeInfo, nonElement));
        }
    }

    public NonElement<T, C> getTypeInfo(T t, Locatable locatable) {
        NonElement<T, C> nonElement = this.typeInfoSet.getTypeInfo(t);
        if (nonElement != null) {
            return nonElement;
        }
        if (this.nav.isArray(t)) {
            ArrayInfoImpl<T, C, F, M> arrayInfoImpl = this.createArrayInfo(locatable, t);
            this.addTypeName(arrayInfoImpl);
            this.typeInfoSet.add(arrayInfoImpl);
            return arrayInfoImpl;
        }
        C c = this.nav.asDecl(t);
        assert (c != null) : t.toString() + " must be a leaf, but we failed to recognize it.";
        return this.getClassInfo(c, locatable);
    }

    public NonElement<T, C> getTypeInfo(Ref<T, C> ref) {
        assert (!ref.valueList);
        C c = this.nav.asDecl(ref.type);
        if (c != null && this.reader.getClassAnnotation(XmlRegistry.class, c, null) != null) {
            if (!this.registries.containsKey(this.nav.getPackageName(c))) {
                this.addRegistry(c, null);
            }
            return null;
        }
        return this.getTypeInfo(ref.type, null);
    }

    protected EnumLeafInfoImpl<T, C, F, M> createEnumLeafInfo(C c, Locatable locatable) {
        return new EnumLeafInfoImpl(this, locatable, c, this.nav.use(c));
    }

    protected ClassInfoImpl<T, C, F, M> createClassInfo(C c, Locatable locatable) {
        return new ClassInfoImpl(this, locatable, c);
    }

    protected ElementInfoImpl<T, C, F, M> createElementInfo(RegistryInfoImpl<T, C, F, M> registryInfoImpl, M m) throws IllegalAnnotationException {
        return new ElementInfoImpl<T, C, F, M>(this, registryInfoImpl, m);
    }

    protected ArrayInfoImpl<T, C, F, M> createArrayInfo(Locatable locatable, T t) {
        return new ArrayInfoImpl(this, locatable, t);
    }

    public RegistryInfo<T, C> addRegistry(C c, Locatable locatable) {
        return new RegistryInfoImpl(this, locatable, c);
    }

    public RegistryInfo<T, C> getRegistry(String string) {
        return this.registries.get(string);
    }

    public TypeInfoSet<T, C, F, M> link() {
        assert (!this.linked);
        this.linked = true;
        for (ElementInfoImpl<T, C, F, M> typeInfoImpl : this.typeInfoSet.getAllElements()) {
            typeInfoImpl.link();
        }
        for (ClassInfoImpl classInfoImpl : this.typeInfoSet.beans().values()) {
            classInfoImpl.link();
        }
        for (EnumLeafInfoImpl enumLeafInfoImpl : this.typeInfoSet.enums().values()) {
            enumLeafInfoImpl.link();
        }
        if (this.hadError) {
            return null;
        }
        return this.typeInfoSet;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public final void reportError(IllegalAnnotationException illegalAnnotationException) {
        this.hadError = true;
        if (this.errorHandler != null) {
            this.errorHandler.error(illegalAnnotationException);
        }
    }

    public boolean isReplaced(C c) {
        return this.subclassReplacements.containsKey(c);
    }

    static {
        try {
            Object var0 = null;
            var0.location();
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (NoSuchMethodError noSuchMethodError) {
            Messages messages = XmlSchema.class.getClassLoader() == null ? Messages.INCOMPATIBLE_API_VERSION_MUSTANG : Messages.INCOMPATIBLE_API_VERSION;
            throw new LinkageError(messages.format(Which.which(XmlSchema.class), Which.which(ModelBuilder.class)));
        }
    }
}

