/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.api;

import java.time.Duration;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;
import org.junit.jupiter.api.AssertionUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.function.Executable;
import org.junit.platform.commons.util.ExceptionUtils;

class AssertTimeout {
    AssertTimeout() {
    }

    static void assertTimeout(Duration timeout, Executable executable) {
        AssertTimeout.assertTimeout(timeout, executable, () -> null);
    }

    static void assertTimeout(Duration timeout, Executable executable, String message) {
        AssertTimeout.assertTimeout(timeout, executable, () -> message);
    }

    static void assertTimeout(Duration timeout, Executable executable, Supplier<String> messageSupplier) {
        long timeoutInMillis = timeout.toMillis();
        long start = System.currentTimeMillis();
        try {
            executable.execute();
        }
        catch (Throwable ex) {
            ExceptionUtils.throwAsUncheckedException((Throwable)ex);
        }
        long timeElapsed = System.currentTimeMillis() - start;
        if (timeElapsed > timeoutInMillis) {
            Assertions.fail(AssertionUtils.buildPrefix(AssertionUtils.nullSafeGet(messageSupplier)) + "execution exceeded timeout of " + timeoutInMillis + " ms by " + (timeElapsed - timeoutInMillis) + " ms");
        }
    }

    static void assertTimeoutPreemptively(Duration timeout, Executable executable) {
        AssertTimeout.assertTimeoutPreemptively(timeout, executable, () -> null);
    }

    static void assertTimeoutPreemptively(Duration timeout, Executable executable, String message) {
        AssertTimeout.assertTimeoutPreemptively(timeout, executable, () -> message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void assertTimeoutPreemptively(Duration timeout, Executable executable, Supplier<String> messageSupplier) {
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        try {
            Future<Throwable> future = executorService.submit(() -> {
                try {
                    executable.execute();
                }
                catch (Throwable ex) {
                    return ex;
                }
                return null;
            });
            long timeoutInMillis = timeout.toMillis();
            Throwable throwable = null;
            try {
                throwable = future.get(timeoutInMillis, TimeUnit.MILLISECONDS);
            }
            catch (TimeoutException ex) {
                Assertions.fail(AssertionUtils.buildPrefix(AssertionUtils.nullSafeGet(messageSupplier)) + "execution timed out after " + timeoutInMillis + " ms");
            }
            catch (ExecutionException ex) {
                throwable = ex.getCause();
            }
            catch (Throwable ex) {
                throwable = ex;
            }
            if (throwable != null) {
                ExceptionUtils.throwAsUncheckedException((Throwable)throwable);
            }
        }
        finally {
            executorService.shutdownNow();
        }
    }
}

