/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.targets;

import com.headius.invokebinder.Signature;
import java.io.ByteArrayOutputStream;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodType;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jcodings.Encoding;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyComplex;
import org.jruby.RubyFixnum;
import org.jruby.RubyFloat;
import org.jruby.RubyHash;
import org.jruby.RubyModule;
import org.jruby.RubyProc;
import org.jruby.RubyRange;
import org.jruby.RubyRational;
import org.jruby.RubyRegexp;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.compiler.NotCompilableException;
import org.jruby.compiler.impl.SkinnyMethodAdapter;
import org.jruby.exceptions.RaiseException;
import org.jruby.internal.runtime.GlobalVariables;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.ir.IRClassBody;
import org.jruby.ir.IRClosure;
import org.jruby.ir.IRFlags;
import org.jruby.ir.IRMethod;
import org.jruby.ir.IRModuleBody;
import org.jruby.ir.IRScope;
import org.jruby.ir.IRScriptBody;
import org.jruby.ir.IRVisitor;
import org.jruby.ir.Operation;
import org.jruby.ir.instructions.AliasInstr;
import org.jruby.ir.instructions.ArgScopeDepthInstr;
import org.jruby.ir.instructions.ArrayDerefInstr;
import org.jruby.ir.instructions.AttrAssignInstr;
import org.jruby.ir.instructions.BEQInstr;
import org.jruby.ir.instructions.BFalseInstr;
import org.jruby.ir.instructions.BNEInstr;
import org.jruby.ir.instructions.BNilInstr;
import org.jruby.ir.instructions.BSwitchInstr;
import org.jruby.ir.instructions.BTrueInstr;
import org.jruby.ir.instructions.BUndefInstr;
import org.jruby.ir.instructions.BacktickInstr;
import org.jruby.ir.instructions.BlockGivenInstr;
import org.jruby.ir.instructions.BreakInstr;
import org.jruby.ir.instructions.BuildBackrefInstr;
import org.jruby.ir.instructions.BuildCompoundArrayInstr;
import org.jruby.ir.instructions.BuildCompoundStringInstr;
import org.jruby.ir.instructions.BuildDynRegExpInstr;
import org.jruby.ir.instructions.BuildLambdaInstr;
import org.jruby.ir.instructions.BuildRangeInstr;
import org.jruby.ir.instructions.BuildSplatInstr;
import org.jruby.ir.instructions.CallBase;
import org.jruby.ir.instructions.CallInstr;
import org.jruby.ir.instructions.CheckArgsArrayArityInstr;
import org.jruby.ir.instructions.CheckArityInstr;
import org.jruby.ir.instructions.CheckForLJEInstr;
import org.jruby.ir.instructions.ClassSuperInstr;
import org.jruby.ir.instructions.ConstMissingInstr;
import org.jruby.ir.instructions.CopyInstr;
import org.jruby.ir.instructions.DefineClassInstr;
import org.jruby.ir.instructions.DefineClassMethodInstr;
import org.jruby.ir.instructions.DefineInstanceMethodInstr;
import org.jruby.ir.instructions.DefineMetaClassInstr;
import org.jruby.ir.instructions.DefineModuleInstr;
import org.jruby.ir.instructions.EQQInstr;
import org.jruby.ir.instructions.ExceptionRegionEndMarkerInstr;
import org.jruby.ir.instructions.ExceptionRegionStartMarkerInstr;
import org.jruby.ir.instructions.GVarAliasInstr;
import org.jruby.ir.instructions.GetClassVarContainerModuleInstr;
import org.jruby.ir.instructions.GetClassVariableInstr;
import org.jruby.ir.instructions.GetEncodingInstr;
import org.jruby.ir.instructions.GetFieldInstr;
import org.jruby.ir.instructions.GetGlobalVariableInstr;
import org.jruby.ir.instructions.InheritanceSearchConstInstr;
import org.jruby.ir.instructions.InstanceSuperInstr;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.instructions.JumpInstr;
import org.jruby.ir.instructions.LabelInstr;
import org.jruby.ir.instructions.LexicalSearchConstInstr;
import org.jruby.ir.instructions.LineNumberInstr;
import org.jruby.ir.instructions.LoadFrameClosureInstr;
import org.jruby.ir.instructions.LoadImplicitClosureInstr;
import org.jruby.ir.instructions.LoadLocalVarInstr;
import org.jruby.ir.instructions.MatchInstr;
import org.jruby.ir.instructions.ModuleVersionGuardInstr;
import org.jruby.ir.instructions.NoResultCallInstr;
import org.jruby.ir.instructions.NonlocalReturnInstr;
import org.jruby.ir.instructions.NopInstr;
import org.jruby.ir.instructions.OptArgMultipleAsgnInstr;
import org.jruby.ir.instructions.PopBindingInstr;
import org.jruby.ir.instructions.PopBlockFrameInstr;
import org.jruby.ir.instructions.PopMethodFrameInstr;
import org.jruby.ir.instructions.PrepareBlockArgsInstr;
import org.jruby.ir.instructions.PrepareFixedBlockArgsInstr;
import org.jruby.ir.instructions.PrepareNoBlockArgsInstr;
import org.jruby.ir.instructions.PrepareSingleBlockArgInstr;
import org.jruby.ir.instructions.ProcessModuleBodyInstr;
import org.jruby.ir.instructions.PushBlockBindingInstr;
import org.jruby.ir.instructions.PushBlockFrameInstr;
import org.jruby.ir.instructions.PushMethodBindingInstr;
import org.jruby.ir.instructions.PushMethodFrameInstr;
import org.jruby.ir.instructions.PutClassVariableInstr;
import org.jruby.ir.instructions.PutConstInstr;
import org.jruby.ir.instructions.PutFieldInstr;
import org.jruby.ir.instructions.PutGlobalVarInstr;
import org.jruby.ir.instructions.RaiseRequiredKeywordArgumentError;
import org.jruby.ir.instructions.ReceiveJRubyExceptionInstr;
import org.jruby.ir.instructions.ReceiveKeywordArgInstr;
import org.jruby.ir.instructions.ReceiveKeywordRestArgInstr;
import org.jruby.ir.instructions.ReceiveOptArgInstr;
import org.jruby.ir.instructions.ReceivePostReqdArgInstr;
import org.jruby.ir.instructions.ReceivePreReqdArgInstr;
import org.jruby.ir.instructions.ReceiveRestArgInstr;
import org.jruby.ir.instructions.ReceiveRubyExceptionInstr;
import org.jruby.ir.instructions.ReceiveSelfInstr;
import org.jruby.ir.instructions.RecordEndBlockInstr;
import org.jruby.ir.instructions.ReifyClosureInstr;
import org.jruby.ir.instructions.ReqdArgMultipleAsgnInstr;
import org.jruby.ir.instructions.RescueEQQInstr;
import org.jruby.ir.instructions.RestArgMultipleAsgnInstr;
import org.jruby.ir.instructions.RestoreBindingVisibilityInstr;
import org.jruby.ir.instructions.ReturnInstr;
import org.jruby.ir.instructions.ReturnOrRethrowSavedExcInstr;
import org.jruby.ir.instructions.RuntimeHelperCall;
import org.jruby.ir.instructions.SaveBindingVisibilityInstr;
import org.jruby.ir.instructions.SearchConstInstr;
import org.jruby.ir.instructions.SearchModuleForConstInstr;
import org.jruby.ir.instructions.SetCapturedVarInstr;
import org.jruby.ir.instructions.StoreLocalVarInstr;
import org.jruby.ir.instructions.ThreadPollInstr;
import org.jruby.ir.instructions.ThrowExceptionInstr;
import org.jruby.ir.instructions.ToAryInstr;
import org.jruby.ir.instructions.ToggleBacktraceInstr;
import org.jruby.ir.instructions.TraceInstr;
import org.jruby.ir.instructions.UndefMethodInstr;
import org.jruby.ir.instructions.UnresolvedSuperInstr;
import org.jruby.ir.instructions.UpdateBlockExecutionStateInstr;
import org.jruby.ir.instructions.YieldInstr;
import org.jruby.ir.instructions.ZSuperInstr;
import org.jruby.ir.instructions.boxing.AluInstr;
import org.jruby.ir.instructions.boxing.BoxBooleanInstr;
import org.jruby.ir.instructions.boxing.BoxFixnumInstr;
import org.jruby.ir.instructions.boxing.BoxFloatInstr;
import org.jruby.ir.instructions.boxing.UnboxBooleanInstr;
import org.jruby.ir.instructions.boxing.UnboxFixnumInstr;
import org.jruby.ir.instructions.boxing.UnboxFloatInstr;
import org.jruby.ir.instructions.defined.GetErrorInfoInstr;
import org.jruby.ir.instructions.defined.RestoreErrorInfoInstr;
import org.jruby.ir.instructions.specialized.OneFixnumArgNoBlockCallInstr;
import org.jruby.ir.instructions.specialized.OneFloatArgNoBlockCallInstr;
import org.jruby.ir.operands.Array;
import org.jruby.ir.operands.AsString;
import org.jruby.ir.operands.Bignum;
import org.jruby.ir.operands.Boolean;
import org.jruby.ir.operands.ClosureLocalVariable;
import org.jruby.ir.operands.Complex;
import org.jruby.ir.operands.CurrentScope;
import org.jruby.ir.operands.DynamicSymbol;
import org.jruby.ir.operands.Filename;
import org.jruby.ir.operands.Fixnum;
import org.jruby.ir.operands.Float;
import org.jruby.ir.operands.FrozenString;
import org.jruby.ir.operands.Hash;
import org.jruby.ir.operands.LocalVariable;
import org.jruby.ir.operands.Nil;
import org.jruby.ir.operands.NthRef;
import org.jruby.ir.operands.NullBlock;
import org.jruby.ir.operands.ObjectClass;
import org.jruby.ir.operands.Operand;
import org.jruby.ir.operands.Rational;
import org.jruby.ir.operands.Regexp;
import org.jruby.ir.operands.SValue;
import org.jruby.ir.operands.ScopeModule;
import org.jruby.ir.operands.Self;
import org.jruby.ir.operands.Splat;
import org.jruby.ir.operands.StandardError;
import org.jruby.ir.operands.StringLiteral;
import org.jruby.ir.operands.Stringable;
import org.jruby.ir.operands.Symbol;
import org.jruby.ir.operands.SymbolProc;
import org.jruby.ir.operands.TemporaryBooleanVariable;
import org.jruby.ir.operands.TemporaryFixnumVariable;
import org.jruby.ir.operands.TemporaryFloatVariable;
import org.jruby.ir.operands.TemporaryLocalVariable;
import org.jruby.ir.operands.TemporaryVariable;
import org.jruby.ir.operands.UnboxedBoolean;
import org.jruby.ir.operands.UnboxedFixnum;
import org.jruby.ir.operands.UnboxedFloat;
import org.jruby.ir.operands.UndefinedValue;
import org.jruby.ir.operands.UnexecutableNil;
import org.jruby.ir.operands.Variable;
import org.jruby.ir.operands.WrappedIRClosure;
import org.jruby.ir.persistence.IRDumper;
import org.jruby.ir.representations.BasicBlock;
import org.jruby.ir.runtime.IRRuntimeHelpers;
import org.jruby.ir.targets.IRBytecodeAdapter;
import org.jruby.ir.targets.JVM;
import org.jruby.ir.targets.JVM6;
import org.jruby.ir.targets.JVM7;
import org.jruby.ir.targets.JVMVisitorMethodContext;
import org.jruby.org.objectweb.asm.Handle;
import org.jruby.org.objectweb.asm.Label;
import org.jruby.org.objectweb.asm.Type;
import org.jruby.org.objectweb.asm.commons.Method;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.Binding;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallType;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.Frame;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.RubyEvent;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.callsite.RefinedCachingCallSite;
import org.jruby.runtime.scope.DynamicScopeGenerator;
import org.jruby.util.ByteList;
import org.jruby.util.ClassDefiningClassLoader;
import org.jruby.util.CodegenUtils;
import org.jruby.util.JavaNameMangler;
import org.jruby.util.KeyValuePair;
import org.jruby.util.RegexpOptions;
import org.jruby.util.cli.Options;
import org.jruby.util.collections.IntHashMap;
import org.jruby.util.log.Logger;
import org.jruby.util.log.LoggerFactory;

public class JVMVisitor
extends IRVisitor {
    private static final Logger LOG = LoggerFactory.getLogger(JVMVisitor.class);
    public static final String DYNAMIC_SCOPE = "$dynamicScope";
    private static final boolean DEBUG = false;
    public static final String BLOCK_ARG_NAME = "blockArg";
    public static final String SELF_BLOCK_NAME = "selfBlock";
    private static final Signature METHOD_SIGNATURE_BASE = Signature.returning(IRubyObject.class).appendArgs(new String[]{"context", "scope", "self", "blockArg", "class", "callName"}, ThreadContext.class, StaticScope.class, IRubyObject.class, Block.class, RubyModule.class, String.class);
    private static final Signature METHOD_SIGNATURE_VARARGS = METHOD_SIGNATURE_BASE.insertArg("blockArg", "args", IRubyObject[].class);
    public static final Signature CLOSURE_SIGNATURE = Signature.returning(IRubyObject.class).appendArgs(new String[]{"context", "selfBlock", "scope", "self", "args", "blockArg", "superName", "type"}, ThreadContext.class, Block.class, StaticScope.class, IRubyObject.class, IRubyObject[].class, Block.class, String.class, Block.Type.class);
    private static final int MAX_TABLE_SWITCH_SIZE = 33;
    private JVM jvm = Options.COMPILE_INVOKEDYNAMIC.load() != false ? new JVM7() : new JVM6();
    private int methodIndex = 0;
    private Map<String, IRScope> scopeMap = new HashMap<String, IRScope>();
    private String file;
    private int lastLine = -1;

    public Class compile(IRScope scope, ClassDefiningClassLoader jrubyClassLoader) {
        this.file = scope.getFileName();
        this.lastLine = -1;
        JVMVisitorMethodContext context = new JVMVisitorMethodContext();
        return this.defineFromBytecode(scope, this.compileToBytecode(scope, context), jrubyClassLoader);
    }

    public byte[] compileToBytecode(IRScope scope, JVMVisitorMethodContext context) {
        this.file = scope.getFileName();
        this.lastLine = -1;
        this.codegenScope(scope, context);
        return this.code();
    }

    public Class defineFromBytecode(IRScope scope, byte[] code, ClassDefiningClassLoader jrubyClassLoader) {
        this.file = scope.getFileName();
        this.lastLine = -1;
        Class<?> result2 = jrubyClassLoader.defineClass(CodegenUtils.c(JVM.scriptToClass(scope.getFileName())), code);
        for (Map.Entry<String, IRScope> entry : this.scopeMap.entrySet()) {
            try {
                result2.getField(entry.getKey()).set(null, entry.getValue());
            }
            catch (Exception e) {
                throw new NotCompilableException(e);
            }
        }
        return result2;
    }

    public byte[] code() {
        return this.jvm.code();
    }

    protected void codegenScope(IRScope scope, JVMVisitorMethodContext context) {
        if (scope instanceof IRScriptBody) {
            this.codegenScriptBody((IRScriptBody)scope);
        } else if (scope instanceof IRMethod) {
            this.emitMethodJIT((IRMethod)scope, context);
        } else if (scope instanceof IRClosure) {
            this.emitBlockJIT((IRClosure)scope, context);
        } else if (scope instanceof IRModuleBody) {
            this.emitModuleBodyJIT((IRModuleBody)scope);
        } else {
            throw new NotCompilableException("don't know how to JIT: " + scope);
        }
    }

    protected void codegenScriptBody(IRScriptBody script) {
        this.emitScriptBody(script);
    }

    protected void emitScope(IRScope scope, String name2, Signature signature, boolean specificArity, boolean print2) {
        BasicBlock[] bbs = scope.prepareForCompilation();
        if (print2 && Options.IR_PRINT.load().booleanValue()) {
            ByteArrayOutputStream baos = IRDumper.printIR(scope, true);
            LOG.info("Printing JIT IR for " + scope.getName() + ":\n" + new String(baos.toByteArray()), new Object[0]);
        }
        Map<BasicBlock, org.jruby.ir.operands.Label> exceptionTable = scope.buildJVMExceptionTable();
        this.emitClosures(scope, print2);
        this.jvm.pushmethod(name2, scope, signature, specificArity);
        String scopeField = name2 + "_IRScope";
        if (this.scopeMap.get(scopeField) == null) {
            this.scopeMap.put(scopeField, scope);
            this.jvm.cls().visitField(73, scopeField, CodegenUtils.ci(IRScope.class), null, null).visitEnd();
        }
        if (!scope.hasExplicitCallProtocol()) {
            this.jvmMethod().loadContext();
            this.jvmMethod().invokeVirtual(Type.getType(ThreadContext.class), Method.getMethod("org.jruby.runtime.DynamicScope getCurrentScope()"));
            this.jvmStoreLocal(DYNAMIC_SCOPE);
        } else if (scope instanceof IRClosure) {
            this.jvmAdapter().aconst_null();
            this.jvmStoreLocal(DYNAMIC_SCOPE);
        }
        IRBytecodeAdapter m = this.jvmMethod();
        org.jruby.ir.operands.Label currentRescue = null;
        org.jruby.ir.operands.Label currentRegionStart = null;
        org.jruby.ir.operands.Label currentBlockStart = null;
        HashMap<org.jruby.ir.operands.Label, Label> rescueEndForStart = new HashMap<org.jruby.ir.operands.Label, Label>();
        HashMap<org.jruby.ir.operands.Label, Label> syntheticEndForStart = new HashMap<org.jruby.ir.operands.Label, Label>();
        for (BasicBlock bb : bbs) {
            currentBlockStart = bb.getLabel();
            org.jruby.ir.operands.Label rescueLabel = exceptionTable.get(bb);
            if (rescueLabel == currentRescue) continue;
            if (currentRescue != null) {
                rescueEndForStart.put(currentRegionStart, this.jvm.methodData().getLabel(bb.getLabel()));
            }
            if (rescueLabel != null) {
                currentRescue = rescueLabel;
                currentRegionStart = bb.getLabel();
                continue;
            }
            currentRescue = null;
            currentRegionStart = null;
        }
        if (currentRegionStart != null) {
            Label syntheticEnd = new Label();
            rescueEndForStart.put(currentRegionStart, syntheticEnd);
            syntheticEndForStart.put(currentBlockStart, syntheticEnd);
        }
        for (BasicBlock bb : bbs) {
            Label end2;
            Label start2 = this.jvm.methodData().getLabel(bb.getLabel());
            org.jruby.ir.operands.Label rescueLabel = exceptionTable.get(bb);
            m.mark(start2);
            if (rescueLabel != null && (end2 = (Label)rescueEndForStart.get(bb.getLabel())) != null) {
                Label rescue = this.jvm.methodData().getLabel(rescueLabel);
                this.jvmAdapter().trycatch(start2, end2, rescue, CodegenUtils.p(Throwable.class));
            }
            m.adapter.nop();
            for (Instr instr : bb.getInstrs()) {
                this.visit(instr);
            }
            Label syntheticEnd = (Label)syntheticEndForStart.get(bb.getLabel());
            if (syntheticEnd == null) continue;
            m.mark(syntheticEnd);
        }
        this.jvm.popmethod();
    }

    protected void emitVarargsMethodWrapper(IRScope scope, String variableName, String specificName, Signature variableSignature, Signature specificSignature) {
        this.jvm.pushmethod(variableName, scope, variableSignature, false);
        IRBytecodeAdapter m = this.jvmMethod();
        org.jruby.runtime.Signature scopeSig = scope.getStaticScope().getSignature();
        this.checkArity(scopeSig.required(), scopeSig.opt(), scopeSig.hasRest(), scopeSig.hasKwargs(), scopeSig.keyRest());
        m.loadContext();
        m.loadStaticScope();
        m.loadSelf();
        if (scopeSig.required() > 0) {
            for (int i2 = 0; i2 < scopeSig.required(); ++i2) {
                m.loadArgs();
                this.jvmAdapter().pushInt(i2);
                this.jvmAdapter().aaload();
            }
        }
        m.loadBlock();
        m.loadFrameClass();
        m.loadFrameName();
        Method specificMethod = new Method(specificName, Type.getType(specificSignature.type().returnType()), IRRuntimeHelpers.typesFromSignature(specificSignature));
        this.jvmAdapter().invokestatic(m.getClassData().clsName, specificName, specificMethod.getDescriptor());
        this.jvmAdapter().areturn();
        this.jvm.popmethod();
    }

    protected static final Signature signatureFor(IRScope method, boolean aritySplit) {
        if (aritySplit) {
            StaticScope argScope = method.getStaticScope();
            if (argScope.isArgumentScope() && argScope.getSignature().isFixed() && !argScope.getSignature().hasKwargs()) {
                String[] args2 = new String[argScope.getSignature().required()];
                Class[] types = new Class[args2.length];
                for (int i2 = 0; i2 < args2.length; ++i2) {
                    args2[i2] = "arg" + i2;
                    types[i2] = IRubyObject.class;
                }
                return METHOD_SIGNATURE_BASE.insertArgs(BLOCK_ARG_NAME, args2, types);
            }
            return null;
        }
        return METHOD_SIGNATURE_BASE.insertArgs(BLOCK_ARG_NAME, new String[]{"args"}, IRubyObject[].class);
    }

    protected void emitScriptBody(IRScriptBody script) {
        String name2 = JavaNameMangler.encodeScopeForBacktrace(script);
        String clsName = JVM.scriptToClass(script.getFileName());
        this.jvm.pushscript(clsName, script.getFileName());
        this.emitScope(script, name2, JVMVisitor.signatureFor(script, false), false, true);
        this.jvm.cls().visitEnd();
        this.jvm.popclass();
    }

    protected void emitMethod(IRMethod method, JVMVisitorMethodContext context) {
        String name2 = JavaNameMangler.encodeScopeForBacktrace(method) + '$' + this.methodIndex++;
        this.emitWithSignatures(method, context, name2);
    }

    protected void emitMethodJIT(IRMethod method, JVMVisitorMethodContext context) {
        String clsName = JVM.scriptToClass(method.getFileName());
        String name2 = JavaNameMangler.encodeScopeForBacktrace(method) + '$' + this.methodIndex++;
        this.jvm.pushscript(clsName, method.getFileName());
        this.emitWithSignatures(method, context, name2);
        this.jvm.cls().visitEnd();
        this.jvm.popclass();
    }

    protected void emitBlockJIT(IRClosure closure, JVMVisitorMethodContext context) {
        String clsName = JVM.scriptToClass(closure.getFileName());
        String name2 = JavaNameMangler.encodeScopeForBacktrace(closure) + '$' + this.methodIndex++;
        this.jvm.pushscript(clsName, closure.getFileName());
        this.emitScope(closure, name2, CLOSURE_SIGNATURE, false, true);
        context.setBaseName(name2);
        context.setVariableName(name2);
        this.jvm.cls().visitEnd();
        this.jvm.popclass();
    }

    private void emitWithSignatures(IRMethod method, JVMVisitorMethodContext context, String name2) {
        context.setBaseName(name2);
        Signature specificSig = JVMVisitor.signatureFor(method, true);
        if (specificSig == null) {
            context.setVariableName(name2);
            Signature signature = JVMVisitor.signatureFor(method, false);
            this.emitScope(method, name2, signature, false, true);
            context.addNativeSignature(-1, signature.type());
        } else {
            String specificName = name2;
            context.setSpecificName(specificName);
            this.emitScope(method, specificName, specificSig, true, true);
            context.addNativeSignature(method.getStaticScope().getSignature().required(), specificSig.type());
            String variableName = name2 + "$__VARARGS__";
            context.setVariableName(variableName);
            this.emitVarargsMethodWrapper(method, variableName, specificName, METHOD_SIGNATURE_VARARGS, specificSig);
            context.addNativeSignature(-1, METHOD_SIGNATURE_VARARGS.type());
        }
    }

    protected Handle emitModuleBodyJIT(IRModuleBody method) {
        String name2 = JavaNameMangler.encodeScopeForBacktrace(method) + '$' + this.methodIndex++;
        String clsName = JVM.scriptToClass(method.getFileName());
        this.jvm.pushscript(clsName, method.getFileName());
        Signature signature = JVMVisitor.signatureFor(method, false);
        this.emitScope(method, name2, signature, false, true);
        Handle handle = new Handle(6, this.jvm.clsData().clsName, name2, CodegenUtils.sig((Class)signature.type().returnType(), signature.type().parameterArray()), false);
        this.jvm.cls().visitEnd();
        this.jvm.popclass();
        return handle;
    }

    private void emitClosures(IRScope s2, boolean print2) {
        for (IRClosure c : s2.getClosures()) {
            c.setHandle(this.emitClosure(c, print2));
        }
    }

    protected Handle emitClosure(IRClosure closure, boolean print2) {
        String name2 = JavaNameMangler.encodeScopeForBacktrace(closure) + '$' + this.methodIndex++;
        this.emitScope(closure, name2, CLOSURE_SIGNATURE, false, print2);
        return new Handle(6, this.jvm.clsData().clsName, name2, CodegenUtils.sig((Class)CLOSURE_SIGNATURE.type().returnType(), CLOSURE_SIGNATURE.type().parameterArray()), false);
    }

    protected Handle emitModuleBody(IRModuleBody method) {
        String name2 = JavaNameMangler.encodeScopeForBacktrace(method) + '$' + this.methodIndex++;
        Signature signature = JVMVisitor.signatureFor(method, false);
        this.emitScope(method, name2, signature, false, true);
        return new Handle(6, this.jvm.clsData().clsName, name2, CodegenUtils.sig((Class)signature.type().returnType(), signature.type().parameterArray()), false);
    }

    @Override
    public void visit(Instr instr) {
        instr.visit(this);
    }

    @Override
    public void visit(Operand operand) {
        operand.visit(this);
    }

    private int getJVMLocalVarIndex(Variable variable) {
        if (variable instanceof TemporaryLocalVariable) {
            switch (((TemporaryLocalVariable)variable).getType()) {
                case FLOAT: {
                    return this.jvm.methodData().local(variable, JVM.DOUBLE_TYPE);
                }
                case FIXNUM: {
                    return this.jvm.methodData().local(variable, JVM.LONG_TYPE);
                }
                case BOOLEAN: {
                    return this.jvm.methodData().local(variable, JVM.BOOLEAN_TYPE);
                }
            }
            return this.jvm.methodData().local(variable);
        }
        return this.jvm.methodData().local(variable);
    }

    private int getJVMLocalVarIndex(String specialVar) {
        return this.jvm.methodData().local(specialVar);
    }

    private Label getJVMLabel(org.jruby.ir.operands.Label label2) {
        return this.jvm.methodData().getLabel(label2);
    }

    private void jvmStoreLocal(Variable variable) {
        if (variable instanceof LocalVariable) {
            this.jvmLoadLocal(DYNAMIC_SCOPE);
            this.jvmAdapter().swap();
            this.genSetValue((LocalVariable)variable);
        } else if (variable instanceof TemporaryLocalVariable) {
            switch (((TemporaryLocalVariable)variable).getType()) {
                case FLOAT: {
                    this.jvmAdapter().dstore(this.getJVMLocalVarIndex(variable));
                    break;
                }
                case FIXNUM: {
                    this.jvmAdapter().lstore(this.getJVMLocalVarIndex(variable));
                    break;
                }
                case BOOLEAN: {
                    this.jvmAdapter().istore(this.getJVMLocalVarIndex(variable));
                    break;
                }
                default: {
                    this.jvmMethod().storeLocal(this.getJVMLocalVarIndex(variable));
                    break;
                }
            }
        } else {
            this.jvmMethod().storeLocal(this.getJVMLocalVarIndex(variable));
        }
    }

    private void jvmStoreLocal(Runnable source2, Variable variable) {
        if (variable instanceof LocalVariable) {
            this.jvmLoadLocal(DYNAMIC_SCOPE);
            source2.run();
            this.genSetValue((LocalVariable)variable);
        } else if (variable instanceof TemporaryLocalVariable) {
            source2.run();
            switch (((TemporaryLocalVariable)variable).getType()) {
                case FLOAT: {
                    this.jvmAdapter().dstore(this.getJVMLocalVarIndex(variable));
                    break;
                }
                case FIXNUM: {
                    this.jvmAdapter().lstore(this.getJVMLocalVarIndex(variable));
                    break;
                }
                case BOOLEAN: {
                    this.jvmAdapter().istore(this.getJVMLocalVarIndex(variable));
                    break;
                }
                default: {
                    this.jvmMethod().storeLocal(this.getJVMLocalVarIndex(variable));
                    break;
                }
            }
        } else {
            source2.run();
            this.jvmMethod().storeLocal(this.getJVMLocalVarIndex(variable));
        }
    }

    private void genSetValue(LocalVariable localvariable) {
        int depth = localvariable.getScopeDepth();
        int location = localvariable.getLocation();
        String baseName = CodegenUtils.p(DynamicScope.class);
        if (depth == 0) {
            if (location < DynamicScopeGenerator.SPECIALIZED_SETS.size()) {
                this.jvmAdapter().invokevirtual(baseName, DynamicScopeGenerator.SPECIALIZED_SETS.get(location), CodegenUtils.sig(Void.TYPE, IRubyObject.class));
            } else {
                this.jvmAdapter().pushInt(location);
                this.jvmAdapter().invokevirtual(baseName, "setValueDepthZeroVoid", CodegenUtils.sig(Void.TYPE, IRubyObject.class, Integer.TYPE));
            }
        } else {
            this.jvmAdapter().pushInt(location);
            this.jvmAdapter().pushInt(depth);
            this.jvmAdapter().invokevirtual(baseName, "setValueVoid", CodegenUtils.sig(Void.TYPE, IRubyObject.class, Integer.TYPE, Integer.TYPE));
        }
    }

    private void jvmStoreLocal(String specialVar) {
        this.jvmMethod().storeLocal(this.getJVMLocalVarIndex(specialVar));
    }

    private void jvmLoadLocal(Variable variable) {
        if (variable instanceof TemporaryLocalVariable) {
            switch (((TemporaryLocalVariable)variable).getType()) {
                case FLOAT: {
                    this.jvmAdapter().dload(this.getJVMLocalVarIndex(variable));
                    break;
                }
                case FIXNUM: {
                    this.jvmAdapter().lload(this.getJVMLocalVarIndex(variable));
                    break;
                }
                case BOOLEAN: {
                    this.jvmAdapter().iload(this.getJVMLocalVarIndex(variable));
                    break;
                }
                default: {
                    this.jvmMethod().loadLocal(this.getJVMLocalVarIndex(variable));
                    break;
                }
            }
        } else {
            this.jvmMethod().loadLocal(this.getJVMLocalVarIndex(variable));
        }
    }

    private void jvmLoadLocal(String specialVar) {
        this.jvmMethod().loadLocal(this.getJVMLocalVarIndex(specialVar));
    }

    @Override
    public void AliasInstr(AliasInstr aliasInstr) {
        IRBytecodeAdapter m = this.jvm.method();
        m.loadContext();
        m.loadSelf();
        this.jvmLoadLocal(DYNAMIC_SCOPE);
        this.visit(aliasInstr.getNewName());
        this.jvmAdapter().invokevirtual(CodegenUtils.p(Object.class), "toString", CodegenUtils.sig(String.class, new Class[0]));
        this.visit(aliasInstr.getOldName());
        this.jvmAdapter().invokevirtual(CodegenUtils.p(Object.class), "toString", CodegenUtils.sig(String.class, new Class[0]));
        m.invokeIRHelper("defineAlias", CodegenUtils.sig(Void.TYPE, ThreadContext.class, IRubyObject.class, DynamicScope.class, String.class, String.class));
    }

    @Override
    public void ArgScopeDepthInstr(ArgScopeDepthInstr instr) {
        this.jvmMethod().loadContext();
        this.jvmMethod().loadStaticScope();
        this.jvmMethod().invokeIRHelper("getArgScopeDepth", CodegenUtils.sig(RubyFixnum.class, ThreadContext.class, StaticScope.class));
        this.jvmStoreLocal(instr.getResult());
    }

    @Override
    public void AttrAssignInstr(AttrAssignInstr attrAssignInstr) {
        Operand[] callArgs = attrAssignInstr.getCallArgs();
        this.compileCallCommon(this.jvmMethod(), attrAssignInstr.getName(), callArgs, attrAssignInstr.getReceiver(), callArgs.length, null, IRBytecodeAdapter.BlockPassType.NONE, attrAssignInstr.getReceiver() instanceof Self ? CallType.FUNCTIONAL : CallType.NORMAL, null, attrAssignInstr.isPotentiallyRefined());
    }

    @Override
    public void ArrayDerefInstr(ArrayDerefInstr arrayderefinstr) {
        this.jvmMethod().loadContext();
        this.jvmMethod().loadSelf();
        this.visit(arrayderefinstr.getReceiver());
        this.visit(arrayderefinstr.getKey());
        this.jvmMethod().invokeArrayDeref(this.file, this.lastLine);
        this.jvmStoreLocal(arrayderefinstr.getResult());
    }

    @Override
    public void BEQInstr(BEQInstr beqInstr) {
        this.jvmMethod().loadContext();
        this.visit(beqInstr.getArg1());
        this.visit(beqInstr.getArg2());
        this.jvmMethod().invokeHelper("BEQ", java.lang.Boolean.TYPE, ThreadContext.class, IRubyObject.class, IRubyObject.class);
        this.jvmAdapter().iftrue(this.getJVMLabel(beqInstr.getJumpTarget()));
    }

    @Override
    public void BFalseInstr(BFalseInstr bFalseInstr) {
        Operand arg1 = bFalseInstr.getArg1();
        if (arg1 instanceof TemporaryBooleanVariable || arg1 instanceof UnboxedBoolean) {
            this.visit(arg1);
            this.jvmMethod().bfalse(this.getJVMLabel(bFalseInstr.getJumpTarget()));
        } else if (!(arg1 instanceof UnboxedFixnum) && !(arg1 instanceof UnboxedFloat)) {
            this.visit(arg1);
            this.jvmAdapter().invokeinterface(CodegenUtils.p(IRubyObject.class), "isTrue", CodegenUtils.sig(java.lang.Boolean.TYPE, new Class[0]));
            this.jvmMethod().bfalse(this.getJVMLabel(bFalseInstr.getJumpTarget()));
        }
    }

    @Override
    public void BlockGivenInstr(BlockGivenInstr blockGivenInstr) {
        this.jvmMethod().loadContext();
        this.visit(blockGivenInstr.getBlockArg());
        this.jvmMethod().invokeIRHelper("isBlockGiven", CodegenUtils.sig(RubyBoolean.class, ThreadContext.class, Object.class));
        this.jvmStoreLocal(blockGivenInstr.getResult());
    }

    private void loadFloatArg(Operand arg2) {
        if (arg2 instanceof Variable) {
            this.visit(arg2);
        } else {
            double val;
            if (arg2 instanceof Float) {
                val = ((Float)arg2).value;
            } else if (arg2 instanceof Fixnum) {
                val = ((Fixnum)arg2).value;
            } else {
                throw new NotCompilableException("Non-float/fixnum in loadFloatArg!" + arg2);
            }
            this.jvmAdapter().ldc(val);
        }
    }

    private void loadFixnumArg(Operand arg2) {
        if (arg2 instanceof Variable) {
            this.visit(arg2);
        } else {
            long val;
            if (arg2 instanceof Float) {
                val = (long)((Float)arg2).value;
            } else if (arg2 instanceof Fixnum) {
                val = ((Fixnum)arg2).value;
            } else {
                throw new NotCompilableException("Non-float/fixnum in loadFixnumArg!" + arg2);
            }
            this.jvmAdapter().ldc(val);
        }
    }

    private void loadBooleanArg(Operand arg2) {
        if (arg2 instanceof Variable) {
            this.visit(arg2);
        } else {
            if (!(arg2 instanceof UnboxedBoolean)) {
                throw new NotCompilableException("Non-float/fixnum in loadFixnumArg!" + arg2);
            }
            boolean val = ((UnboxedBoolean)arg2).isTrue();
            this.jvmAdapter().ldc(val);
        }
    }

    @Override
    public void BoxFloatInstr(BoxFloatInstr instr) {
        IRBytecodeAdapter m = this.jvmMethod();
        SkinnyMethodAdapter a = m.adapter;
        m.loadContext();
        a.getfield(CodegenUtils.p(ThreadContext.class), "runtime", CodegenUtils.ci(Ruby.class));
        this.loadFloatArg(instr.getValue());
        a.invokevirtual(CodegenUtils.p(Ruby.class), "newFloat", CodegenUtils.sig(RubyFloat.class, Double.TYPE));
        this.jvmStoreLocal(instr.getResult());
    }

    @Override
    public void BoxFixnumInstr(BoxFixnumInstr instr) {
        IRBytecodeAdapter m = this.jvmMethod();
        SkinnyMethodAdapter a = m.adapter;
        m.loadContext();
        a.getfield(CodegenUtils.p(ThreadContext.class), "runtime", CodegenUtils.ci(Ruby.class));
        this.loadFixnumArg(instr.getValue());
        a.invokevirtual(CodegenUtils.p(Ruby.class), "newFixnum", CodegenUtils.sig(RubyFixnum.class, Long.TYPE));
        this.jvmStoreLocal(instr.getResult());
    }

    @Override
    public void BoxBooleanInstr(BoxBooleanInstr instr) {
        IRBytecodeAdapter m = this.jvmMethod();
        SkinnyMethodAdapter a = m.adapter;
        m.loadContext();
        a.getfield(CodegenUtils.p(ThreadContext.class), "runtime", CodegenUtils.ci(Ruby.class));
        this.loadBooleanArg(instr.getValue());
        a.invokevirtual(CodegenUtils.p(Ruby.class), "newBoolean", CodegenUtils.sig(RubyBoolean.class, java.lang.Boolean.TYPE));
        this.jvmStoreLocal(instr.getResult());
    }

    @Override
    public void UnboxFloatInstr(UnboxFloatInstr instr) {
        this.visit(instr.getValue());
        this.jvmMethod().invokeIRHelper("unboxFloat", CodegenUtils.sig(Double.TYPE, IRubyObject.class));
        this.jvmStoreLocal(instr.getResult());
    }

    @Override
    public void UnboxFixnumInstr(UnboxFixnumInstr instr) {
        this.visit(instr.getValue());
        this.jvmMethod().invokeIRHelper("unboxFixnum", CodegenUtils.sig(Long.TYPE, IRubyObject.class));
        this.jvmStoreLocal(instr.getResult());
    }

    @Override
    public void UnboxBooleanInstr(UnboxBooleanInstr instr) {
        this.visit(instr.getValue());
        this.jvmMethod().invokeIRHelper("unboxBoolean", CodegenUtils.sig(java.lang.Boolean.TYPE, IRubyObject.class));
        this.jvmStoreLocal(instr.getResult());
    }

    @Override
    public void AluInstr(AluInstr instr) {
        IRBytecodeAdapter m = this.jvmMethod();
        SkinnyMethodAdapter a = m.adapter;
        this.visit(instr.getArg1());
        this.visit(instr.getArg2());
        switch (instr.getOperation()) {
            case FADD: {
                a.dadd();
                break;
            }
            case FSUB: {
                a.dsub();
                break;
            }
            case FMUL: {
                a.dmul();
                break;
            }
            case FDIV: {
                a.ddiv();
                break;
            }
            case FLT: {
                m.invokeIRHelper("flt", CodegenUtils.sig(java.lang.Boolean.TYPE, Double.TYPE, Double.TYPE));
                break;
            }
            case FGT: {
                m.invokeIRHelper("fgt", CodegenUtils.sig(java.lang.Boolean.TYPE, Double.TYPE, Double.TYPE));
                break;
            }
            case FEQ: {
                m.invokeIRHelper("feq", CodegenUtils.sig(java.lang.Boolean.TYPE, Double.TYPE, Double.TYPE));
                break;
            }
            case IADD: {
                a.ladd();
                break;
            }
            case ISUB: {
                a.lsub();
                break;
            }
            case IMUL: {
                a.lmul();
                break;
            }
            case IDIV: {
                a.ldiv();
                break;
            }
            case ILT: {
                m.invokeIRHelper("ilt", CodegenUtils.sig(java.lang.Boolean.TYPE, Long.TYPE, Long.TYPE));
                break;
            }
            case IGT: {
                m.invokeIRHelper("igt", CodegenUtils.sig(java.lang.Boolean.TYPE, Long.TYPE, Long.TYPE));
                break;
            }
            case IOR: {
                a.lor();
                break;
            }
            case IAND: {
                a.land();
                break;
            }
            case IXOR: {
                a.lxor();
                break;
            }
            case ISHL: {
                a.lshl();
                break;
            }
            case ISHR: {
                a.lshr();
                break;
            }
            case IEQ: {
                m.invokeIRHelper("ilt", CodegenUtils.sig(java.lang.Boolean.TYPE, Long.TYPE, Long.TYPE));
                break;
            }
            default: {
                throw new NotCompilableException("UNHANDLED!");
            }
        }
        this.jvmStoreLocal(instr.getResult());
    }

    @Override
    public void BacktickInstr(BacktickInstr instr) {
        this.jvmMethod().loadContext();
        this.jvmMethod().loadSelf();
        this.jvmMethod().loadSelf();
        ByteList csByteList = new ByteList();
        this.jvmMethod().pushString(csByteList, 48);
        for (Operand p2 : instr.getOperands()) {
            this.visit(p2);
            this.jvmAdapter().dup();
            Label after = new Label();
            this.jvmAdapter().instance_of(CodegenUtils.p(RubyString.class));
            this.jvmAdapter().iftrue(after);
            this.jvmAdapter().invokevirtual(CodegenUtils.p(IRubyObject.class), "anyToString", CodegenUtils.sig(IRubyObject.class, new Class[0]));
            this.jvmAdapter().label(after);
            this.jvmAdapter().invokevirtual(CodegenUtils.p(RubyString.class), "append19", CodegenUtils.sig(RubyString.class, IRubyObject.class));
        }
        this.jvmAdapter().dup();
        this.jvmAdapter().ldc(true);
        this.jvmAdapter().invokeinterface(CodegenUtils.p(IRubyObject.class), "setFrozen", CodegenUtils.sig(Void.TYPE, java.lang.Boolean.TYPE));
        this.jvmMethod().invokeSelf(this.file, this.lastLine, "`", 1, IRBytecodeAdapter.BlockPassType.NONE, CallType.FUNCTIONAL, false);
        this.jvmStoreLocal(instr.getResult());
    }

    @Override
    public void BNEInstr(BNEInstr bneinstr) {
        this.jvmMethod().loadContext();
        this.visit(bneinstr.getArg1());
        this.visit(bneinstr.getArg2());
        this.jvmMethod().invokeHelper("BNE", java.lang.Boolean.TYPE, ThreadContext.class, IRubyObject.class, IRubyObject.class);
        this.jvmAdapter().iftrue(this.getJVMLabel(bneinstr.getJumpTarget()));
    }

    @Override
    public void BNilInstr(BNilInstr bnilinstr) {
        this.visit(bnilinstr.getArg1());
        this.jvmMethod().isNil();
        this.jvmMethod().btrue(this.getJVMLabel(bnilinstr.getJumpTarget()));
    }

    @Override
    public void BreakInstr(BreakInstr breakInstr) {
        this.jvmMethod().loadContext();
        this.jvmLoadLocal(DYNAMIC_SCOPE);
        this.visit(breakInstr.getReturnValue());
        this.jvmMethod().loadSelfBlock();
        this.jvmAdapter().invokestatic(CodegenUtils.p(IRRuntimeHelpers.class), "initiateBreak", CodegenUtils.sig(IRubyObject.class, ThreadContext.class, DynamicScope.class, IRubyObject.class, Block.class));
        this.jvmMethod().returnValue();
    }

    @Override
    public void BSwitchInstr(BSwitchInstr bswitchinstr) {
        int low;
        this.visit(bswitchinstr.getCaseOperand());
        this.jvmAdapter().dup();
        this.jvmAdapter().instance_of(CodegenUtils.p(RubyFixnum.class));
        Label rubyCaseLabel = this.getJVMLabel(bswitchinstr.getRubyCaseLabel());
        Label notFixnum = new Label();
        this.jvmAdapter().iffalse(notFixnum);
        this.jvmAdapter().checkcast(CodegenUtils.p(RubyFixnum.class));
        this.jvmAdapter().invokevirtual(CodegenUtils.p(RubyFixnum.class), "getIntValue", CodegenUtils.sig(Integer.TYPE, new Class[0]));
        org.jruby.ir.operands.Label[] targets = bswitchinstr.getTargets();
        Label[] jvmTargets = new Label[targets.length];
        for (int i2 = 0; i2 < targets.length; ++i2) {
            jvmTargets[i2] = this.getJVMLabel(targets[i2]);
        }
        Label defaultTarget = this.getJVMLabel(bswitchinstr.getElseTarget());
        int[] jumps = bswitchinstr.getJumps();
        int high = jumps[jumps.length - 1];
        int span = high - (low = jumps[0]) + 1;
        if (span == jumps.length) {
            this.jvmAdapter().tableswitch(low, high, defaultTarget, jvmTargets);
        } else if (span <= 33) {
            Label[] realTargets = jvmTargets;
            jvmTargets = new Label[span];
            jvmTargets[0] = realTargets[0];
            int p2 = jumps[0] + 1;
            int t = 1;
            for (int i3 = 1; i3 < jumps.length; ++i3) {
                int cj = jumps[i3];
                if (cj == p2) {
                    jvmTargets[t++] = realTargets[i3];
                    p2 = cj + 1;
                    continue;
                }
                while (cj > p2++) {
                    jvmTargets[t++] = defaultTarget;
                }
                jvmTargets[t++] = realTargets[i3];
            }
            this.jvmAdapter().tableswitch(low, high, defaultTarget, jvmTargets);
        } else {
            this.jvmAdapter().lookupswitch(defaultTarget, bswitchinstr.getJumps(), jvmTargets);
        }
        this.jvmAdapter().label(notFixnum);
        this.jvmAdapter().pop();
        this.jvmAdapter().label(rubyCaseLabel);
    }

    @Override
    public void BTrueInstr(BTrueInstr btrueinstr) {
        Operand arg1 = btrueinstr.getArg1();
        if (arg1 instanceof TemporaryBooleanVariable || arg1 instanceof UnboxedBoolean) {
            this.visit(arg1);
            this.jvmMethod().btrue(this.getJVMLabel(btrueinstr.getJumpTarget()));
        } else if (arg1 instanceof UnboxedFixnum || arg1 instanceof UnboxedFloat) {
            this.jvmMethod().goTo(this.getJVMLabel(btrueinstr.getJumpTarget()));
        } else {
            this.visit(arg1);
            this.jvmAdapter().invokeinterface(CodegenUtils.p(IRubyObject.class), "isTrue", CodegenUtils.sig(java.lang.Boolean.TYPE, new Class[0]));
            this.jvmMethod().btrue(this.getJVMLabel(btrueinstr.getJumpTarget()));
        }
    }

    @Override
    public void BUndefInstr(BUndefInstr bundefinstr) {
        this.visit(bundefinstr.getArg1());
        this.jvmMethod().pushUndefined();
        this.jvmAdapter().if_acmpeq(this.getJVMLabel(bundefinstr.getJumpTarget()));
    }

    @Override
    public void BuildBackrefInstr(BuildBackrefInstr instr) {
        this.jvmMethod().loadContext();
        this.jvmAdapter().invokevirtual(CodegenUtils.p(ThreadContext.class), "getBackRef", CodegenUtils.sig(IRubyObject.class, new Class[0]));
        switch (instr.type) {
            case '&': {
                this.jvmAdapter().invokestatic(CodegenUtils.p(RubyRegexp.class), "last_match", CodegenUtils.sig(IRubyObject.class, IRubyObject.class));
                break;
            }
            case '`': {
                this.jvmAdapter().invokestatic(CodegenUtils.p(RubyRegexp.class), "match_pre", CodegenUtils.sig(IRubyObject.class, IRubyObject.class));
                break;
            }
            case '\'': {
                this.jvmAdapter().invokestatic(CodegenUtils.p(RubyRegexp.class), "match_post", CodegenUtils.sig(IRubyObject.class, IRubyObject.class));
                break;
            }
            case '+': {
                this.jvmAdapter().invokestatic(CodegenUtils.p(RubyRegexp.class), "match_last", CodegenUtils.sig(IRubyObject.class, IRubyObject.class));
                break;
            }
            default: {
                assert (false) : "backref with invalid type";
                break;
            }
        }
        this.jvmStoreLocal(instr.getResult());
    }

    @Override
    public void BuildCompoundArrayInstr(BuildCompoundArrayInstr instr) {
        this.jvmMethod().loadContext();
        this.visit(instr.getAppendingArg());
        if (instr.isArgsPush()) {
            this.jvmAdapter().checkcast("org/jruby/RubyArray");
        }
        this.visit(instr.getAppendedArg());
        if (instr.isArgsPush()) {
            this.jvmMethod().invokeHelper("argsPush", RubyArray.class, ThreadContext.class, RubyArray.class, IRubyObject.class);
        } else {
            this.jvmMethod().invokeHelper("argsCat", RubyArray.class, ThreadContext.class, IRubyObject.class, IRubyObject.class);
        }
        this.jvmStoreLocal(instr.getResult());
    }

    @Override
    public void BuildCompoundStringInstr(BuildCompoundStringInstr compoundstring) {
        ByteList csByteList = new ByteList();
        csByteList.setEncoding(compoundstring.getEncoding());
        this.jvmMethod().pushString(csByteList, 0);
        for (Operand p2 : compoundstring.getPieces()) {
            this.visit(p2);
            this.jvmAdapter().invokevirtual(CodegenUtils.p(RubyString.class), "append19", CodegenUtils.sig(RubyString.class, IRubyObject.class));
        }
        if (compoundstring.isFrozen()) {
            this.jvmMethod().loadContext();
            this.jvmAdapter().swap();
            this.jvmAdapter().ldc(compoundstring.getFile());
            this.jvmAdapter().ldc(compoundstring.getLine());
            this.jvmMethod().invokeIRHelper("freezeLiteralString", CodegenUtils.sig(RubyString.class, ThreadContext.class, RubyString.class, String.class, Integer.TYPE));
        }
        this.jvmStoreLocal(compoundstring.getResult());
    }

    @Override
    public void BuildDynRegExpInstr(BuildDynRegExpInstr instr) {
        final IRBytecodeAdapter m = this.jvmMethod();
        if (instr.getOptions().isOnce() && instr.getRegexp() != null) {
            this.visit(new Regexp(instr.getRegexp().source().convertToString().getByteList(), instr.getOptions()));
            this.jvmStoreLocal(instr.getResult());
            return;
        }
        RegexpOptions options2 = instr.getOptions();
        final Operand[] operands = instr.getPieces();
        Runnable r = new Runnable(){

            @Override
            public void run() {
                m.loadContext();
                for (int i2 = 0; i2 < operands.length; ++i2) {
                    Operand operand = operands[i2];
                    JVMVisitor.this.visit(operand);
                }
            }
        };
        m.pushDRegexp(r, options2, operands.length);
        this.jvmStoreLocal(instr.getResult());
    }

    @Override
    public void BuildRangeInstr(BuildRangeInstr instr) {
        this.jvmMethod().loadContext();
        this.visit(instr.getBegin());
        this.visit(instr.getEnd());
        this.jvmAdapter().ldc(instr.isExclusive());
        this.jvmAdapter().invokestatic(CodegenUtils.p(RubyRange.class), "newRange", CodegenUtils.sig(RubyRange.class, ThreadContext.class, IRubyObject.class, IRubyObject.class, java.lang.Boolean.TYPE));
        this.jvmStoreLocal(instr.getResult());
    }

    @Override
    public void BuildSplatInstr(BuildSplatInstr instr) {
        this.jvmMethod().loadContext();
        this.visit(instr.getArray());
        this.jvmAdapter().ldc(instr.getDup());
        this.jvmMethod().invokeIRHelper("splatArray", CodegenUtils.sig(RubyArray.class, ThreadContext.class, IRubyObject.class, java.lang.Boolean.TYPE));
        this.jvmStoreLocal(instr.getResult());
    }

    @Override
    public void CallInstr(CallInstr callInstr) {
        if (callInstr instanceof OneFixnumArgNoBlockCallInstr) {
            this.oneFixnumArgNoBlockCallInstr((OneFixnumArgNoBlockCallInstr)callInstr);
            return;
        }
        if (callInstr instanceof OneFloatArgNoBlockCallInstr) {
            this.oneFloatArgNoBlockCallInstr((OneFloatArgNoBlockCallInstr)callInstr);
            return;
        }
        if (callInstr.getCallSite() instanceof RefinedCachingCallSite) {
            throw new NotCompilableException("refinements are unsupported in JIT");
        }
        IRBytecodeAdapter m = this.jvmMethod();
        String name2 = callInstr.getName();
        Operand[] args2 = callInstr.getCallArgs();
        Operand receiver2 = callInstr.getReceiver();
        int numArgs = args2.length;
        Operand closure = callInstr.getClosureArg(null);
        IRBytecodeAdapter.BlockPassType blockPassType = IRBytecodeAdapter.BlockPassType.fromIR(callInstr);
        CallType callType = callInstr.getCallType();
        Variable result2 = callInstr.getResult();
        this.compileCallCommon(m, name2, args2, receiver2, numArgs, closure, blockPassType, callType, result2, callInstr.isPotentiallyRefined());
    }

    private void compileCallCommon(IRBytecodeAdapter m, String name2, Operand[] args2, Operand receiver2, int numArgs, Operand closure, IRBytecodeAdapter.BlockPassType blockPassType, CallType callType, Variable result2, boolean isPotentiallyRefined) {
        m.loadContext();
        m.loadSelf();
        this.visit(receiver2);
        int arity2 = numArgs;
        if (numArgs == 1 && args2[0] instanceof Splat) {
            this.visit(args2[0]);
            m.adapter.invokevirtual(CodegenUtils.p(RubyArray.class), "toJavaArray", CodegenUtils.sig(IRubyObject[].class, new Class[0]));
            arity2 = -1;
        } else {
            if (CallBase.containsArgSplat(args2)) {
                throw new NotCompilableException("splat in non-initial argument for normal call is unsupported in JIT");
            }
            for (Operand operand : args2) {
                this.visit(operand);
            }
        }
        if (blockPassType.given()) {
            m.loadContext();
            this.visit(closure);
            m.invokeIRHelper("getBlockFromObject", CodegenUtils.sig(Block.class, ThreadContext.class, Object.class));
        }
        switch (callType) {
            case FUNCTIONAL: {
                m.invokeSelf(this.file, this.lastLine, name2, arity2, blockPassType, CallType.FUNCTIONAL, isPotentiallyRefined);
                break;
            }
            case VARIABLE: {
                m.invokeSelf(this.file, this.lastLine, name2, arity2, blockPassType, CallType.VARIABLE, isPotentiallyRefined);
                break;
            }
            case NORMAL: {
                m.invokeOther(this.file, this.lastLine, name2, arity2, blockPassType, isPotentiallyRefined);
            }
        }
        if (result2 != null) {
            this.jvmStoreLocal(result2);
        } else {
            m.adapter.pop();
        }
    }

    @Override
    public void CheckArgsArrayArityInstr(CheckArgsArrayArityInstr checkargsarrayarityinstr) {
        this.jvmMethod().loadContext();
        this.visit(checkargsarrayarityinstr.getArgsArray());
        this.jvmAdapter().pushInt(checkargsarrayarityinstr.required);
        this.jvmAdapter().pushInt(checkargsarrayarityinstr.opt);
        this.jvmAdapter().pushBoolean(checkargsarrayarityinstr.rest);
        this.jvmMethod().invokeStatic(Type.getType(Helpers.class), Method.getMethod("void irCheckArgsArrayArity(org.jruby.runtime.ThreadContext, org.jruby.RubyArray, int, int, boolean)"));
    }

    @Override
    public void CheckArityInstr(CheckArityInstr checkarityinstr) {
        if (this.jvm.methodData().specificArity < 0) {
            this.checkArity(checkarityinstr.required, checkarityinstr.opt, checkarityinstr.rest, checkarityinstr.receivesKeywords, checkarityinstr.restKey);
        }
    }

    private void checkArity(int required, int opt, boolean rest2, boolean receivesKeywords, int restKey) {
        this.jvmMethod().loadContext();
        this.jvmMethod().loadStaticScope();
        this.jvmMethod().loadArgs();
        this.jvmAdapter().ldc(required);
        this.jvmAdapter().ldc(opt);
        this.jvmAdapter().ldc(rest2);
        this.jvmAdapter().ldc(receivesKeywords);
        this.jvmAdapter().ldc(restKey);
        this.jvmMethod().loadBlockType();
        this.jvmAdapter().invokestatic(CodegenUtils.p(IRRuntimeHelpers.class), "checkArity", CodegenUtils.sig(Void.TYPE, ThreadContext.class, StaticScope.class, Object[].class, Integer.TYPE, Integer.TYPE, java.lang.Boolean.TYPE, java.lang.Boolean.TYPE, Integer.TYPE, Block.Type.class));
    }

    @Override
    public void CheckForLJEInstr(CheckForLJEInstr checkForljeinstr) {
        this.jvmMethod().loadContext();
        this.jvmLoadLocal(DYNAMIC_SCOPE);
        this.jvmAdapter().ldc(checkForljeinstr.isDefinedWithinMethod());
        this.jvmMethod().loadBlockType();
        this.jvmAdapter().invokestatic(CodegenUtils.p(IRRuntimeHelpers.class), "checkForLJE", CodegenUtils.sig(Void.TYPE, ThreadContext.class, DynamicScope.class, java.lang.Boolean.TYPE, Block.Type.class));
    }

    @Override
    public void ClassSuperInstr(ClassSuperInstr classsuperinstr) {
        String name2 = classsuperinstr.getName();
        Operand[] args2 = classsuperinstr.getCallArgs();
        Operand definingModule = classsuperinstr.getDefiningModule();
        boolean[] splatMap = classsuperinstr.splatMap();
        Operand closure = classsuperinstr.getClosureArg(null);
        this.superCommon(name2, classsuperinstr, args2, definingModule, splatMap, closure);
    }

    @Override
    public void ConstMissingInstr(ConstMissingInstr constmissinginstr) {
        this.visit(constmissinginstr.getReceiver());
        this.jvmAdapter().checkcast("org/jruby/RubyModule");
        this.jvmMethod().loadContext();
        this.jvmAdapter().ldc("const_missing");
        this.jvmMethod().pushSymbol(constmissinginstr.getMissingConst());
        this.jvmMethod().invokeVirtual(Type.getType(RubyModule.class), Method.getMethod("org.jruby.runtime.builtin.IRubyObject callMethod(org.jruby.runtime.ThreadContext, java.lang.String, org.jruby.runtime.builtin.IRubyObject)"));
        this.jvmStoreLocal(constmissinginstr.getResult());
    }

    @Override
    public void CopyInstr(CopyInstr copyinstr) {
        Operand src = copyinstr.getSource();
        Variable res = copyinstr.getResult();
        this.storeHeapOrStack(src, res);
    }

    private void storeHeapOrStack(final Operand value2, final Variable res) {
        this.jvmStoreLocal(new Runnable(){

            @Override
            public void run() {
                if (res instanceof TemporaryFloatVariable) {
                    JVMVisitor.this.loadFloatArg(value2);
                } else if (res instanceof TemporaryFixnumVariable) {
                    JVMVisitor.this.loadFixnumArg(value2);
                } else {
                    JVMVisitor.this.visit(value2);
                }
            }
        }, res);
    }

    @Override
    public void DefineClassInstr(DefineClassInstr defineclassinstr) {
        IRClassBody newIRClassBody = defineclassinstr.getNewIRClassBody();
        this.jvmMethod().loadContext();
        Handle handle = this.emitModuleBody(newIRClassBody);
        this.jvmMethod().pushHandle(handle);
        this.jvmAdapter().getstatic(this.jvm.clsData().clsName, handle.getName() + "_IRScope", CodegenUtils.ci(IRScope.class));
        this.visit(defineclassinstr.getContainer());
        this.visit(defineclassinstr.getSuperClass());
        this.jvmMethod().invokeIRHelper("newCompiledClassBody", CodegenUtils.sig(DynamicMethod.class, ThreadContext.class, MethodHandle.class, IRScope.class, Object.class, Object.class));
        this.jvmStoreLocal(defineclassinstr.getResult());
    }

    @Override
    public void DefineClassMethodInstr(DefineClassMethodInstr defineclassmethodinstr) {
        IRMethod method = defineclassmethodinstr.getMethod();
        this.jvmMethod().loadContext();
        JVMVisitorMethodContext context = new JVMVisitorMethodContext();
        this.emitMethod(method, context);
        String defSignature = this.pushHandlesForDef(context.getVariableName(), context.getSpecificName(), context.getNativeSignaturesExceptVariable(), METHOD_SIGNATURE_VARARGS.type(), CodegenUtils.sig(Void.TYPE, ThreadContext.class, MethodHandle.class, IRScope.class, IRubyObject.class), CodegenUtils.sig(Void.TYPE, ThreadContext.class, MethodHandle.class, MethodHandle.class, Integer.TYPE, IRScope.class, IRubyObject.class));
        this.jvmAdapter().getstatic(this.jvm.clsData().clsName, context.getBaseName() + "_IRScope", CodegenUtils.ci(IRScope.class));
        this.visit(defineclassmethodinstr.getContainer());
        this.jvmMethod().adapter.invokestatic(CodegenUtils.p(IRRuntimeHelpers.class), "defCompiledClassMethod", defSignature);
    }

    @Override
    public void DefineInstanceMethodInstr(DefineInstanceMethodInstr defineinstancemethodinstr) {
        IRMethod method = defineinstancemethodinstr.getMethod();
        JVMVisitorMethodContext context = new JVMVisitorMethodContext();
        IRBytecodeAdapter m = this.jvmMethod();
        SkinnyMethodAdapter a = m.adapter;
        m.loadContext();
        this.emitMethod(method, context);
        MethodType variable = context.getNativeSignature(-1);
        assert (variable != null);
        String defSignature = this.pushHandlesForDef(context.getVariableName(), context.getSpecificName(), context.getNativeSignaturesExceptVariable(), variable, CodegenUtils.sig(Void.TYPE, ThreadContext.class, MethodHandle.class, IRScope.class, DynamicScope.class, IRubyObject.class), CodegenUtils.sig(Void.TYPE, ThreadContext.class, MethodHandle.class, MethodHandle.class, Integer.TYPE, IRScope.class, DynamicScope.class, IRubyObject.class));
        a.getstatic(this.jvm.clsData().clsName, context.getBaseName() + "_IRScope", CodegenUtils.ci(IRScope.class));
        this.jvmLoadLocal(DYNAMIC_SCOPE);
        this.jvmMethod().loadSelf();
        a.invokestatic(CodegenUtils.p(IRRuntimeHelpers.class), "defCompiledInstanceMethod", defSignature);
    }

    private String pushHandlesForDef(String variableName, String specificName, IntHashMap<MethodType> signaturesExceptVariable, MethodType variable, String variableOnly, String variableAndSpecific) {
        String defSignature;
        block1: {
            block0: {
                this.jvmMethod().pushHandle(new Handle(6, this.jvm.clsData().clsName, variableName, CodegenUtils.sig((Class)variable.returnType(), variable.parameterArray()), false));
                if (signaturesExceptVariable.size() != 0) break block0;
                defSignature = variableOnly;
                break block1;
            }
            defSignature = variableAndSpecific;
            Iterator<IntHashMap.Entry<MethodType>> iterator = signaturesExceptVariable.entrySet().iterator();
            if (!iterator.hasNext()) break block1;
            IntHashMap.Entry<MethodType> entry = iterator.next();
            this.jvmMethod().pushHandle(new Handle(6, this.jvm.clsData().clsName, specificName, CodegenUtils.sig((Class)entry.getValue().returnType(), entry.getValue().parameterArray()), false));
            this.jvmAdapter().pushInt(entry.getKey());
        }
        return defSignature;
    }

    @Override
    public void DefineMetaClassInstr(DefineMetaClassInstr definemetaclassinstr) {
        IRModuleBody metaClassBody = definemetaclassinstr.getMetaClassBody();
        this.jvmMethod().loadContext();
        Handle handle = this.emitModuleBody(metaClassBody);
        this.jvmMethod().pushHandle(handle);
        this.jvmAdapter().getstatic(this.jvm.clsData().clsName, handle.getName() + "_IRScope", CodegenUtils.ci(IRScope.class));
        this.visit(definemetaclassinstr.getObject());
        this.jvmMethod().invokeIRHelper("newCompiledMetaClass", CodegenUtils.sig(DynamicMethod.class, ThreadContext.class, MethodHandle.class, IRScope.class, IRubyObject.class));
        this.jvmStoreLocal(definemetaclassinstr.getResult());
    }

    @Override
    public void DefineModuleInstr(DefineModuleInstr definemoduleinstr) {
        IRModuleBody newIRModuleBody = definemoduleinstr.getNewIRModuleBody();
        this.jvmMethod().loadContext();
        Handle handle = this.emitModuleBody(newIRModuleBody);
        this.jvmMethod().pushHandle(handle);
        this.jvmAdapter().getstatic(this.jvm.clsData().clsName, handle.getName() + "_IRScope", CodegenUtils.ci(IRScope.class));
        this.visit(definemoduleinstr.getContainer());
        this.jvmMethod().invokeIRHelper("newCompiledModuleBody", CodegenUtils.sig(DynamicMethod.class, ThreadContext.class, MethodHandle.class, IRScope.class, Object.class));
        this.jvmStoreLocal(definemoduleinstr.getResult());
    }

    @Override
    public void EQQInstr(EQQInstr eqqinstr) {
        if (!eqqinstr.isSplattedValue() && !(eqqinstr.getArg2() instanceof UndefinedValue)) {
            this.compileCallCommon(this.jvmMethod(), "===", Helpers.arrayOf(eqqinstr.getArg2()), eqqinstr.getArg1(), 1, null, IRBytecodeAdapter.BlockPassType.NONE, CallType.FUNCTIONAL, eqqinstr.getResult(), false);
        } else {
            this.jvmMethod().loadContext();
            this.visit(eqqinstr.getArg1());
            this.visit(eqqinstr.getArg2());
            this.jvmMethod().callEqq(eqqinstr.isSplattedValue());
            this.jvmStoreLocal(eqqinstr.getResult());
        }
    }

    @Override
    public void ExceptionRegionEndMarkerInstr(ExceptionRegionEndMarkerInstr exceptionregionendmarkerinstr) {
        throw new NotCompilableException("Marker instructions shouldn't reach compiler: " + exceptionregionendmarkerinstr);
    }

    @Override
    public void ExceptionRegionStartMarkerInstr(ExceptionRegionStartMarkerInstr exceptionregionstartmarkerinstr) {
        throw new NotCompilableException("Marker instructions shouldn't reach compiler: " + exceptionregionstartmarkerinstr);
    }

    @Override
    public void GetClassVarContainerModuleInstr(GetClassVarContainerModuleInstr getclassvarcontainermoduleinstr) {
        this.jvmMethod().loadContext();
        this.visit(getclassvarcontainermoduleinstr.getStartingScope());
        if (getclassvarcontainermoduleinstr.getObject() != null) {
            this.visit(getclassvarcontainermoduleinstr.getObject());
        } else {
            this.jvmAdapter().aconst_null();
        }
        this.jvmMethod().invokeIRHelper("getModuleFromScope", CodegenUtils.sig(RubyModule.class, ThreadContext.class, StaticScope.class, IRubyObject.class));
        this.jvmStoreLocal(getclassvarcontainermoduleinstr.getResult());
    }

    @Override
    public void GetClassVariableInstr(GetClassVariableInstr getclassvariableinstr) {
        this.visit(getclassvariableinstr.getSource());
        this.jvmAdapter().checkcast(CodegenUtils.p(RubyModule.class));
        this.jvmAdapter().ldc(getclassvariableinstr.getRef());
        this.jvmAdapter().invokevirtual(CodegenUtils.p(RubyModule.class), "getClassVar", CodegenUtils.sig(IRubyObject.class, String.class));
        this.jvmStoreLocal(getclassvariableinstr.getResult());
    }

    @Override
    public void GetFieldInstr(GetFieldInstr getfieldinstr) {
        this.visit(getfieldinstr.getSource());
        this.jvmMethod().getField(getfieldinstr.getRef());
        this.jvmStoreLocal(getfieldinstr.getResult());
    }

    @Override
    public void GetGlobalVariableInstr(GetGlobalVariableInstr getglobalvariableinstr) {
        this.jvmMethod().getGlobalVariable(getglobalvariableinstr.getTarget().getName(), this.file, this.lastLine);
        this.jvmStoreLocal(getglobalvariableinstr.getResult());
    }

    @Override
    public void GVarAliasInstr(GVarAliasInstr gvaraliasinstr) {
        this.jvmMethod().loadRuntime();
        this.jvmAdapter().invokevirtual(CodegenUtils.p(Ruby.class), "getGlobalVariables", CodegenUtils.sig(GlobalVariables.class, new Class[0]));
        this.visit(gvaraliasinstr.getNewName());
        this.jvmAdapter().invokevirtual(CodegenUtils.p(Object.class), "toString", CodegenUtils.sig(String.class, new Class[0]));
        this.visit(gvaraliasinstr.getOldName());
        this.jvmAdapter().invokevirtual(CodegenUtils.p(Object.class), "toString", CodegenUtils.sig(String.class, new Class[0]));
        this.jvmAdapter().invokevirtual(CodegenUtils.p(GlobalVariables.class), "alias", CodegenUtils.sig(Void.TYPE, String.class, String.class));
    }

    @Override
    public void InheritanceSearchConstInstr(InheritanceSearchConstInstr inheritancesearchconstinstr) {
        this.jvmMethod().loadContext();
        this.visit(inheritancesearchconstinstr.getCurrentModule());
        this.jvmMethod().inheritanceSearchConst(inheritancesearchconstinstr.getConstName(), false);
        this.jvmStoreLocal(inheritancesearchconstinstr.getResult());
    }

    @Override
    public void InstanceSuperInstr(InstanceSuperInstr instancesuperinstr) {
        String name2 = instancesuperinstr.getName();
        Operand[] args2 = instancesuperinstr.getCallArgs();
        Operand definingModule = instancesuperinstr.getDefiningModule();
        boolean[] splatMap = instancesuperinstr.splatMap();
        Operand closure = instancesuperinstr.getClosureArg(null);
        this.superCommon(name2, instancesuperinstr, args2, definingModule, splatMap, closure);
    }

    private void superCommon(String name2, CallInstr instr, Operand[] args2, Operand definingModule, boolean[] splatMap, Operand closure) {
        boolean hasClosure;
        IRBytecodeAdapter m = this.jvmMethod();
        Operation operation = instr.getOperation();
        m.loadContext();
        m.loadSelf();
        m.loadSelf();
        if (definingModule == UndefinedValue.UNDEFINED) {
            this.jvmAdapter().aconst_null();
        } else {
            this.visit(definingModule);
        }
        this.jvmAdapter().checkcast(CodegenUtils.p(RubyClass.class));
        for (int i2 = 0; i2 < args2.length; ++i2) {
            Operand operand = args2[i2];
            this.visit(operand);
        }
        boolean bl = hasClosure = closure != null;
        if (hasClosure) {
            m.loadContext();
            this.visit(closure);
            m.invokeIRHelper("getBlockFromObject", CodegenUtils.sig(Block.class, ThreadContext.class, Object.class));
        }
        switch (operation) {
            case INSTANCE_SUPER: {
                m.invokeInstanceSuper(this.file, this.lastLine, name2, args2.length, hasClosure, splatMap);
                break;
            }
            case CLASS_SUPER: {
                m.invokeClassSuper(this.file, this.lastLine, name2, args2.length, hasClosure, splatMap);
                break;
            }
            case UNRESOLVED_SUPER: {
                m.invokeUnresolvedSuper(this.file, this.lastLine, name2, args2.length, hasClosure, splatMap);
                break;
            }
            case ZSUPER: {
                m.invokeZSuper(this.file, this.lastLine, name2, args2.length, hasClosure, splatMap);
                break;
            }
            default: {
                throw new NotCompilableException("unknown super type " + (Object)((Object)operation) + " in " + instr);
            }
        }
        this.jvmStoreLocal(instr.getResult());
    }

    @Override
    public void JumpInstr(JumpInstr jumpinstr) {
        this.jvmMethod().goTo(this.getJVMLabel(jumpinstr.getJumpTarget()));
    }

    @Override
    public void LabelInstr(LabelInstr labelinstr) {
    }

    @Override
    public void LexicalSearchConstInstr(LexicalSearchConstInstr lexicalsearchconstinstr) {
        this.jvmMethod().loadContext();
        this.visit(lexicalsearchconstinstr.getDefiningScope());
        this.jvmMethod().lexicalSearchConst(lexicalsearchconstinstr.getConstName());
        this.jvmStoreLocal(lexicalsearchconstinstr.getResult());
    }

    @Override
    public void LineNumberInstr(LineNumberInstr linenumberinstr) {
        this.lastLine = linenumberinstr.getLineNumber() + 1;
        this.jvmAdapter().line(this.lastLine);
    }

    @Override
    public void LoadLocalVarInstr(LoadLocalVarInstr loadlocalvarinstr) {
        this.LocalVariable(loadlocalvarinstr.getLocalVar());
        this.jvmStoreLocal(loadlocalvarinstr.getResult());
    }

    @Override
    public void LoadImplicitClosure(LoadImplicitClosureInstr loadimplicitclosureinstr) {
        this.jvmMethod().loadBlock();
        this.jvmStoreLocal(loadimplicitclosureinstr.getResult());
    }

    @Override
    public void LoadFrameClosure(LoadFrameClosureInstr loadframeclosureinstr) {
        this.jvmMethod().loadContext();
        this.jvmAdapter().invokevirtual(CodegenUtils.p(ThreadContext.class), "getFrameBlock", CodegenUtils.sig(Block.class, new Class[0]));
        this.jvmStoreLocal(loadframeclosureinstr.getResult());
    }

    @Override
    public void MatchInstr(MatchInstr matchInstr) {
        this.compileCallCommon(this.jvmMethod(), "=~", matchInstr.getCallArgs(), matchInstr.getReceiver(), 1, null, IRBytecodeAdapter.BlockPassType.NONE, CallType.NORMAL, matchInstr.getResult(), false);
    }

    @Override
    public void ModuleVersionGuardInstr(ModuleVersionGuardInstr moduleversionguardinstr) {
        throw new NotCompilableException("Unsupported instruction: " + moduleversionguardinstr);
    }

    @Override
    public void NopInstr(NopInstr nopinstr) {
    }

    @Override
    public void NoResultCallInstr(NoResultCallInstr noResultCallInstr) {
        IRBytecodeAdapter m = this.jvmMethod();
        String name2 = noResultCallInstr.getName();
        Operand[] args2 = noResultCallInstr.getCallArgs();
        Operand receiver2 = noResultCallInstr.getReceiver();
        int numArgs = args2.length;
        Operand closure = noResultCallInstr.getClosureArg(null);
        IRBytecodeAdapter.BlockPassType blockPassType = IRBytecodeAdapter.BlockPassType.fromIR(noResultCallInstr);
        CallType callType = noResultCallInstr.getCallType();
        this.compileCallCommon(m, name2, args2, receiver2, numArgs, closure, blockPassType, callType, null, noResultCallInstr.isPotentiallyRefined());
    }

    public void oneFixnumArgNoBlockCallInstr(OneFixnumArgNoBlockCallInstr oneFixnumArgNoBlockCallInstr) {
        IRBytecodeAdapter m = this.jvmMethod();
        String name2 = oneFixnumArgNoBlockCallInstr.getName();
        long fixnum = oneFixnumArgNoBlockCallInstr.getFixnumArg();
        Operand receiver2 = oneFixnumArgNoBlockCallInstr.getReceiver();
        Variable result2 = oneFixnumArgNoBlockCallInstr.getResult();
        m.loadContext();
        m.loadSelf();
        this.visit(receiver2);
        m.invokeOtherOneFixnum(this.file, this.lastLine, name2, fixnum, oneFixnumArgNoBlockCallInstr.getCallType());
        if (result2 != null) {
            this.jvmStoreLocal(result2);
        } else {
            m.adapter.pop();
        }
    }

    public void oneFloatArgNoBlockCallInstr(OneFloatArgNoBlockCallInstr oneFloatArgNoBlockCallInstr) {
        IRBytecodeAdapter m = this.jvmMethod();
        String name2 = oneFloatArgNoBlockCallInstr.getName();
        double flote = oneFloatArgNoBlockCallInstr.getFloatArg();
        Operand receiver2 = oneFloatArgNoBlockCallInstr.getReceiver();
        Variable result2 = oneFloatArgNoBlockCallInstr.getResult();
        m.loadContext();
        m.loadSelf();
        this.visit(receiver2);
        m.invokeOtherOneFloat(this.file, this.lastLine, name2, flote, oneFloatArgNoBlockCallInstr.getCallType());
        if (result2 != null) {
            this.jvmStoreLocal(result2);
        } else {
            m.adapter.pop();
        }
    }

    @Override
    public void OptArgMultipleAsgnInstr(OptArgMultipleAsgnInstr optargmultipleasgninstr) {
        this.visit(optargmultipleasgninstr.getArray());
        this.jvmAdapter().checkcast(CodegenUtils.p(RubyArray.class));
        this.jvmAdapter().ldc(optargmultipleasgninstr.getMinArgsLength());
        this.jvmAdapter().ldc(optargmultipleasgninstr.getIndex());
        this.jvmAdapter().invokestatic(CodegenUtils.p(IRRuntimeHelpers.class), "extractOptionalArgument", CodegenUtils.sig(IRubyObject.class, RubyArray.class, Integer.TYPE, Integer.TYPE));
        this.jvmStoreLocal(optargmultipleasgninstr.getResult());
    }

    @Override
    public void PopBindingInstr(PopBindingInstr popbindinginstr) {
        this.jvmMethod().loadContext();
        this.jvmMethod().invokeVirtual(Type.getType(ThreadContext.class), Method.getMethod("void popScope()"));
    }

    @Override
    public void PopBlockFrameInstr(PopBlockFrameInstr instr) {
        this.jvmMethod().loadContext();
        this.visit(instr.getFrame());
        this.jvmAdapter().invokevirtual(CodegenUtils.p(ThreadContext.class), "postYieldNoScope", CodegenUtils.sig(Void.TYPE, Frame.class));
    }

    @Override
    public void PopMethodFrameInstr(PopMethodFrameInstr popframeinstr) {
        this.jvmMethod().loadContext();
        this.jvmMethod().invokeVirtual(Type.getType(ThreadContext.class), Method.getMethod("void postMethodFrameOnly()"));
    }

    @Override
    public void PrepareBlockArgsInstr(PrepareBlockArgsInstr instr) {
        this.jvmMethod().loadContext();
        this.jvmMethod().loadSelfBlock();
        this.jvmMethod().loadArgs();
        this.jvmAdapter().ldc(((IRClosure)this.jvm.methodData().scope).receivesKeywordArgs());
        this.jvmMethod().invokeIRHelper("prepareBlockArgs", CodegenUtils.sig(IRubyObject[].class, ThreadContext.class, Block.class, IRubyObject[].class, java.lang.Boolean.TYPE));
        this.jvmMethod().storeArgs();
    }

    @Override
    public void PrepareFixedBlockArgsInstr(PrepareFixedBlockArgsInstr instr) {
        this.jvmMethod().loadContext();
        this.jvmMethod().loadSelfBlock();
        this.jvmMethod().loadArgs();
        this.jvmMethod().invokeIRHelper("prepareFixedBlockArgs", CodegenUtils.sig(IRubyObject[].class, ThreadContext.class, Block.class, IRubyObject[].class));
        this.jvmMethod().storeArgs();
    }

    @Override
    public void PrepareSingleBlockArgInstr(PrepareSingleBlockArgInstr instr) {
        this.jvmMethod().loadContext();
        this.jvmMethod().loadSelfBlock();
        this.jvmMethod().loadArgs();
        this.jvmMethod().invokeIRHelper("prepareSingleBlockArgs", CodegenUtils.sig(IRubyObject[].class, ThreadContext.class, Block.class, IRubyObject[].class));
        this.jvmMethod().storeArgs();
    }

    @Override
    public void PrepareNoBlockArgsInstr(PrepareNoBlockArgsInstr instr) {
        this.jvmMethod().loadContext();
        this.jvmMethod().loadSelfBlock();
        this.jvmMethod().loadArgs();
        this.jvmMethod().invokeIRHelper("prepareNoBlockArgs", CodegenUtils.sig(IRubyObject[].class, ThreadContext.class, Block.class, IRubyObject[].class));
        this.jvmMethod().storeArgs();
    }

    @Override
    public void ProcessModuleBodyInstr(ProcessModuleBodyInstr processmodulebodyinstr) {
        this.jvmMethod().loadContext();
        this.visit(processmodulebodyinstr.getModuleBody());
        this.visit(processmodulebodyinstr.getBlock());
        this.jvmMethod().invokeIRHelper("invokeModuleBody", CodegenUtils.sig(IRubyObject.class, ThreadContext.class, DynamicMethod.class, Block.class));
        this.jvmStoreLocal(processmodulebodyinstr.getResult());
    }

    @Override
    public void PushBlockBindingInstr(PushBlockBindingInstr instr) {
        IRScope scope = this.jvm.methodData().scope;
        boolean reuseParentDynScope = scope.getExecutionContext().getFlags().contains((Object)IRFlags.REUSE_PARENT_DYNSCOPE);
        boolean pushNewDynScope = !scope.getExecutionContext().getFlags().contains((Object)IRFlags.DYNSCOPE_ELIMINATED) && !reuseParentDynScope;
        this.jvmMethod().loadContext();
        this.jvmMethod().loadSelfBlock();
        this.jvmAdapter().ldc(pushNewDynScope);
        this.jvmAdapter().ldc(reuseParentDynScope);
        this.jvmMethod().invokeIRHelper("pushBlockDynamicScopeIfNeeded", CodegenUtils.sig(DynamicScope.class, ThreadContext.class, Block.class, java.lang.Boolean.TYPE, java.lang.Boolean.TYPE));
        this.jvmStoreLocal(DYNAMIC_SCOPE);
    }

    @Override
    public void PushBlockFrameInstr(PushBlockFrameInstr instr) {
        this.jvmMethod().loadContext();
        this.jvmMethod().loadSelfBlock();
        this.jvmAdapter().invokevirtual(CodegenUtils.p(Block.class), "getBinding", CodegenUtils.sig(Binding.class, new Class[0]));
        this.jvmAdapter().invokevirtual(CodegenUtils.p(ThreadContext.class), "preYieldNoScope", CodegenUtils.sig(Frame.class, Binding.class));
        this.jvmStoreLocal(instr.getResult());
    }

    @Override
    public void PushMethodBindingInstr(PushMethodBindingInstr pushbindinginstr) {
        IRScope scope = this.jvm.methodData().scope;
        if (scope.isScriptScope() && scope.getRootLexicalScope() != null) {
            this.jvmMethod().loadContext();
            this.jvmMethod().loadStaticScope();
            this.jvmMethod().invokeIRHelper("prepareScriptScope", CodegenUtils.sig(DynamicScope.class, ThreadContext.class, StaticScope.class));
            this.jvmStoreLocal(DYNAMIC_SCOPE);
            return;
        }
        this.jvmMethod().loadContext();
        this.jvmMethod().loadStaticScope();
        this.jvmAdapter().invokestatic(CodegenUtils.p(DynamicScope.class), "newDynamicScope", CodegenUtils.sig(DynamicScope.class, StaticScope.class));
        this.jvmAdapter().dup();
        this.jvmStoreLocal(DYNAMIC_SCOPE);
        this.jvmMethod().invokeVirtual(Type.getType(ThreadContext.class), Method.getMethod("void pushScope(org.jruby.runtime.DynamicScope)"));
    }

    @Override
    public void RaiseRequiredKeywordArgumentErrorInstr(RaiseRequiredKeywordArgumentError instr) {
        this.jvmMethod().loadContext();
        this.jvmAdapter().ldc(instr.getName());
        this.jvmMethod().invokeIRHelper("newRequiredKeywordArgumentError", CodegenUtils.sig(RaiseException.class, ThreadContext.class, String.class));
        this.jvmAdapter().athrow();
    }

    @Override
    public void PushMethodFrameInstr(PushMethodFrameInstr pushframeinstr) {
        this.jvmMethod().loadContext();
        this.jvmMethod().loadFrameClass();
        this.jvmMethod().loadFrameName();
        this.jvmMethod().loadSelf();
        this.jvmMethod().loadBlock();
        this.jvmMethod().invokeVirtual(Type.getType(ThreadContext.class), Method.getMethod("void preMethodFrameOnly(org.jruby.RubyModule, String, org.jruby.runtime.builtin.IRubyObject, org.jruby.runtime.Block)"));
        this.jvmMethod().loadContext();
        this.jvmAdapter().getstatic(CodegenUtils.p(Visibility.class), "PUBLIC", CodegenUtils.ci(Visibility.class));
        this.jvmAdapter().invokevirtual(CodegenUtils.p(ThreadContext.class), "setCurrentVisibility", CodegenUtils.sig(Void.TYPE, Visibility.class));
    }

    @Override
    public void PutClassVariableInstr(PutClassVariableInstr putclassvariableinstr) {
        this.visit(putclassvariableinstr.getValue());
        this.visit(putclassvariableinstr.getTarget());
        if (putclassvariableinstr.getValue() instanceof CurrentScope) {
            this.jvmAdapter().pop2();
            return;
        }
        this.jvmAdapter().checkcast(CodegenUtils.p(RubyModule.class));
        this.jvmAdapter().swap();
        this.jvmAdapter().ldc(putclassvariableinstr.getRef());
        this.jvmAdapter().swap();
        this.jvmAdapter().invokevirtual(CodegenUtils.p(RubyModule.class), "setClassVar", CodegenUtils.sig(IRubyObject.class, String.class, IRubyObject.class));
        this.jvmAdapter().pop();
    }

    @Override
    public void PutConstInstr(PutConstInstr putconstinstr) {
        IRBytecodeAdapter m = this.jvmMethod();
        this.visit(putconstinstr.getTarget());
        m.adapter.checkcast(CodegenUtils.p(RubyModule.class));
        m.adapter.ldc(putconstinstr.getRef());
        this.visit(putconstinstr.getValue());
        m.adapter.invokevirtual(CodegenUtils.p(RubyModule.class), "setConstant", CodegenUtils.sig(IRubyObject.class, String.class, IRubyObject.class));
        m.adapter.pop();
    }

    @Override
    public void PutFieldInstr(PutFieldInstr putfieldinstr) {
        this.visit(putfieldinstr.getTarget());
        this.visit(putfieldinstr.getValue());
        this.jvmMethod().putField(putfieldinstr.getRef());
    }

    @Override
    public void PutGlobalVarInstr(PutGlobalVarInstr putglobalvarinstr) {
        this.visit(putglobalvarinstr.getValue());
        this.jvmMethod().setGlobalVariable(putglobalvarinstr.getTarget().getName(), this.file, this.lastLine);
    }

    @Override
    public void ReifyClosureInstr(ReifyClosureInstr reifyclosureinstr) {
        this.jvmMethod().loadRuntime();
        this.jvmLoadLocal("$blockArg");
        this.jvmMethod().invokeIRHelper("newProc", CodegenUtils.sig(IRubyObject.class, Ruby.class, Block.class));
        this.jvmStoreLocal(reifyclosureinstr.getResult());
    }

    @Override
    public void ReceiveRubyExceptionInstr(ReceiveRubyExceptionInstr receiveexceptioninstr) {
        this.jvmStoreLocal(receiveexceptioninstr.getResult());
    }

    @Override
    public void ReceiveJRubyExceptionInstr(ReceiveJRubyExceptionInstr receiveexceptioninstr) {
        this.jvmStoreLocal(receiveexceptioninstr.getResult());
    }

    @Override
    public void ReceiveKeywordArgInstr(ReceiveKeywordArgInstr instr) {
        this.jvmMethod().loadContext();
        this.jvmMethod().loadArgs();
        this.jvmAdapter().pushInt(instr.required);
        this.jvmAdapter().ldc(instr.argName);
        this.jvmAdapter().ldc(this.jvm.methodData().scope.receivesKeywordArgs());
        this.jvmMethod().invokeIRHelper("receiveKeywordArg", CodegenUtils.sig(IRubyObject.class, ThreadContext.class, IRubyObject[].class, Integer.TYPE, String.class, java.lang.Boolean.TYPE));
        this.jvmStoreLocal(instr.getResult());
    }

    @Override
    public void ReceiveKeywordRestArgInstr(ReceiveKeywordRestArgInstr instr) {
        this.jvmMethod().loadContext();
        this.jvmMethod().loadArgs();
        this.jvmAdapter().pushInt(instr.required);
        this.jvmAdapter().ldc(this.jvm.methodData().scope.receivesKeywordArgs());
        this.jvmMethod().invokeIRHelper("receiveKeywordRestArg", CodegenUtils.sig(IRubyObject.class, ThreadContext.class, IRubyObject[].class, Integer.TYPE, java.lang.Boolean.TYPE));
        this.jvmStoreLocal(instr.getResult());
    }

    @Override
    public void ReceiveOptArgInstr(ReceiveOptArgInstr instr) {
        this.jvmMethod().loadArgs();
        this.jvmAdapter().pushInt(instr.requiredArgs);
        this.jvmAdapter().pushInt(instr.preArgs);
        this.jvmAdapter().pushInt(instr.getArgIndex());
        this.jvmAdapter().ldc(this.jvm.methodData().scope.receivesKeywordArgs());
        this.jvmMethod().invokeIRHelper("receiveOptArg", CodegenUtils.sig(IRubyObject.class, IRubyObject[].class, Integer.TYPE, Integer.TYPE, Integer.TYPE, java.lang.Boolean.TYPE));
        this.jvmStoreLocal(instr.getResult());
    }

    @Override
    public void ReceivePreReqdArgInstr(ReceivePreReqdArgInstr instr) {
        if (this.jvm.methodData().specificArity >= 0 && instr.getArgIndex() < this.jvm.methodData().specificArity) {
            this.jvmAdapter().aload(this.jvm.methodData().signature.argOffset("arg" + instr.getArgIndex()));
        } else {
            this.jvmMethod().loadContext();
            this.jvmMethod().loadArgs();
            this.jvmAdapter().pushInt(instr.getArgIndex());
            this.jvmMethod().invokeIRHelper("getPreArgSafe", CodegenUtils.sig(IRubyObject.class, ThreadContext.class, IRubyObject[].class, Integer.TYPE));
        }
        this.jvmStoreLocal(instr.getResult());
    }

    @Override
    public void ReceivePostReqdArgInstr(ReceivePostReqdArgInstr instr) {
        this.jvmMethod().loadContext();
        this.jvmMethod().loadArgs();
        this.jvmAdapter().pushInt(instr.preReqdArgsCount);
        this.jvmAdapter().pushInt(instr.optArgsCount);
        this.jvmAdapter().pushBoolean(instr.restArg);
        this.jvmAdapter().pushInt(instr.postReqdArgsCount);
        this.jvmAdapter().pushInt(instr.getArgIndex());
        this.jvmAdapter().ldc(this.jvm.methodData().scope.receivesKeywordArgs());
        this.jvmMethod().invokeIRHelper("receivePostReqdArg", CodegenUtils.sig(IRubyObject.class, ThreadContext.class, IRubyObject[].class, Integer.TYPE, Integer.TYPE, java.lang.Boolean.TYPE, Integer.TYPE, Integer.TYPE, java.lang.Boolean.TYPE));
        this.jvmStoreLocal(instr.getResult());
    }

    @Override
    public void ReceiveRestArgInstr(ReceiveRestArgInstr instr) {
        this.jvmMethod().loadContext();
        this.jvmMethod().loadArgs();
        this.jvmAdapter().pushInt(instr.required);
        this.jvmAdapter().pushInt(instr.getArgIndex());
        this.jvmAdapter().ldc(this.jvm.methodData().scope.receivesKeywordArgs());
        this.jvmMethod().invokeIRHelper("receiveRestArg", CodegenUtils.sig(IRubyObject.class, ThreadContext.class, Object[].class, Integer.TYPE, Integer.TYPE, java.lang.Boolean.TYPE));
        this.jvmStoreLocal(instr.getResult());
    }

    @Override
    public void ReceiveSelfInstr(ReceiveSelfInstr receiveselfinstr) {
    }

    @Override
    public void RecordEndBlockInstr(RecordEndBlockInstr recordEndBlockInstr) {
        this.jvmMethod().loadContext();
        this.jvmMethod().loadContext();
        this.visit(recordEndBlockInstr.getEndBlockClosure());
        this.jvmMethod().invokeIRHelper("getBlockFromObject", CodegenUtils.sig(Block.class, ThreadContext.class, Object.class));
        this.jvmMethod().invokeIRHelper("pushExitBlock", CodegenUtils.sig(Void.TYPE, ThreadContext.class, Block.class));
    }

    @Override
    public void ReqdArgMultipleAsgnInstr(ReqdArgMultipleAsgnInstr reqdargmultipleasgninstr) {
        this.jvmMethod().loadContext();
        this.visit(reqdargmultipleasgninstr.getArray());
        this.jvmAdapter().checkcast(CodegenUtils.p(RubyArray.class));
        this.jvmAdapter().pushInt(reqdargmultipleasgninstr.getPreArgsCount());
        this.jvmAdapter().pushInt(reqdargmultipleasgninstr.getIndex());
        this.jvmAdapter().pushInt(reqdargmultipleasgninstr.getPostArgsCount());
        this.jvmMethod().invokeIRHelper("irReqdArgMultipleAsgn", CodegenUtils.sig(IRubyObject.class, ThreadContext.class, RubyArray.class, Integer.TYPE, Integer.TYPE, Integer.TYPE));
        this.jvmStoreLocal(reqdargmultipleasgninstr.getResult());
    }

    @Override
    public void RescueEQQInstr(RescueEQQInstr rescueeqqinstr) {
        this.jvmMethod().loadContext();
        this.visit(rescueeqqinstr.getArg1());
        this.visit(rescueeqqinstr.getArg2());
        this.jvmMethod().invokeIRHelper("isExceptionHandled", CodegenUtils.sig(IRubyObject.class, ThreadContext.class, IRubyObject.class, Object.class));
        this.jvmStoreLocal(rescueeqqinstr.getResult());
    }

    @Override
    public void RestArgMultipleAsgnInstr(RestArgMultipleAsgnInstr restargmultipleasgninstr) {
        this.jvmMethod().loadContext();
        this.visit(restargmultipleasgninstr.getArray());
        this.jvmAdapter().checkcast(CodegenUtils.p(RubyArray.class));
        this.jvmAdapter().pushInt(restargmultipleasgninstr.getPreArgsCount());
        this.jvmAdapter().pushInt(restargmultipleasgninstr.getPostArgsCount());
        this.jvmAdapter().invokestatic(CodegenUtils.p(Helpers.class), "viewArgsArray", CodegenUtils.sig(RubyArray.class, ThreadContext.class, RubyArray.class, Integer.TYPE, Integer.TYPE));
        this.jvmStoreLocal(restargmultipleasgninstr.getResult());
    }

    @Override
    public void RestoreBindingVisibilityInstr(RestoreBindingVisibilityInstr instr) {
        this.jvmMethod().loadSelfBlock();
        this.jvmAdapter().invokevirtual(CodegenUtils.p(Block.class), "getBinding", CodegenUtils.sig(Binding.class, new Class[0]));
        this.jvmAdapter().invokevirtual(CodegenUtils.p(Binding.class), "getFrame", CodegenUtils.sig(Frame.class, new Class[0]));
        this.visit(instr.getVisibility());
        this.jvmAdapter().invokevirtual(CodegenUtils.p(Frame.class), "setVisibility", CodegenUtils.sig(Void.TYPE, Visibility.class));
    }

    @Override
    public void ReturnOrRethrowSavedExcInstr(ReturnOrRethrowSavedExcInstr instr) {
        this.jvmMethod().loadContext();
        this.visit(instr.getReturnValue());
        this.jvmMethod().invokeIRHelper("returnOrRethrowSavedException", CodegenUtils.sig(IRubyObject.class, ThreadContext.class, IRubyObject.class));
        this.jvmMethod().returnValue();
    }

    @Override
    public void RuntimeHelperCall(RuntimeHelperCall runtimehelpercall) {
        switch (runtimehelpercall.getHelperMethod()) {
            case HANDLE_PROPAGATED_BREAK: {
                this.jvmMethod().loadContext();
                this.jvmLoadLocal(DYNAMIC_SCOPE);
                this.visit(runtimehelpercall.getArgs()[0]);
                this.jvmMethod().loadBlockType();
                this.jvmAdapter().invokestatic(CodegenUtils.p(IRRuntimeHelpers.class), "handlePropagatedBreak", CodegenUtils.sig(IRubyObject.class, ThreadContext.class, DynamicScope.class, Object.class, Block.Type.class));
                this.jvmStoreLocal(runtimehelpercall.getResult());
                break;
            }
            case HANDLE_NONLOCAL_RETURN: {
                this.jvmMethod().loadStaticScope();
                this.jvmLoadLocal(DYNAMIC_SCOPE);
                this.visit(runtimehelpercall.getArgs()[0]);
                this.jvmMethod().loadBlockType();
                this.jvmAdapter().invokestatic(CodegenUtils.p(IRRuntimeHelpers.class), "handleNonlocalReturn", CodegenUtils.sig(IRubyObject.class, StaticScope.class, DynamicScope.class, Object.class, Block.Type.class));
                this.jvmStoreLocal(runtimehelpercall.getResult());
                break;
            }
            case HANDLE_BREAK_AND_RETURNS_IN_LAMBDA: {
                this.jvmMethod().loadContext();
                this.jvmMethod().loadStaticScope();
                this.jvmLoadLocal(DYNAMIC_SCOPE);
                this.visit(runtimehelpercall.getArgs()[0]);
                this.jvmMethod().loadBlockType();
                this.jvmAdapter().invokestatic(CodegenUtils.p(IRRuntimeHelpers.class), "handleBreakAndReturnsInLambdas", CodegenUtils.sig(IRubyObject.class, ThreadContext.class, StaticScope.class, DynamicScope.class, Object.class, Block.Type.class));
                this.jvmStoreLocal(runtimehelpercall.getResult());
                break;
            }
            case IS_DEFINED_BACKREF: {
                this.jvmMethod().loadContext();
                this.visit(runtimehelpercall.getArgs()[0]);
                this.jvmAdapter().invokestatic(CodegenUtils.p(IRRuntimeHelpers.class), "isDefinedBackref", CodegenUtils.sig(IRubyObject.class, ThreadContext.class, IRubyObject.class));
                this.jvmStoreLocal(runtimehelpercall.getResult());
                break;
            }
            case IS_DEFINED_CALL: {
                this.jvmMethod().loadContext();
                this.jvmMethod().loadSelf();
                this.visit(runtimehelpercall.getArgs()[0]);
                this.jvmAdapter().ldc(((StringLiteral)runtimehelpercall.getArgs()[1]).getString());
                this.visit(runtimehelpercall.getArgs()[2]);
                this.jvmAdapter().invokestatic(CodegenUtils.p(IRRuntimeHelpers.class), "isDefinedCall", CodegenUtils.sig(IRubyObject.class, ThreadContext.class, IRubyObject.class, IRubyObject.class, String.class, IRubyObject.class));
                this.jvmStoreLocal(runtimehelpercall.getResult());
                break;
            }
            case IS_DEFINED_CONSTANT_OR_METHOD: {
                this.jvmMethod().loadContext();
                this.visit(runtimehelpercall.getArgs()[0]);
                this.jvmAdapter().ldc(((Stringable)((Object)runtimehelpercall.getArgs()[1])).getString());
                this.visit(runtimehelpercall.getArgs()[2]);
                this.visit(runtimehelpercall.getArgs()[3]);
                this.jvmAdapter().invokestatic(CodegenUtils.p(IRRuntimeHelpers.class), "isDefinedConstantOrMethod", CodegenUtils.sig(IRubyObject.class, ThreadContext.class, IRubyObject.class, String.class, IRubyObject.class, IRubyObject.class));
                this.jvmStoreLocal(runtimehelpercall.getResult());
                break;
            }
            case IS_DEFINED_NTH_REF: {
                this.jvmMethod().loadContext();
                this.jvmAdapter().ldc((int)((Fixnum)runtimehelpercall.getArgs()[0]).getValue());
                this.visit(runtimehelpercall.getArgs()[1]);
                this.jvmAdapter().invokestatic(CodegenUtils.p(IRRuntimeHelpers.class), "isDefinedNthRef", CodegenUtils.sig(IRubyObject.class, ThreadContext.class, Integer.TYPE, IRubyObject.class));
                this.jvmStoreLocal(runtimehelpercall.getResult());
                break;
            }
            case IS_DEFINED_GLOBAL: {
                this.jvmMethod().loadContext();
                this.jvmAdapter().ldc(((Stringable)((Object)runtimehelpercall.getArgs()[0])).getString());
                this.visit(runtimehelpercall.getArgs()[1]);
                this.jvmAdapter().invokestatic(CodegenUtils.p(IRRuntimeHelpers.class), "isDefinedGlobal", CodegenUtils.sig(IRubyObject.class, ThreadContext.class, String.class, IRubyObject.class));
                this.jvmStoreLocal(runtimehelpercall.getResult());
                break;
            }
            case IS_DEFINED_INSTANCE_VAR: {
                this.jvmMethod().loadContext();
                this.visit(runtimehelpercall.getArgs()[0]);
                this.jvmAdapter().ldc(((Stringable)((Object)runtimehelpercall.getArgs()[1])).getString());
                this.visit(runtimehelpercall.getArgs()[2]);
                this.jvmAdapter().invokestatic(CodegenUtils.p(IRRuntimeHelpers.class), "isDefinedInstanceVar", CodegenUtils.sig(IRubyObject.class, ThreadContext.class, IRubyObject.class, String.class, IRubyObject.class));
                this.jvmStoreLocal(runtimehelpercall.getResult());
                break;
            }
            case IS_DEFINED_CLASS_VAR: {
                this.jvmMethod().loadContext();
                this.visit(runtimehelpercall.getArgs()[0]);
                this.jvmAdapter().checkcast(CodegenUtils.p(RubyModule.class));
                this.jvmAdapter().ldc(((Stringable)((Object)runtimehelpercall.getArgs()[1])).getString());
                this.visit(runtimehelpercall.getArgs()[2]);
                this.jvmAdapter().invokestatic(CodegenUtils.p(IRRuntimeHelpers.class), "isDefinedClassVar", CodegenUtils.sig(IRubyObject.class, ThreadContext.class, RubyModule.class, String.class, IRubyObject.class));
                this.jvmStoreLocal(runtimehelpercall.getResult());
                break;
            }
            case IS_DEFINED_SUPER: {
                this.jvmMethod().loadContext();
                this.visit(runtimehelpercall.getArgs()[0]);
                this.jvmMethod().loadFrameName();
                this.jvmMethod().loadFrameClass();
                this.visit(runtimehelpercall.getArgs()[1]);
                this.jvmAdapter().invokestatic(CodegenUtils.p(IRRuntimeHelpers.class), "isDefinedSuper", CodegenUtils.sig(IRubyObject.class, ThreadContext.class, IRubyObject.class, String.class, RubyModule.class, IRubyObject.class));
                this.jvmStoreLocal(runtimehelpercall.getResult());
                break;
            }
            case IS_DEFINED_METHOD: {
                this.jvmMethod().loadContext();
                this.visit(runtimehelpercall.getArgs()[0]);
                this.jvmAdapter().ldc(((Stringable)((Object)runtimehelpercall.getArgs()[1])).getString());
                this.jvmAdapter().ldc(((Boolean)runtimehelpercall.getArgs()[2]).isTrue());
                this.visit(runtimehelpercall.getArgs()[3]);
                this.jvmAdapter().invokestatic(CodegenUtils.p(IRRuntimeHelpers.class), "isDefinedMethod", CodegenUtils.sig(IRubyObject.class, ThreadContext.class, IRubyObject.class, String.class, java.lang.Boolean.TYPE, IRubyObject.class));
                this.jvmStoreLocal(runtimehelpercall.getResult());
                break;
            }
            case MERGE_KWARGS: {
                this.jvmMethod().loadContext();
                this.visit(runtimehelpercall.getArgs()[0]);
                this.visit(runtimehelpercall.getArgs()[1]);
                this.jvmAdapter().invokestatic(CodegenUtils.p(IRRuntimeHelpers.class), "mergeKeywordArguments", CodegenUtils.sig(IRubyObject.class, ThreadContext.class, IRubyObject.class, IRubyObject.class));
                this.jvmStoreLocal(runtimehelpercall.getResult());
                break;
            }
            case RESTORE_EXCEPTION_VAR: {
                this.jvmMethod().loadContext();
                this.visit(runtimehelpercall.getArgs()[0]);
                this.visit(runtimehelpercall.getArgs()[1]);
                this.jvmAdapter().invokestatic(CodegenUtils.p(IRRuntimeHelpers.class), "restoreExceptionVar", CodegenUtils.sig(IRubyObject.class, ThreadContext.class, IRubyObject.class, IRubyObject.class));
                this.jvmStoreLocal(runtimehelpercall.getResult());
                break;
            }
            default: {
                throw new NotCompilableException("Unknown IR runtime helper method: " + (Object)((Object)runtimehelpercall.getHelperMethod()) + "; INSTR: " + this);
            }
        }
    }

    @Override
    public void SaveBindingVisibilityInstr(SaveBindingVisibilityInstr instr) {
        this.jvmMethod().loadSelfBlock();
        this.jvmAdapter().invokevirtual(CodegenUtils.p(Block.class), "getBinding", CodegenUtils.sig(Binding.class, new Class[0]));
        this.jvmAdapter().invokevirtual(CodegenUtils.p(Binding.class), "getFrame", CodegenUtils.sig(Frame.class, new Class[0]));
        this.jvmAdapter().invokevirtual(CodegenUtils.p(Frame.class), "getVisibility", CodegenUtils.sig(Visibility.class, new Class[0]));
        this.jvmStoreLocal(instr.getResult());
    }

    @Override
    public void ToggleBacktraceInstr(ToggleBacktraceInstr instr) {
        this.jvmMethod().loadContext();
        this.jvmAdapter().pushBoolean(instr.requiresBacktrace());
        this.jvmAdapter().invokevirtual(CodegenUtils.p(ThreadContext.class), "setExceptionRequiresBacktrace", CodegenUtils.sig(Void.TYPE, java.lang.Boolean.TYPE));
    }

    @Override
    public void NonlocalReturnInstr(NonlocalReturnInstr returninstr) {
        this.jvmMethod().loadContext();
        this.jvmLoadLocal(DYNAMIC_SCOPE);
        this.jvmMethod().loadSelfBlock();
        this.visit(returninstr.getReturnValue());
        this.jvmMethod().invokeIRHelper("initiateNonLocalReturn", CodegenUtils.sig(IRubyObject.class, ThreadContext.class, DynamicScope.class, Block.class, IRubyObject.class));
        this.jvmMethod().returnValue();
    }

    @Override
    public void ReturnInstr(ReturnInstr returninstr) {
        this.visit(returninstr.getReturnValue());
        this.jvmMethod().returnValue();
    }

    @Override
    public void SearchConstInstr(SearchConstInstr searchconstinstr) {
        this.jvmMethod().loadContext();
        this.visit(searchconstinstr.getStartingScope());
        this.jvmMethod().searchConst(searchconstinstr.getConstName(), searchconstinstr.isNoPrivateConsts());
        this.jvmStoreLocal(searchconstinstr.getResult());
    }

    @Override
    public void SearchModuleForConstInstr(SearchModuleForConstInstr instr) {
        this.jvmMethod().loadContext();
        this.visit(instr.getCurrentModule());
        this.jvmMethod().searchModuleForConst(instr.getConstName(), instr.isNoPrivateConsts(), instr.callConstMissing());
        this.jvmStoreLocal(instr.getResult());
    }

    @Override
    public void SetCapturedVarInstr(SetCapturedVarInstr instr) {
        this.jvmMethod().loadContext();
        this.visit(instr.getMatch2Result());
        this.jvmAdapter().ldc(instr.getVarName());
        this.jvmMethod().invokeIRHelper("setCapturedVar", CodegenUtils.sig(IRubyObject.class, ThreadContext.class, IRubyObject.class, String.class));
        this.jvmStoreLocal(instr.getResult());
    }

    @Override
    public void StoreLocalVarInstr(StoreLocalVarInstr storelocalvarinstr) {
        IRBytecodeAdapter m = this.jvmMethod();
        this.jvmLoadLocal(DYNAMIC_SCOPE);
        int depth = storelocalvarinstr.getLocalVar().getScopeDepth();
        int location = storelocalvarinstr.getLocalVar().getLocation();
        Operand storeValue = storelocalvarinstr.getValue();
        switch (depth) {
            case 0: {
                switch (location) {
                    case 0: {
                        storeValue.visit(this);
                        m.adapter.invokevirtual(CodegenUtils.p(DynamicScope.class), "setValueZeroDepthZero", CodegenUtils.sig(IRubyObject.class, IRubyObject.class));
                        m.adapter.pop();
                        return;
                    }
                    case 1: {
                        storeValue.visit(this);
                        m.adapter.invokevirtual(CodegenUtils.p(DynamicScope.class), "setValueOneDepthZero", CodegenUtils.sig(IRubyObject.class, IRubyObject.class));
                        m.adapter.pop();
                        return;
                    }
                    case 2: {
                        storeValue.visit(this);
                        m.adapter.invokevirtual(CodegenUtils.p(DynamicScope.class), "setValueTwoDepthZero", CodegenUtils.sig(IRubyObject.class, IRubyObject.class));
                        m.adapter.pop();
                        return;
                    }
                    case 3: {
                        storeValue.visit(this);
                        m.adapter.invokevirtual(CodegenUtils.p(DynamicScope.class), "setValueThreeDepthZero", CodegenUtils.sig(IRubyObject.class, IRubyObject.class));
                        m.adapter.pop();
                        return;
                    }
                }
                storeValue.visit(this);
                m.adapter.pushInt(location);
                m.adapter.invokevirtual(CodegenUtils.p(DynamicScope.class), "setValueDepthZero", CodegenUtils.sig(IRubyObject.class, IRubyObject.class, Integer.TYPE));
                m.adapter.pop();
                return;
            }
        }
        m.adapter.pushInt(location);
        storeValue.visit(this);
        m.adapter.pushInt(depth);
        m.adapter.invokevirtual(CodegenUtils.p(DynamicScope.class), "setValue", CodegenUtils.sig(IRubyObject.class, Integer.TYPE, IRubyObject.class, Integer.TYPE));
        m.adapter.pop();
    }

    @Override
    public void ThreadPollInstr(ThreadPollInstr threadpollinstr) {
        this.jvmMethod().checkpoint();
    }

    @Override
    public void ThrowExceptionInstr(ThrowExceptionInstr throwexceptioninstr) {
        this.visit(throwexceptioninstr.getException());
        this.jvmAdapter().athrow();
    }

    @Override
    public void ToAryInstr(ToAryInstr toaryinstr) {
        this.jvmMethod().loadContext();
        this.visit(toaryinstr.getArray());
        this.jvmMethod().invokeIRHelper("irToAry", CodegenUtils.sig(IRubyObject.class, ThreadContext.class, IRubyObject.class));
        this.jvmStoreLocal(toaryinstr.getResult());
    }

    @Override
    public void TraceInstr(TraceInstr traceInstr) {
        this.jvmMethod().loadContext();
        this.jvmAdapter().getstatic(CodegenUtils.p(RubyEvent.class), traceInstr.getEvent().name(), CodegenUtils.ci(RubyEvent.class));
        String name2 = traceInstr.getName();
        if (name2 == null) {
            this.jvmAdapter().aconst_null();
        } else {
            this.jvmAdapter().ldc(name2);
        }
        this.jvmAdapter().ldc(traceInstr.getFilename());
        this.jvmAdapter().ldc(traceInstr.getLinenumber());
        this.jvmMethod().invokeIRHelper("callTrace", CodegenUtils.sig(Void.TYPE, ThreadContext.class, RubyEvent.class, String.class, String.class, Integer.TYPE));
    }

    @Override
    public void UndefMethodInstr(UndefMethodInstr undefmethodinstr) {
        this.jvmMethod().loadContext();
        this.visit(undefmethodinstr.getMethodName());
        this.jvmLoadLocal(DYNAMIC_SCOPE);
        this.jvmMethod().loadSelf();
        this.jvmMethod().invokeIRHelper("undefMethod", CodegenUtils.sig(IRubyObject.class, ThreadContext.class, Object.class, DynamicScope.class, IRubyObject.class));
        this.jvmStoreLocal(undefmethodinstr.getResult());
    }

    @Override
    public void UnresolvedSuperInstr(UnresolvedSuperInstr unresolvedsuperinstr) {
        String name2 = unresolvedsuperinstr.getName();
        Operand[] args2 = unresolvedsuperinstr.getCallArgs();
        UndefinedValue definingModule = UndefinedValue.UNDEFINED;
        boolean[] splatMap = unresolvedsuperinstr.splatMap();
        Operand closure = unresolvedsuperinstr.getClosureArg(null);
        this.superCommon(name2, unresolvedsuperinstr, args2, definingModule, splatMap, closure);
    }

    @Override
    public void UpdateBlockExecutionStateInstr(UpdateBlockExecutionStateInstr instr) {
        this.jvmMethod().loadSelfBlock();
        this.jvmMethod().loadSelf();
        this.jvmMethod().invokeIRHelper("updateBlockState", CodegenUtils.sig(IRubyObject.class, Block.class, IRubyObject.class));
        this.jvmMethod().storeSelf();
    }

    @Override
    public void YieldInstr(YieldInstr yieldinstr) {
        this.jvmMethod().loadContext();
        this.visit(yieldinstr.getBlockArg());
        if (yieldinstr.getYieldArg() == UndefinedValue.UNDEFINED) {
            this.jvmMethod().yieldSpecific();
        } else {
            Operand yieldOp = yieldinstr.getYieldArg();
            if (yieldinstr.isUnwrapArray() && yieldOp instanceof Array && ((Array)yieldOp).size() > 1) {
                Array yieldValues = (Array)yieldOp;
                for (Operand yieldValue : yieldValues) {
                    this.visit(yieldValue);
                }
                this.jvmMethod().yieldValues(yieldValues.size());
            } else {
                this.visit(yieldinstr.getYieldArg());
                this.jvmMethod().yield(yieldinstr.isUnwrapArray());
            }
        }
        this.jvmStoreLocal(yieldinstr.getResult());
    }

    @Override
    public void ZSuperInstr(ZSuperInstr zsuperinstr) {
        String name2 = zsuperinstr.getName();
        Operand[] args2 = zsuperinstr.getCallArgs();
        UndefinedValue definingModule = UndefinedValue.UNDEFINED;
        boolean[] splatMap = zsuperinstr.splatMap();
        Operand closure = zsuperinstr.getClosureArg(null);
        this.superCommon(name2, zsuperinstr, args2, definingModule, splatMap, closure);
    }

    @Override
    public void GetErrorInfoInstr(GetErrorInfoInstr geterrorinfoinstr) {
        this.jvmMethod().loadContext();
        this.jvmAdapter().invokevirtual(CodegenUtils.p(ThreadContext.class), "getErrorInfo", CodegenUtils.sig(IRubyObject.class, new Class[0]));
        this.jvmStoreLocal(geterrorinfoinstr.getResult());
    }

    @Override
    public void RestoreErrorInfoInstr(RestoreErrorInfoInstr restoreerrorinfoinstr) {
        this.jvmMethod().loadContext();
        this.visit(restoreerrorinfoinstr.getArg());
        this.jvmAdapter().invokevirtual(CodegenUtils.p(ThreadContext.class), "setErrorInfo", CodegenUtils.sig(IRubyObject.class, IRubyObject.class));
        this.jvmAdapter().pop();
    }

    @Override
    public void BuildLambdaInstr(BuildLambdaInstr buildlambdainstr) {
        this.jvmMethod().loadRuntime();
        IRClosure body = ((WrappedIRClosure)buildlambdainstr.getLambdaBody()).getClosure();
        if (body == null) {
            this.jvmMethod().pushNil();
        } else {
            this.visit(buildlambdainstr.getLambdaBody());
        }
        this.jvmAdapter().getstatic(CodegenUtils.p(Block.Type.class), "LAMBDA", CodegenUtils.ci(Block.Type.class));
        this.jvmAdapter().ldc(buildlambdainstr.getFile());
        this.jvmAdapter().pushInt(buildlambdainstr.getLine());
        this.jvmAdapter().invokestatic(CodegenUtils.p(RubyProc.class), "newProc", CodegenUtils.sig(RubyProc.class, Ruby.class, Block.class, Block.Type.class, String.class, Integer.TYPE));
        this.jvmStoreLocal(buildlambdainstr.getResult());
    }

    @Override
    public void GetEncodingInstr(GetEncodingInstr getencodinginstr) {
        this.jvmMethod().loadContext();
        this.jvmMethod().pushEncoding(getencodinginstr.getEncoding());
        this.jvmStoreLocal(getencodinginstr.getResult());
    }

    @Override
    public void Array(Array array) {
        this.jvmMethod().loadContext();
        for (Operand operand : array.getElts()) {
            this.visit(operand);
        }
        this.jvmMethod().array(array.getElts().length);
    }

    @Override
    public void AsString(AsString asstring) {
        this.visit(asstring.getSource());
        this.jvmAdapter().invokeinterface(CodegenUtils.p(IRubyObject.class), "asString", CodegenUtils.sig(RubyString.class, new Class[0]));
    }

    @Override
    public void Bignum(Bignum bignum) {
        this.jvmMethod().pushBignum(bignum.value);
    }

    @Override
    public void Boolean(Boolean booleanliteral) {
        this.jvmMethod().pushBoolean(booleanliteral.isTrue());
    }

    @Override
    public void UnboxedBoolean(UnboxedBoolean bool2) {
        this.jvmAdapter().ldc(bool2.isTrue());
    }

    @Override
    public void ClosureLocalVariable(ClosureLocalVariable closurelocalvariable) {
        this.LocalVariable(closurelocalvariable);
    }

    @Override
    public void Complex(Complex complex) {
        this.jvmMethod().loadRuntime();
        this.jvmMethod().pushFixnum(0L);
        this.visit(complex.getNumber());
        this.jvmAdapter().invokestatic(CodegenUtils.p(RubyComplex.class), "newComplexRaw", CodegenUtils.sig(RubyComplex.class, Ruby.class, IRubyObject.class, IRubyObject.class));
    }

    @Override
    public void CurrentScope(CurrentScope currentscope) {
        this.jvmMethod().loadStaticScope();
    }

    @Override
    public void DynamicSymbol(DynamicSymbol dynamicsymbol) {
        this.jvmMethod().loadRuntime();
        this.visit(dynamicsymbol.getSymbolName());
        this.jvmAdapter().dup();
        this.jvmAdapter().invokeinterface(CodegenUtils.p(IRubyObject.class), "asJavaString", CodegenUtils.sig(String.class, new Class[0]));
        this.jvmAdapter().swap();
        this.jvmAdapter().invokeinterface(CodegenUtils.p(IRubyObject.class), "asString", CodegenUtils.sig(RubyString.class, new Class[0]));
        this.jvmAdapter().invokevirtual(CodegenUtils.p(RubyString.class), "getByteList", CodegenUtils.sig(ByteList.class, new Class[0]));
        this.jvmAdapter().invokevirtual(CodegenUtils.p(ByteList.class), "getEncoding", CodegenUtils.sig(Encoding.class, new Class[0]));
        this.jvmAdapter().invokevirtual(CodegenUtils.p(Ruby.class), "newSymbol", CodegenUtils.sig(RubySymbol.class, String.class, Encoding.class));
    }

    @Override
    public void Filename(Filename filename2) {
        this.jvmMethod().loadRuntime();
        this.jvmMethod().loadStaticScope();
        this.jvmAdapter().invokevirtual(CodegenUtils.p(StaticScope.class), "getIRScope", CodegenUtils.sig(IRScope.class, new Class[0]));
        this.jvmAdapter().invokevirtual(CodegenUtils.p(IRScope.class), "getFileName", CodegenUtils.sig(String.class, new Class[0]));
        this.jvmAdapter().invokevirtual(CodegenUtils.p(Ruby.class), "newString", CodegenUtils.sig(RubyString.class, String.class));
    }

    @Override
    public void Fixnum(Fixnum fixnum) {
        this.jvmMethod().pushFixnum(fixnum.getValue());
    }

    @Override
    public void FrozenString(FrozenString frozen) {
        this.jvmMethod().pushFrozenString(frozen.getByteList(), frozen.getCodeRange(), frozen.getFile(), frozen.getLine());
    }

    @Override
    public void UnboxedFixnum(UnboxedFixnum fixnum) {
        this.jvmAdapter().ldc(fixnum.getValue());
    }

    @Override
    public void Float(Float flote) {
        this.jvmMethod().pushFloat(flote.getValue());
    }

    @Override
    public void UnboxedFloat(UnboxedFloat flote) {
        this.jvmAdapter().ldc(flote.getValue());
    }

    @Override
    public void Hash(Hash hash2) {
        List<KeyValuePair<Operand, Operand>> pairs = hash2.getPairs();
        Iterator<KeyValuePair<Operand, Operand>> iter = pairs.iterator();
        boolean kwargs = hash2.isKWArgsHash && pairs.get(0).getKey() == Symbol.KW_REST_ARG_DUMMY;
        this.jvmMethod().loadContext();
        if (kwargs) {
            this.visit(pairs.get(0).getValue());
            this.jvmAdapter().checkcast(CodegenUtils.p(RubyHash.class));
            iter.next();
        }
        while (iter.hasNext()) {
            KeyValuePair<Operand, Operand> pair = iter.next();
            this.visit(pair.getKey());
            this.visit(pair.getValue());
        }
        if (kwargs) {
            this.jvmMethod().kwargsHash(pairs.size() - 1);
        } else {
            this.jvmMethod().hash(pairs.size());
        }
    }

    @Override
    public void LocalVariable(LocalVariable localvariable) {
        IRBytecodeAdapter m = this.jvmMethod();
        int depth = localvariable.getScopeDepth();
        int location = localvariable.getLocation();
        if (this.jvm.methodData().scope instanceof IRMethod) {
            this.jvmLoadLocal(DYNAMIC_SCOPE);
            if (depth == 0) {
                if (location < DynamicScopeGenerator.SPECIALIZED_GETS.size()) {
                    m.adapter.invokevirtual(CodegenUtils.p(DynamicScope.class), DynamicScopeGenerator.SPECIALIZED_GETS.get(location), CodegenUtils.sig(IRubyObject.class, new Class[0]));
                } else {
                    m.adapter.pushInt(location);
                    m.adapter.invokevirtual(CodegenUtils.p(DynamicScope.class), "getValueDepthZero", CodegenUtils.sig(IRubyObject.class, Integer.TYPE));
                }
            } else {
                m.adapter.pushInt(location);
                m.adapter.pushInt(depth);
                m.adapter.invokevirtual(CodegenUtils.p(DynamicScope.class), "getValue", CodegenUtils.sig(IRubyObject.class, Integer.TYPE, Integer.TYPE));
            }
        } else {
            this.jvmLoadLocal(DYNAMIC_SCOPE);
            if (depth == 0) {
                if (location < DynamicScopeGenerator.SPECIALIZED_GETS_OR_NIL.size()) {
                    m.pushNil();
                    m.adapter.invokevirtual(CodegenUtils.p(DynamicScope.class), DynamicScopeGenerator.SPECIALIZED_GETS_OR_NIL.get(location), CodegenUtils.sig(IRubyObject.class, IRubyObject.class));
                } else {
                    m.adapter.pushInt(location);
                    m.pushNil();
                    m.adapter.invokevirtual(CodegenUtils.p(DynamicScope.class), "getValueDepthZeroOrNil", CodegenUtils.sig(IRubyObject.class, Integer.TYPE, IRubyObject.class));
                }
            } else {
                m.adapter.pushInt(location);
                m.adapter.pushInt(depth);
                m.pushNil();
                m.adapter.invokevirtual(CodegenUtils.p(DynamicScope.class), "getValueOrNil", CodegenUtils.sig(IRubyObject.class, Integer.TYPE, Integer.TYPE, IRubyObject.class));
            }
        }
    }

    @Override
    public void Nil(Nil nil) {
        this.jvmMethod().pushNil();
    }

    @Override
    public void NthRef(NthRef nthref) {
        this.jvmMethod().loadContext();
        this.jvmAdapter().pushInt(nthref.matchNumber);
        this.jvmMethod().invokeIRHelper("nthMatch", CodegenUtils.sig(IRubyObject.class, ThreadContext.class, Integer.TYPE));
    }

    @Override
    public void NullBlock(NullBlock nullblock) {
        this.jvmAdapter().getstatic(CodegenUtils.p(Block.class), "NULL_BLOCK", CodegenUtils.ci(Block.class));
    }

    @Override
    public void ObjectClass(ObjectClass objectclass) {
        this.jvmMethod().pushObjectClass();
    }

    @Override
    public void Rational(Rational rational) {
        this.jvmMethod().loadRuntime();
        this.visit(rational.getNumerator());
        this.visit(rational.getDenominator());
        this.jvmAdapter().invokestatic(CodegenUtils.p(RubyRational.class), "newRationalRaw", CodegenUtils.sig(RubyRational.class, Ruby.class, IRubyObject.class, IRubyObject.class));
    }

    @Override
    public void Regexp(Regexp regexp2) {
        this.jvmMethod().pushRegexp(regexp2.getSource(), regexp2.options.toEmbeddedOptions());
    }

    @Override
    public void ScopeModule(ScopeModule scopemodule) {
        this.jvmMethod().loadStaticScope();
        this.jvmAdapter().pushInt(scopemodule.getScopeModuleDepth());
        this.jvmAdapter().invokestatic(CodegenUtils.p(Helpers.class), "getNthScopeModule", CodegenUtils.sig(RubyModule.class, StaticScope.class, Integer.TYPE));
    }

    @Override
    public void Self(Self self2) {
        this.jvmMethod().loadSelf();
    }

    @Override
    public void Splat(Splat splat) {
        this.visit(splat.getArray());
    }

    @Override
    public void StandardError(StandardError standarderror) {
        this.jvmMethod().loadRuntime();
        this.jvmAdapter().invokevirtual(CodegenUtils.p(Ruby.class), "getStandardError", CodegenUtils.sig(RubyClass.class, new Class[0]));
    }

    @Override
    public void StringLiteral(StringLiteral stringliteral) {
        this.jvmMethod().pushString(stringliteral.getByteList(), stringliteral.getCodeRange());
    }

    @Override
    public void SValue(SValue svalue) {
        this.visit(svalue.getArray());
        this.jvmAdapter().dup();
        this.jvmAdapter().instance_of(CodegenUtils.p(RubyArray.class));
        Label after = new Label();
        this.jvmAdapter().iftrue(after);
        this.jvmAdapter().pop();
        this.jvmMethod().pushNil();
        this.jvmAdapter().label(after);
    }

    @Override
    public void Symbol(Symbol symbol) {
        this.jvmMethod().pushSymbol(symbol.getBytes());
    }

    @Override
    public void SymbolProc(SymbolProc symbolproc) {
        this.jvmMethod().pushSymbolProc(symbolproc.getName(), symbolproc.getEncoding());
    }

    @Override
    public void TemporaryVariable(TemporaryVariable temporaryvariable) {
        this.jvmLoadLocal(temporaryvariable);
    }

    @Override
    public void TemporaryLocalVariable(TemporaryLocalVariable temporarylocalvariable) {
        this.jvmLoadLocal(temporarylocalvariable);
    }

    @Override
    public void TemporaryFloatVariable(TemporaryFloatVariable temporaryfloatvariable) {
        this.jvmLoadLocal(temporaryfloatvariable);
    }

    @Override
    public void TemporaryFixnumVariable(TemporaryFixnumVariable temporaryfixnumvariable) {
        this.jvmLoadLocal(temporaryfixnumvariable);
    }

    @Override
    public void TemporaryBooleanVariable(TemporaryBooleanVariable temporarybooleanvariable) {
        this.jvmLoadLocal(temporarybooleanvariable);
    }

    @Override
    public void UndefinedValue(UndefinedValue undefinedvalue) {
        this.jvmMethod().pushUndefined();
    }

    @Override
    public void UnexecutableNil(UnexecutableNil unexecutablenil) {
        throw new NotCompilableException(this.getClass().getSimpleName() + " should never be directly executed!");
    }

    @Override
    public void WrappedIRClosure(WrappedIRClosure wrappedirclosure) {
        IRClosure closure = wrappedirclosure.getClosure();
        this.jvmMethod().loadContext();
        this.visit(closure.getSelf());
        this.jvmLoadLocal(DYNAMIC_SCOPE);
        this.jvmMethod().prepareBlock(closure.getHandle(), closure.getSignature(), this.jvm.clsData().clsName);
    }

    private SkinnyMethodAdapter jvmAdapter() {
        return this.jvmMethod().adapter;
    }

    private IRBytecodeAdapter jvmMethod() {
        return this.jvm.method();
    }
}

