/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.instructions;

import java.util.Map;
import org.jruby.ir.IRScope;
import org.jruby.ir.IRVisitor;
import org.jruby.ir.Operation;
import org.jruby.ir.instructions.FixedArityInstr;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.instructions.TwoOperandInstr;
import org.jruby.ir.operands.LocalVariable;
import org.jruby.ir.operands.Operand;
import org.jruby.ir.persistence.IRReaderDecoder;
import org.jruby.ir.persistence.IRWriterEncoder;
import org.jruby.ir.transformations.inlining.CloneInfo;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class StoreLocalVarInstr
extends TwoOperandInstr
implements FixedArityInstr {
    private final IRScope scope;

    public StoreLocalVarInstr(IRScope scope, Operand value2, LocalVariable lvar) {
        super(Operation.BINDING_STORE, value2, lvar);
        this.scope = scope;
    }

    public Operand getValue() {
        return this.getOperand1();
    }

    public LocalVariable getLocalVar() {
        return (LocalVariable)this.getOperand2();
    }

    public IRScope getScope() {
        return this.scope;
    }

    @Override
    public String[] toStringNonOperandArgs() {
        return new String[]{"scope_name: " + this.scope.getName()};
    }

    public void decrementLVarScopeDepth() {
        this.setOperand2(this.getLocalVar().cloneForDepth(this.getLocalVar().getScopeDepth() - 1));
    }

    @Override
    public void simplifyOperands(Map<Operand, Operand> valueMap, boolean force) {
        this.setOperand1(this.getValue().getSimplifiedOperand(valueMap, force));
    }

    @Override
    public Instr clone(CloneInfo ii) {
        return new StoreLocalVarInstr(this.scope, this.getValue().cloneForInlining(ii), (LocalVariable)this.getLocalVar().cloneForInlining(ii));
    }

    @Override
    public void encode(IRWriterEncoder e) {
        super.encode(e);
        e.encode(this.getScope());
        e.encode(this.getValue());
        e.encode(this.getLocalVar());
    }

    public static StoreLocalVarInstr decode(IRReaderDecoder d) {
        return new StoreLocalVarInstr(d.decodeScope(), d.decodeOperand(), (LocalVariable)d.decodeOperand());
    }

    @Override
    public Object interpret(ThreadContext context, StaticScope currScope, DynamicScope currDynScope, IRubyObject self2, Object[] temp) {
        Object varValue = this.getValue().retrieve(context, self2, currScope, currDynScope, temp);
        currDynScope.setValue((IRubyObject)varValue, this.getLocalVar().getLocation(), this.getLocalVar().getScopeDepth());
        return null;
    }

    @Override
    public void visit(IRVisitor visitor) {
        visitor.StoreLocalVarInstr(this);
    }
}

