/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.instructions;

import java.util.Map;
import org.jruby.ir.IRScope;
import org.jruby.ir.IRVisitor;
import org.jruby.ir.Interp;
import org.jruby.ir.Operation;
import org.jruby.ir.instructions.FixedArityInstr;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.instructions.OneOperandResultBaseInstr;
import org.jruby.ir.operands.LocalVariable;
import org.jruby.ir.operands.Operand;
import org.jruby.ir.operands.TemporaryLocalVariable;
import org.jruby.ir.persistence.IRReaderDecoder;
import org.jruby.ir.persistence.IRWriterEncoder;
import org.jruby.ir.transformations.inlining.CloneInfo;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class LoadLocalVarInstr
extends OneOperandResultBaseInstr
implements FixedArityInstr {
    private final IRScope scope;

    public LoadLocalVarInstr(IRScope scope, TemporaryLocalVariable result2, LocalVariable lvar) {
        super(Operation.BINDING_LOAD, result2, lvar);
        assert (result2 != null) : "LoadLocalVarInstr result is null";
        this.scope = scope;
    }

    public LocalVariable getLocalVar() {
        return (LocalVariable)this.getOperand1();
    }

    public IRScope getScope() {
        return this.scope;
    }

    @Override
    public void simplifyOperands(Map<Operand, Operand> valueMap, boolean force) {
    }

    public void decrementLVarScopeDepth() {
        this.setOperand(0, this.getLocalVar().cloneForDepth(this.getLocalVar().getScopeDepth() - 1));
    }

    @Override
    public String[] toStringNonOperandArgs() {
        return new String[]{"scope: " + this.scope.getName()};
    }

    @Override
    public Instr clone(CloneInfo ii) {
        return new LoadLocalVarInstr(this.scope, (TemporaryLocalVariable)ii.getRenamedVariable(this.result), (LocalVariable)ii.getRenamedVariable(this.getLocalVar()));
    }

    @Override
    public void encode(IRWriterEncoder e) {
        super.encode(e);
        e.encode(this.getScope());
        e.encode(this.getLocalVar());
    }

    public static LoadLocalVarInstr decode(IRReaderDecoder d) {
        return new LoadLocalVarInstr(d.decodeScope(), (TemporaryLocalVariable)d.decodeVariable(), (LocalVariable)d.decodeVariable());
    }

    @Override
    @Interp
    public Object interpret(ThreadContext context, StaticScope currScope, DynamicScope currDynScope, IRubyObject self2, Object[] temp) {
        return this.getLocalVar().retrieve(context, self2, currScope, currDynScope, temp);
    }

    @Override
    public void visit(IRVisitor visitor) {
        visitor.LoadLocalVarInstr(this);
    }
}

