/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.socket;

import java.io.IOException;
import java.net.BindException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.SelectorProvider;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.RubyThread;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.ast.util.ArgsUtil;
import org.jruby.ext.socket.RubyTCPSocket;
import org.jruby.ext.socket.SocketUtils;
import org.jruby.runtime.Block;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.io.FilenoUtil;
import org.jruby.util.io.SelectorFactory;

@JRubyClass(name={"TCPServer"}, parent="TCPSocket")
public class RubyTCPServer
extends RubyTCPSocket {
    private static ObjectAllocator TCPSERVER_ALLOCATOR = new ObjectAllocator(){

        @Override
        public IRubyObject allocate(Ruby runtime, RubyClass klass) {
            return new RubyTCPServer(runtime, klass);
        }
    };

    static void createTCPServer(Ruby runtime) {
        RubyClass rb_cTCPServer = runtime.defineClass("TCPServer", runtime.getClass("TCPSocket"), TCPSERVER_ALLOCATOR);
        rb_cTCPServer.defineAnnotatedMethods(RubyTCPServer.class);
        runtime.getObject().setConstant("TCPserver", rb_cTCPServer);
    }

    public RubyTCPServer(Ruby runtime, RubyClass type2) {
        super(runtime, type2);
    }

    @Override
    @JRubyMethod(name={"initialize"}, required=1, optional=1, visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext context, IRubyObject[] args2) {
        Ruby runtime = context.runtime;
        IRubyObject _port = null;
        String host = "0.0.0.0";
        switch (args2.length) {
            case 2: {
                IRubyObject _host = args2[0];
                _port = args2[1];
                if (_host.isNil()) break;
                if (_host instanceof RubyFixnum) {
                    throw runtime.newTypeError(_host, runtime.getString());
                }
                RubyString hostString = _host.convertToString();
                if (hostString.size() <= 0) break;
                host = hostString.toString();
                break;
            }
            case 1: {
                _port = args2[0];
            }
        }
        int port = SocketUtils.getPortFrom(context, _port);
        try {
            InetAddress addr2 = InetAddress.getByName(host);
            ServerSocketChannel ssc = ServerSocketChannel.open();
            ssc.socket().setReuseAddress(true);
            InetSocketAddress socket_address = new InetSocketAddress(addr2, port);
            ssc.socket().bind(socket_address);
            this.initSocket(RubyTCPServer.newChannelFD(runtime, ssc));
        }
        catch (UnknownHostException e) {
            throw SocketUtils.sockerr(runtime, "initialize: name or service not known");
        }
        catch (BindException e) {
            throw runtime.newErrnoEADDRFromBindException(e);
        }
        catch (SocketException e) {
            String msg = e.getMessage();
            if (msg.indexOf("Permission denied") != -1) {
                throw runtime.newErrnoEACCESError("bind(2)");
            }
            throw SocketUtils.sockerr(runtime, "initialize: name or service not known");
        }
        catch (IOException e) {
            throw runtime.newIOErrorFromException(e);
        }
        catch (IllegalArgumentException iae) {
            throw SocketUtils.sockerr(runtime, iae.getMessage());
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(name={"accept"})
    public IRubyObject accept(ThreadContext context) {
        Ruby runtime = context.runtime;
        RubyTCPSocket socket2 = new RubyTCPSocket(runtime, runtime.getClass("TCPSocket"));
        try {
            SocketChannel connected;
            RubyThread thread2 = context.getThread();
            while (true) {
                boolean ready2;
                if (!(ready2 = thread2.select(this, 16))) {
                    context.pollThreadEvents();
                    continue;
                }
                connected = this.getServerSocketChannel().accept();
                if (connected != null) break;
            }
            connected.finishConnect();
            Object object = connected.blockingLock();
            synchronized (object) {
                connected.configureBlocking(false);
                connected.configureBlocking(true);
            }
            socket2.initSocket(RubyTCPServer.newChannelFD(runtime, connected));
            return socket2;
        }
        catch (IOException e) {
            throw runtime.newIOErrorFromException(e);
        }
    }

    @JRubyMethod(name={"accept_nonblock"})
    public IRubyObject accept_nonblock(ThreadContext context) {
        return this.accept_nonblock(context, context.runtime, true);
    }

    @JRubyMethod(name={"accept_nonblock"})
    public IRubyObject accept_nonblock(ThreadContext context, IRubyObject _opts) {
        Ruby runtime = context.runtime;
        boolean exception2 = ArgsUtil.extractKeywordArg(context, "exception", _opts) != runtime.getFalse();
        return this.accept_nonblock(context, runtime, exception2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IRubyObject accept_nonblock(ThreadContext context, Ruby runtime, boolean ex) {
        RubyTCPSocket socket2 = new RubyTCPSocket(runtime, runtime.getClass("TCPSocket"));
        Selector selector = null;
        ServerSocketChannel ssc = this.getServerSocketChannel();
        Object object = ssc.blockingLock();
        synchronized (object) {
            RubyTCPSocket rubyTCPSocket;
            boolean oldBlocking;
            block24: {
                RubySymbol rubySymbol;
                block23: {
                    oldBlocking = ssc.isBlocking();
                    try {
                        ssc.configureBlocking(false);
                        selector = SelectorFactory.openWithRetryFrom(runtime, SelectorProvider.provider());
                        boolean ready2 = context.getThread().select(this, 16, 0L);
                        if (!ready2) {
                            if (ex) {
                                throw runtime.newErrnoEAGAINReadableError("Resource temporarily unavailable");
                            }
                            rubySymbol = runtime.newSymbol("wait_readable");
                            break block23;
                        }
                        socket2.initSocket(RubyTCPServer.newChannelFD(runtime, ssc.accept()));
                        rubyTCPSocket = socket2;
                        break block24;
                    }
                    catch (IOException e) {
                        throw runtime.newIOErrorFromException(e);
                    }
                }
                return rubySymbol;
            }
            return rubyTCPSocket;
            finally {
                try {
                    if (selector != null) {
                        selector.close();
                    }
                }
                catch (Exception exception2) {}
                try {
                    ssc.configureBlocking(oldBlocking);
                }
                catch (IOException iOException) {}
            }
        }
    }

    @JRubyMethod(name={"sysaccept"})
    public IRubyObject sysaccept(ThreadContext context) {
        Ruby runtime = context.runtime;
        try {
            SocketChannel connected;
            RubyThread thread2 = context.getThread();
            while (true) {
                boolean ready2;
                if (!(ready2 = thread2.select(this, 16))) {
                    context.pollThreadEvents();
                    continue;
                }
                connected = this.getServerSocketChannel().accept();
                if (connected != null) break;
            }
            connected.finishConnect();
            return runtime.newFixnum(FilenoUtil.filenoFrom(connected));
        }
        catch (IOException e) {
            throw runtime.newIOErrorFromException(e);
        }
    }

    @JRubyMethod(name={"listen"}, required=1)
    public IRubyObject listen(ThreadContext context, IRubyObject backlog) {
        return RubyFixnum.zero(context.runtime);
    }

    @JRubyMethod(name={"peeraddr"}, rest=true)
    public IRubyObject peeraddr(ThreadContext context, IRubyObject[] args2) {
        throw context.runtime.newNotImplementedError("not supported");
    }

    @JRubyMethod(name={"getpeername"}, rest=true)
    public IRubyObject getpeername(ThreadContext context, IRubyObject[] args2) {
        throw context.runtime.newNotImplementedError("not supported");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(rest=true, meta=true)
    public static IRubyObject open(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block block) {
        IRubyObject tcpServer = recv2.callMethod(context, "new", args2);
        if (!block.isGiven()) {
            return tcpServer;
        }
        try {
            IRubyObject iRubyObject = block.yield(context, tcpServer);
            return iRubyObject;
        }
        finally {
            tcpServer.callMethod(context, "close");
        }
    }

    public ServerSocketChannel getServerSocketChannel() {
        return (ServerSocketChannel)this.getChannel();
    }

    @Override
    public IRubyObject shutdown(ThreadContext context, IRubyObject[] args2) {
        throw context.runtime.newErrnoENOTCONNError();
    }

    @Override
    public IRubyObject gets(ThreadContext context) {
        throw context.runtime.newErrnoENOTCONNError();
    }

    @Override
    public IRubyObject gets(ThreadContext context, IRubyObject sep) {
        throw context.runtime.newErrnoENOTCONNError();
    }

    @Override
    public IRubyObject gets(ThreadContext context, IRubyObject sep, IRubyObject limit2) {
        throw context.runtime.newErrnoENOTCONNError();
    }

    @Deprecated
    public IRubyObject accept() {
        return this.accept(this.getRuntime().getCurrentContext());
    }

    @Deprecated
    public IRubyObject listen(IRubyObject backlog) {
        return this.listen(this.getRuntime().getCurrentContext(), backlog);
    }

    @Deprecated
    public static IRubyObject open(IRubyObject recv2, IRubyObject[] args2, Block block) {
        return RubyTCPServer.open(recv2.getRuntime().getCurrentContext(), recv2, args2, block);
    }
}

