/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import jnr.constants.platform.Signal;
import org.jruby.Ruby;
import org.jruby.RubyHash;
import org.jruby.RubyModule;
import org.jruby.RubyString;
import org.jruby.anno.JRubyMethod;
import org.jruby.anno.JRubyModule;
import org.jruby.platform.Platform;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.NoFunctionalitySignalFacade;
import org.jruby.util.SignalFacade;

@JRubyModule(name={"Signal"})
public class RubySignal {
    private static final SignalFacade SIGNALS = RubySignal.getSignalFacade();
    private static final Set<String> RUBY_18_SIGNALS = new HashSet<String>();
    private static final String SIGNAME_PREFIX = "SIG";

    private static final SignalFacade getSignalFacade() {
        try {
            Class<?> realFacadeClass = Class.forName("org.jruby.util.SunSignalFacade");
            return (SignalFacade)realFacadeClass.newInstance();
        }
        catch (Throwable e) {
            return new NoFunctionalitySignalFacade();
        }
    }

    public static void createSignal(Ruby runtime) {
        if (!Platform.IS_WINDOWS) {
            try {
                Class.forName("java.lang.Process");
                Class.forName("java.lang.UNIXProcess");
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        RubyModule mSignal = runtime.defineModule("Signal");
        mSignal.defineAnnotatedMethods(RubySignal.class);
    }

    public static Map<String, Integer> list() {
        HashMap<String, Integer> signals = new HashMap<String, Integer>();
        for (Signal s2 : Signal.values()) {
            if (!s2.description().startsWith(SIGNAME_PREFIX) || !RUBY_18_SIGNALS.contains(RubySignal.signmWithoutPrefix(s2.description()))) continue;
            int signo2 = s2.intValue();
            if (s2 == Signal.SIGCLD) {
                signo2 = Signal.SIGCHLD.intValue();
            }
            if (signo2 >= 20000) continue;
            signals.put(RubySignal.signmWithoutPrefix(s2.description()), signo2);
        }
        return signals;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(meta=true)
    public static IRubyObject list(ThreadContext context, IRubyObject recv2) {
        RubyHash names2;
        Ruby runtime = recv2.getRuntime();
        IRubyObject iRubyObject = recv2;
        synchronized (iRubyObject) {
            names2 = (RubyHash)recv2.getInternalVariables().getInternalVariable("signal_list");
            if (names2 == null) {
                names2 = RubyHash.newHash(runtime);
                for (Map.Entry<String, Integer> sig : RubySignal.list().entrySet()) {
                    names2.op_aset(context, runtime.freezeAndDedupString(runtime.newString(sig.getKey())), runtime.newFixnum(sig.getValue()));
                }
                names2.op_aset(context, runtime.freezeAndDedupString(runtime.newString("EXIT")), runtime.newFixnum(0));
                recv2.getInternalVariables().setInternalVariable("signal_list", names2);
            } else {
                names2.dup(context);
            }
        }
        return names2;
    }

    @JRubyMethod(required=2, meta=true)
    public static IRubyObject __jtrap_kernel(IRubyObject recv2, IRubyObject block, IRubyObject sig) {
        return SIGNALS.trap(recv2, block, sig);
    }

    @JRubyMethod(required=1, meta=true)
    public static IRubyObject __jtrap_platform_kernel(IRubyObject recv2, IRubyObject sig) {
        return SIGNALS.restorePlatformDefault(recv2, sig);
    }

    @JRubyMethod(required=1, meta=true)
    public static IRubyObject __jtrap_osdefault_kernel(IRubyObject recv2, IRubyObject sig) {
        return SIGNALS.restoreOSDefault(recv2, sig);
    }

    @JRubyMethod(required=1, meta=true)
    public static IRubyObject __jtrap_restore_kernel(IRubyObject recv2, IRubyObject sig) {
        return SIGNALS.ignore(recv2, sig);
    }

    @JRubyMethod(required=1, meta=true)
    public static IRubyObject signame(ThreadContext context, IRubyObject recv2, IRubyObject rubySig) {
        long sig = rubySig.convertToInteger().getLongValue();
        String signame2 = RubySignal.signo2signm(sig);
        if (signame2 == null) {
            if (sig == 0L) {
                return RubyString.newString(context.runtime, "EXIT");
            }
            throw context.runtime.newArgumentError("invalid signal number: " + rubySig);
        }
        return context.runtime.newString(signame2);
    }

    public static String signo2signm(long no) {
        for (Signal s2 : Signal.values()) {
            if ((long)s2.intValue() != no) continue;
            return RubySignal.signmWithoutPrefix(s2.name());
        }
        return null;
    }

    public static long signm2signo(String nm) {
        for (Signal s2 : Signal.values()) {
            if (!RubySignal.signmWithoutPrefix(s2.name()).equals(nm)) continue;
            return s2.longValue();
        }
        return 0L;
    }

    public static String signmWithPrefix(String nm) {
        return nm.startsWith(SIGNAME_PREFIX) ? nm : SIGNAME_PREFIX + nm;
    }

    public static String signmWithoutPrefix(String nm) {
        return nm.startsWith(SIGNAME_PREFIX) ? nm.substring(SIGNAME_PREFIX.length()) : nm;
    }

    static {
        for (String name2 : new String[]{"EXIT", "HUP", "INT", "QUIT", "ILL", "TRAP", "IOT", "ABRT", "EMT", "FPE", "KILL", "BUS", "SEGV", "SYS", "PIPE", "ALRM", "TERM", "URG", "STOP", "TSTP", "CONT", "CHLD", "CLD", "TTIN", "TTOU", "IO", "XCPU", "XFSZ", "VTALRM", "PROF", "WINCH", "USR1", "USR2", "LOST", "MSG", "PWR", "POLL", "DANGER", "MIGRATE", "PRE", "GRANT", "RETRACT", "SOUND", "INFO"}) {
            RUBY_18_SIGNALS.add(name2);
        }
    }
}

