/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.javasupport;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyModule;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.javasupport.Java;
import org.jruby.javasupport.JavaAccessibleObject;
import org.jruby.javasupport.JavaCallable;
import org.jruby.javasupport.JavaObject;
import org.jruby.javasupport.JavaUtil;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.builtin.IRubyObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@JRubyClass(name={"Java::JavaConstructor"})
public class JavaConstructor
extends JavaCallable {
    private final Constructor<?> constructor;
    private final JavaUtil.JavaConverter objectConverter;

    public Object getValue() {
        return this.constructor;
    }

    public static RubyClass createJavaConstructorClass(Ruby runtime2, RubyModule javaModule) {
        RubyClass result2 = javaModule.defineClassUnder("JavaConstructor", runtime2.getObject(), ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR);
        JavaAccessibleObject.registerRubyMethods(runtime2, result2);
        JavaCallable.registerRubyMethods(runtime2, result2);
        result2.defineAnnotatedMethods(JavaConstructor.class);
        return result2;
    }

    public JavaConstructor(Ruby runtime2, Constructor<?> constructor2) {
        super(runtime2, runtime2.getJavaSupport().getJavaConstructorClass(), constructor2.getParameterTypes());
        this.constructor = constructor2;
        this.objectConverter = JavaUtil.getJavaConverter(constructor2.getDeclaringClass());
    }

    public static JavaConstructor create(Ruby runtime2, Constructor<?> constructor2) {
        return new JavaConstructor(runtime2, constructor2);
    }

    public static JavaConstructor getMatchingConstructor(Ruby runtime2, Class<?> javaClass, Class<?>[] argumentTypes) {
        try {
            return JavaConstructor.create(runtime2, javaClass.getConstructor(argumentTypes));
        }
        catch (NoSuchMethodException e) {
            block2: for (Constructor<?> ctor : javaClass.getConstructors()) {
                Class<?>[] targetTypes = ctor.getParameterTypes();
                if (targetTypes.length != argumentTypes.length) continue;
                if (targetTypes.length == 0 && argumentTypes.length == 0) {
                    return JavaConstructor.create(runtime2, ctor);
                }
                boolean found = true;
                for (int i2 = 0; i2 < argumentTypes.length; ++i2) {
                    if (i2 >= targetTypes.length) {
                        found = false;
                    }
                    if (!targetTypes[i2].isAssignableFrom(argumentTypes[i2])) {
                        found = false;
                        continue block2;
                    }
                    found = true;
                }
                if (!found) continue;
                return JavaConstructor.create(runtime2, ctor);
            }
            return null;
        }
    }

    @Override
    public boolean equals(Object other) {
        return other instanceof JavaConstructor && this.constructor == ((JavaConstructor)other).constructor;
    }

    @Override
    public int hashCode() {
        return this.constructor.hashCode();
    }

    @Override
    public int getArity() {
        return this.parameterTypes.length;
    }

    @Override
    protected String nameOnInspection() {
        return this.getType().toString();
    }

    @Override
    public Class<?>[] getParameterTypes() {
        return this.parameterTypes;
    }

    @Override
    public Class<?>[] getExceptionTypes() {
        return this.constructor.getExceptionTypes();
    }

    @Override
    public Type[] getGenericParameterTypes() {
        return this.constructor.getGenericParameterTypes();
    }

    @Override
    public Type[] getGenericExceptionTypes() {
        return this.constructor.getGenericExceptionTypes();
    }

    @Override
    public Annotation[][] getParameterAnnotations() {
        return this.constructor.getParameterAnnotations();
    }

    @Override
    public boolean isVarArgs() {
        return this.constructor.isVarArgs();
    }

    @Override
    public int getModifiers() {
        return this.constructor.getModifiers();
    }

    @Override
    public String toGenericString() {
        return this.constructor.toGenericString();
    }

    @Override
    protected AccessibleObject accessibleObject() {
        return this.constructor;
    }

    @JRubyMethod
    public IRubyObject type_parameters() {
        return Java.getInstance(this.getRuntime(), this.constructor.getTypeParameters());
    }

    @JRubyMethod
    public IRubyObject return_type() {
        return this.getRuntime().getNil();
    }

    @JRubyMethod(rest=true)
    public IRubyObject new_instance(IRubyObject[] args2) {
        int length2 = args2.length;
        Class[] types = this.parameterTypes;
        if (length2 != types.length) {
            throw this.getRuntime().newArgumentError(length2, types.length);
        }
        Object[] constructorArguments = new Object[length2];
        int i2 = length2;
        while (--i2 >= 0) {
            constructorArguments[i2] = args2[i2].toJava(types[i2]);
        }
        try {
            Object result2 = this.constructor.newInstance(constructorArguments);
            return JavaObject.wrap(this.getRuntime(), result2);
        }
        catch (IllegalArgumentException iae) {
            throw this.getRuntime().newTypeError("expected " + this.argument_types().inspect() + ", got [" + constructorArguments[0].getClass().getName() + ", ...]");
        }
        catch (IllegalAccessException iae) {
            throw this.getRuntime().newTypeError("illegal access");
        }
        catch (InvocationTargetException ite) {
            this.getRuntime().getJavaSupport().handleNativeException(ite.getTargetException(), this.constructor);
            assert (false);
            return null;
        }
        catch (InstantiationException ie) {
            throw this.getRuntime().newTypeError("can't make instance of " + this.constructor.getDeclaringClass().getName());
        }
    }

    public IRubyObject new_instance(Object[] arguments) {
        this.checkArity(arguments.length);
        try {
            Object result2 = this.constructor.newInstance(arguments);
            return JavaObject.wrap(this.getRuntime(), result2);
        }
        catch (IllegalArgumentException iae) {
            throw this.getRuntime().newTypeError("expected " + this.argument_types().inspect() + ", got [" + arguments[0].getClass().getName() + ", ...]");
        }
        catch (IllegalAccessException iae) {
            throw this.getRuntime().newTypeError("illegal access");
        }
        catch (InvocationTargetException ite) {
            this.getRuntime().getJavaSupport().handleNativeException(ite.getTargetException(), this.constructor);
            assert (false);
            return null;
        }
        catch (InstantiationException ie) {
            throw this.getRuntime().newTypeError("can't make instance of " + this.constructor.getDeclaringClass().getName());
        }
    }

    public Object newInstanceDirect(Object ... arguments) {
        this.checkArity(arguments.length);
        try {
            return this.constructor.newInstance(arguments);
        }
        catch (IllegalArgumentException iae) {
            return this.handlelIllegalArgumentEx(iae, arguments);
        }
        catch (IllegalAccessException iae) {
            return this.handleIllegalAccessEx(iae);
        }
        catch (InvocationTargetException ite) {
            return this.handleInvocationTargetEx(ite, this.constructor);
        }
        catch (Throwable t) {
            return this.handleThrowable(t, this.constructor);
        }
    }

    public Object newInstanceDirect() {
        this.checkArity(0);
        try {
            return this.constructor.newInstance(new Object[0]);
        }
        catch (IllegalArgumentException iae) {
            return this.handlelIllegalArgumentEx(iae, new Object[0]);
        }
        catch (IllegalAccessException iae) {
            return this.handleIllegalAccessEx(iae);
        }
        catch (InvocationTargetException ite) {
            return this.handleInvocationTargetEx(ite, this.constructor);
        }
        catch (Throwable t) {
            return this.handleThrowable(t, this.constructor);
        }
    }

    public Object newInstanceDirect(Object arg0) {
        this.checkArity(1);
        try {
            return this.constructor.newInstance(arg0);
        }
        catch (IllegalArgumentException iae) {
            return this.handlelIllegalArgumentEx(iae, arg0);
        }
        catch (IllegalAccessException iae) {
            return this.handleIllegalAccessEx(iae);
        }
        catch (InvocationTargetException ite) {
            return this.handleInvocationTargetEx(ite, this.constructor);
        }
        catch (Throwable t) {
            return this.handleThrowable(t, this.constructor);
        }
    }

    public Object newInstanceDirect(Object arg0, Object arg1) {
        this.checkArity(2);
        try {
            return this.constructor.newInstance(arg0, arg1);
        }
        catch (IllegalArgumentException iae) {
            return this.handlelIllegalArgumentEx(iae, arg0, arg1);
        }
        catch (IllegalAccessException iae) {
            return this.handleIllegalAccessEx(iae);
        }
        catch (InvocationTargetException ite) {
            return this.handleInvocationTargetEx(ite, this.constructor);
        }
        catch (Throwable t) {
            return this.handleThrowable(t, this.constructor);
        }
    }

    public Object newInstanceDirect(Object arg0, Object arg1, Object arg2) {
        this.checkArity(3);
        try {
            return this.constructor.newInstance(arg0, arg1, arg2);
        }
        catch (IllegalArgumentException iae) {
            return this.handlelIllegalArgumentEx(iae, arg0, arg1, arg2);
        }
        catch (IllegalAccessException iae) {
            return this.handleIllegalAccessEx(iae);
        }
        catch (InvocationTargetException ite) {
            return this.handleInvocationTargetEx(ite, this.constructor);
        }
        catch (Throwable t) {
            return this.handleThrowable(t, this.constructor);
        }
    }

    public Object newInstanceDirect(Object arg0, Object arg1, Object arg2, Object arg3) {
        this.checkArity(4);
        try {
            return this.constructor.newInstance(arg0, arg1, arg2, arg3);
        }
        catch (IllegalArgumentException iae) {
            return this.handlelIllegalArgumentEx(iae, arg0, arg1, arg2, arg3);
        }
        catch (IllegalAccessException iae) {
            return this.handleIllegalAccessEx(iae);
        }
        catch (InvocationTargetException ite) {
            return this.handleInvocationTargetEx(ite, this.constructor);
        }
        catch (Throwable t) {
            return this.handleThrowable(t, this.constructor);
        }
    }

    private IRubyObject handleIllegalAccessEx(IllegalAccessException iae) {
        throw this.getRuntime().newTypeError("illegal access on constructor for type " + this.constructor.getDeclaringClass().getSimpleName() + ": " + iae.getMessage());
    }

    private IRubyObject handlelIllegalArgumentEx(IllegalArgumentException iae, Object ... arguments) {
        throw this.getRuntime().newTypeError("for constructor of type " + this.constructor.getDeclaringClass().getSimpleName() + " expected " + this.argument_types().inspect() + "; got: " + JavaConstructor.dumpArgTypes(arguments) + "; error: " + iae.getMessage());
    }
}

