/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.meta.postgres;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.jooq.Condition;
import org.jooq.DSLContext;
import org.jooq.DataType;
import org.jooq.Field;
import org.jooq.Name;
import org.jooq.OrderField;
import org.jooq.QueryPart;
import org.jooq.Record;
import org.jooq.Record2;
import org.jooq.Record4;
import org.jooq.Record5;
import org.jooq.Record6;
import org.jooq.Result;
import org.jooq.SQLDialect;
import org.jooq.Select;
import org.jooq.SelectConditionStep;
import org.jooq.SelectField;
import org.jooq.SelectFieldOrAsterisk;
import org.jooq.SortOrder;
import org.jooq.Table;
import org.jooq.TableLike;
import org.jooq.WindowSpecification;
import org.jooq.exception.DataAccessException;
import org.jooq.impl.DSL;
import org.jooq.impl.SQLDataType;
import org.jooq.meta.AbstractDatabase;
import org.jooq.meta.AbstractDefinition;
import org.jooq.meta.AbstractIndexDefinition;
import org.jooq.meta.ArrayDefinition;
import org.jooq.meta.CatalogDefinition;
import org.jooq.meta.ColumnDefinition;
import org.jooq.meta.Database;
import org.jooq.meta.DefaultCheckConstraintDefinition;
import org.jooq.meta.DefaultDataTypeDefinition;
import org.jooq.meta.DefaultDomainDefinition;
import org.jooq.meta.DefaultEnumDefinition;
import org.jooq.meta.DefaultIndexColumnDefinition;
import org.jooq.meta.DefaultRelations;
import org.jooq.meta.DefaultSequenceDefinition;
import org.jooq.meta.DomainDefinition;
import org.jooq.meta.EnumDefinition;
import org.jooq.meta.IndexColumnDefinition;
import org.jooq.meta.IndexDefinition;
import org.jooq.meta.PackageDefinition;
import org.jooq.meta.RoutineDefinition;
import org.jooq.meta.SchemaDefinition;
import org.jooq.meta.SequenceDefinition;
import org.jooq.meta.TableDefinition;
import org.jooq.meta.UDTDefinition;
import org.jooq.meta.postgres.PostgresMaterializedViewDefinition;
import org.jooq.meta.postgres.PostgresRoutineDefinition;
import org.jooq.meta.postgres.PostgresTableDefinition;
import org.jooq.meta.postgres.PostgresTableValuedFunction;
import org.jooq.meta.postgres.PostgresUDTDefinition;
import org.jooq.meta.postgres.information_schema.Tables;
import org.jooq.meta.postgres.information_schema.tables.CheckConstraints;
import org.jooq.meta.postgres.information_schema.tables.Routines;
import org.jooq.meta.postgres.information_schema.tables.TableConstraints;
import org.jooq.meta.postgres.pg_catalog.tables.PgClass;
import org.jooq.meta.postgres.pg_catalog.tables.PgConstraint;
import org.jooq.meta.postgres.pg_catalog.tables.PgIndex;
import org.jooq.meta.postgres.pg_catalog.tables.PgInherits;
import org.jooq.meta.postgres.pg_catalog.tables.PgNamespace;
import org.jooq.meta.postgres.pg_catalog.tables.PgType;
import org.jooq.tools.JooqLogger;
import org.jooq.util.postgres.PostgresDSL;

public class PostgresDatabase
extends AbstractDatabase {
    private static final JooqLogger log = JooqLogger.getLogger(PostgresDatabase.class);
    private static Boolean is84;
    private static Boolean is94;
    private static Boolean is11;
    private static Boolean canUseRoutines;
    private static Boolean canCastToEnumType;
    private static Boolean canCombineArrays;
    private static Boolean canUseTupleInPredicates;

    @Override
    protected List<IndexDefinition> getIndexes0() throws SQLException {
        ArrayList<IndexDefinition> result = new ArrayList<IndexDefinition>();
        PgIndex i = org.jooq.meta.postgres.pg_catalog.Tables.PG_INDEX.as("i");
        PgClass trel = org.jooq.meta.postgres.pg_catalog.Tables.PG_CLASS.as("trel");
        PgClass irel = org.jooq.meta.postgres.pg_catalog.Tables.PG_CLASS.as("irel");
        PgNamespace tnsp = org.jooq.meta.postgres.pg_catalog.Tables.PG_NAMESPACE.as("tnsp");
        block0: for (Record6 record : this.create().select(tnsp.NSPNAME, trel.RELNAME, irel.RELNAME, i.INDISUNIQUE, (SelectField)PostgresDSL.array((Select)DSL.select((SelectField)DSL.field((String)"pg_get_indexdef({0}, k + 1, true)", String.class, (QueryPart[])new QueryPart[]{i.INDEXRELID})).from("generate_subscripts({0}, 1) as k", new QueryPart[]{i.INDKEY}).orderBy((OrderField)DSL.field((String)"k"))).as("columns"), (SelectField)DSL.field((String)"{0}::int[]", Integer[].class, (QueryPart[])new QueryPart[]{i.INDOPTION}).as("asc_or_desc")).from((TableLike)i).join((TableLike)irel).on(PostgresDSL.oid((Table)irel).eq(i.INDEXRELID)).join((TableLike)trel).on(PostgresDSL.oid((Table)trel).eq(i.INDRELID)).join((TableLike)tnsp).on(PostgresDSL.oid((Table)tnsp).eq(trel.RELNAMESPACE)).where(tnsp.NSPNAME.in(this.getInputSchemata())).orderBy(new int[]{1, 2, 3})) {
            SchemaDefinition tableSchema = this.getSchema((String)record.get(tnsp.NSPNAME));
            if (tableSchema == null) continue;
            String indexName = (String)record.get(irel.RELNAME);
            String tableName = (String)record.get(trel.RELNAME);
            final String[] columns = (String[])record.value5();
            final Integer[] options = (Integer[])record.value6();
            final TableDefinition table = this.getTable(tableSchema, tableName);
            if (table == null) continue;
            boolean unique = (Boolean)record.get(i.INDISUNIQUE);
            for (String column : columns) {
                if (table.getColumn(column) == null) continue block0;
            }
            result.add(new AbstractIndexDefinition(tableSchema, indexName, table, unique){
                List<IndexColumnDefinition> indexColumns;
                {
                    super(schema, name, table2, unique);
                    this.indexColumns = new ArrayList<IndexColumnDefinition>();
                    for (int ordinal = 0; ordinal < columns.length; ++ordinal) {
                        ColumnDefinition column = table.getColumn(columns[ordinal]);
                        SortOrder order = (options[ordinal] & 1) == 1 ? SortOrder.DESC : SortOrder.ASC;
                        this.indexColumns.add(new DefaultIndexColumnDefinition(this, column, order, ordinal + 1));
                    }
                }

                @Override
                protected List<IndexColumnDefinition> getIndexColumns0() {
                    return this.indexColumns;
                }
            });
        }
        return result;
    }

    @Override
    protected void loadPrimaryKeys(DefaultRelations relations2) throws SQLException {
        for (Record record : this.fetchKeys("PRIMARY KEY")) {
            SchemaDefinition schema = this.getSchema((String)record.get(Tables.KEY_COLUMN_USAGE.TABLE_SCHEMA));
            String key = (String)record.get(Tables.KEY_COLUMN_USAGE.CONSTRAINT_NAME);
            String tableName = (String)record.get(Tables.KEY_COLUMN_USAGE.TABLE_NAME);
            String columnName = (String)record.get(Tables.KEY_COLUMN_USAGE.COLUMN_NAME);
            TableDefinition table = this.getTable(schema, tableName);
            if (table == null) continue;
            relations2.addPrimaryKey(key, table.getColumn(columnName));
        }
    }

    @Override
    protected void loadUniqueKeys(DefaultRelations relations2) throws SQLException {
        for (Record record : this.fetchKeys("UNIQUE")) {
            SchemaDefinition schema = this.getSchema((String)record.get(Tables.KEY_COLUMN_USAGE.TABLE_SCHEMA));
            String key = (String)record.get(Tables.KEY_COLUMN_USAGE.CONSTRAINT_NAME);
            String tableName = (String)record.get(Tables.KEY_COLUMN_USAGE.TABLE_NAME);
            String columnName = (String)record.get(Tables.KEY_COLUMN_USAGE.COLUMN_NAME);
            TableDefinition table = this.getTable(schema, tableName);
            if (table == null) continue;
            relations2.addUniqueKey(key, table.getColumn(columnName));
        }
    }

    private Result<Record4<String, String, String, String>> fetchKeys(String constraintType) {
        return this.create().select(Tables.KEY_COLUMN_USAGE.CONSTRAINT_NAME, Tables.KEY_COLUMN_USAGE.TABLE_SCHEMA, Tables.KEY_COLUMN_USAGE.TABLE_NAME, Tables.KEY_COLUMN_USAGE.COLUMN_NAME).from((TableLike)Tables.TABLE_CONSTRAINTS).join((TableLike)Tables.KEY_COLUMN_USAGE).on(Tables.TABLE_CONSTRAINTS.CONSTRAINT_SCHEMA.equal(Tables.KEY_COLUMN_USAGE.CONSTRAINT_SCHEMA)).and(Tables.TABLE_CONSTRAINTS.CONSTRAINT_NAME.equal(Tables.KEY_COLUMN_USAGE.CONSTRAINT_NAME)).where(Tables.TABLE_CONSTRAINTS.CONSTRAINT_TYPE.equal((Object)constraintType)).and(Tables.TABLE_CONSTRAINTS.TABLE_SCHEMA.in(this.getInputSchemata())).orderBy((OrderField)Tables.KEY_COLUMN_USAGE.TABLE_SCHEMA.asc(), (OrderField)Tables.KEY_COLUMN_USAGE.TABLE_NAME.asc(), (OrderField)Tables.KEY_COLUMN_USAGE.CONSTRAINT_NAME.asc(), (OrderField)Tables.KEY_COLUMN_USAGE.ORDINAL_POSITION.asc()).fetch();
    }

    @Override
    protected void loadForeignKeys(DefaultRelations relations2) throws SQLException {
        Result result = this.create().fetch(this.getConnection().getMetaData().getExportedKeys(null, null, null)).sortAsc("key_seq").sortAsc("fk_name").sortAsc("fktable_name").sortAsc("fktable_schem");
        for (Record record : result) {
            SchemaDefinition foreignKeySchema = this.getSchema((String)record.get("fktable_schem", String.class));
            SchemaDefinition uniqueKeySchema = this.getSchema((String)record.get("pktable_schem", String.class));
            String foreignKey = (String)record.get("fk_name", String.class);
            String foreignKeyTable = (String)record.get("fktable_name", String.class);
            String foreignKeyColumn = (String)record.get("fkcolumn_name", String.class);
            String uniqueKey = (String)record.get("pk_name", String.class);
            TableDefinition referencingTable = this.getTable(foreignKeySchema, foreignKeyTable);
            if (referencingTable == null) continue;
            ColumnDefinition referencingColumn = referencingTable.getColumn(foreignKeyColumn);
            relations2.addForeignKey(foreignKeyTable + "__" + foreignKey, uniqueKey, referencingColumn, uniqueKeySchema);
        }
    }

    @Override
    protected void loadCheckConstraints(DefaultRelations relations2) throws SQLException {
        TableConstraints tc = Tables.TABLE_CONSTRAINTS.as("tc");
        CheckConstraints cc = Tables.CHECK_CONSTRAINTS.as("cc");
        for (Record record : this.create().select(tc.TABLE_SCHEMA, tc.TABLE_NAME, cc.CONSTRAINT_NAME, cc.CHECK_CLAUSE).from((TableLike)tc).join((TableLike)cc).using(new Field[]{tc.CONSTRAINT_CATALOG, tc.CONSTRAINT_SCHEMA, tc.CONSTRAINT_NAME}).where(tc.TABLE_SCHEMA.in(this.getInputSchemata())).orderBy(tc.TABLE_SCHEMA, tc.TABLE_NAME, cc.CONSTRAINT_NAME).fetch()) {
            SchemaDefinition schema = this.getSchema((String)record.get(tc.TABLE_SCHEMA));
            TableDefinition table = this.getTable(schema, (String)record.get(tc.TABLE_NAME));
            if (table == null) continue;
            relations2.addCheckConstraint(table, new DefaultCheckConstraintDefinition(schema, table, (String)record.get(cc.CONSTRAINT_NAME), (String)record.get(cc.CHECK_CLAUSE)));
        }
    }

    @Override
    protected List<TableDefinition> getTables0() throws SQLException {
        ArrayList<TableDefinition> result = new ArrayList<TableDefinition>();
        HashMap<Name, PostgresTableDefinition> map = new HashMap<Name, PostgresTableDefinition>();
        SelectConditionStep empty = DSL.select((SelectField)DSL.inline((String)""), (SelectField)DSL.inline((String)""), (SelectField)DSL.inline((String)""), (SelectField)DSL.inline((boolean)false), (SelectField)DSL.inline((boolean)false), (SelectField)DSL.inline((String)"")).where((Condition)DSL.falseCondition());
        for (Record record : this.create().select(new SelectFieldOrAsterisk[0]).from((TableLike)DSL.select(Tables.TABLES.TABLE_SCHEMA, Tables.TABLES.TABLE_NAME, (SelectField)Tables.TABLES.TABLE_NAME.as("specific_name"), (SelectField)DSL.inline((boolean)false).as("table_valued_function"), (SelectField)DSL.inline((boolean)false).as("materialized_view"), org.jooq.meta.postgres.pg_catalog.Tables.PG_DESCRIPTION.DESCRIPTION).from((TableLike)Tables.TABLES).join((TableLike)org.jooq.meta.postgres.pg_catalog.Tables.PG_NAMESPACE).on(Tables.TABLES.TABLE_SCHEMA.eq(org.jooq.meta.postgres.pg_catalog.Tables.PG_NAMESPACE.NSPNAME)).join((TableLike)org.jooq.meta.postgres.pg_catalog.Tables.PG_CLASS).on(org.jooq.meta.postgres.pg_catalog.Tables.PG_CLASS.RELNAME.eq(Tables.TABLES.TABLE_NAME)).and(org.jooq.meta.postgres.pg_catalog.Tables.PG_CLASS.RELNAMESPACE.eq(PostgresDSL.oid((Table)org.jooq.meta.postgres.pg_catalog.Tables.PG_NAMESPACE))).leftOuterJoin((TableLike)org.jooq.meta.postgres.pg_catalog.Tables.PG_DESCRIPTION).on(org.jooq.meta.postgres.pg_catalog.Tables.PG_DESCRIPTION.OBJOID.eq(PostgresDSL.oid((Table)org.jooq.meta.postgres.pg_catalog.Tables.PG_CLASS))).and(org.jooq.meta.postgres.pg_catalog.Tables.PG_DESCRIPTION.OBJSUBID.eq((Object)0)).where(Tables.TABLES.TABLE_SCHEMA.in(this.getInputSchemata())).and(this.canUseTupleInPredicates() ? DSL.row(Tables.TABLES.TABLE_SCHEMA, Tables.TABLES.TABLE_NAME).notIn((Select)DSL.select(org.jooq.meta.postgres.pg_catalog.Tables.PG_NAMESPACE.NSPNAME, org.jooq.meta.postgres.pg_catalog.Tables.PG_CLASS.RELNAME).from((TableLike)org.jooq.meta.postgres.pg_catalog.Tables.PG_CLASS).join((TableLike)org.jooq.meta.postgres.pg_catalog.Tables.PG_NAMESPACE).on(org.jooq.meta.postgres.pg_catalog.Tables.PG_CLASS.RELNAMESPACE.eq(PostgresDSL.oid((Table)org.jooq.meta.postgres.pg_catalog.Tables.PG_NAMESPACE))).where(org.jooq.meta.postgres.pg_catalog.Tables.PG_CLASS.RELKIND.eq((Field)DSL.inline((String)"m")))) : DSL.noCondition()).unionAll((Select)DSL.select((SelectField)DSL.field((String)"{0}::varchar", (DataType)org.jooq.meta.postgres.pg_catalog.Tables.PG_NAMESPACE.NSPNAME.getDataType(), (QueryPart[])new QueryPart[]{org.jooq.meta.postgres.pg_catalog.Tables.PG_NAMESPACE.NSPNAME}), (SelectField)DSL.field((String)"{0}::varchar", (DataType)org.jooq.meta.postgres.pg_catalog.Tables.PG_CLASS.RELNAME.getDataType(), (QueryPart[])new QueryPart[]{org.jooq.meta.postgres.pg_catalog.Tables.PG_CLASS.RELNAME}), (SelectField)DSL.field((String)"{0}::varchar", (DataType)org.jooq.meta.postgres.pg_catalog.Tables.PG_CLASS.RELNAME.getDataType(), (QueryPart[])new QueryPart[]{org.jooq.meta.postgres.pg_catalog.Tables.PG_CLASS.RELNAME}), (SelectField)DSL.inline((boolean)false).as("table_valued_function"), (SelectField)DSL.inline((boolean)true).as("materialized_view"), org.jooq.meta.postgres.pg_catalog.Tables.PG_DESCRIPTION.DESCRIPTION).from((TableLike)org.jooq.meta.postgres.pg_catalog.Tables.PG_CLASS).join((TableLike)org.jooq.meta.postgres.pg_catalog.Tables.PG_NAMESPACE).on(org.jooq.meta.postgres.pg_catalog.Tables.PG_CLASS.RELNAMESPACE.eq(PostgresDSL.oid((Table)org.jooq.meta.postgres.pg_catalog.Tables.PG_NAMESPACE))).leftOuterJoin((TableLike)org.jooq.meta.postgres.pg_catalog.Tables.PG_DESCRIPTION).on(org.jooq.meta.postgres.pg_catalog.Tables.PG_DESCRIPTION.OBJOID.eq(PostgresDSL.oid((Table)org.jooq.meta.postgres.pg_catalog.Tables.PG_CLASS))).and(org.jooq.meta.postgres.pg_catalog.Tables.PG_DESCRIPTION.OBJSUBID.eq((Object)0)).where(org.jooq.meta.postgres.pg_catalog.Tables.PG_NAMESPACE.NSPNAME.in(this.getInputSchemata())).and(org.jooq.meta.postgres.pg_catalog.Tables.PG_CLASS.RELKIND.eq((Field)DSL.inline((String)"m")))).unionAll((Select)(this.tableValuedFunctions() ? DSL.select(Tables.ROUTINES.ROUTINE_SCHEMA, Tables.ROUTINES.ROUTINE_NAME, Tables.ROUTINES.SPECIFIC_NAME, (SelectField)DSL.inline((boolean)true).as("table_valued_function"), (SelectField)DSL.inline((boolean)false).as("materialized_view"), (SelectField)DSL.inline((String)"")).from((TableLike)Tables.ROUTINES).join((TableLike)org.jooq.meta.postgres.pg_catalog.Tables.PG_NAMESPACE).on(Tables.ROUTINES.SPECIFIC_SCHEMA.eq(org.jooq.meta.postgres.pg_catalog.Tables.PG_NAMESPACE.NSPNAME)).join((TableLike)org.jooq.meta.postgres.pg_catalog.Tables.PG_PROC).on(org.jooq.meta.postgres.pg_catalog.Tables.PG_PROC.PRONAMESPACE.eq(PostgresDSL.oid((Table)org.jooq.meta.postgres.pg_catalog.Tables.PG_NAMESPACE))).and(org.jooq.meta.postgres.pg_catalog.Tables.PG_PROC.PRONAME.concat(new String[]{"_"}).concat(new Field[]{PostgresDSL.oid((Table)org.jooq.meta.postgres.pg_catalog.Tables.PG_PROC)}).eq(Tables.ROUTINES.SPECIFIC_NAME)).where(Tables.ROUTINES.ROUTINE_SCHEMA.in(this.getInputSchemata())).and(org.jooq.meta.postgres.pg_catalog.Tables.PG_PROC.PRORETSET) : empty)).asTable("tables")).orderBy(new int[]{1, 2}).fetch()) {
            SchemaDefinition schema = this.getSchema((String)record.get(Tables.TABLES.TABLE_SCHEMA));
            String name = (String)record.get(Tables.TABLES.TABLE_NAME);
            boolean tableValuedFunction = (Boolean)record.get("table_valued_function", Boolean.TYPE);
            boolean materializedView = (Boolean)record.get("materialized_view", Boolean.TYPE);
            String comment = (String)record.get(org.jooq.meta.postgres.pg_catalog.Tables.PG_DESCRIPTION.DESCRIPTION, String.class);
            if (tableValuedFunction) {
                result.add(new PostgresTableValuedFunction(schema, name, (String)record.get(Tables.ROUTINES.SPECIFIC_NAME), comment));
                continue;
            }
            if (materializedView) {
                result.add(new PostgresMaterializedViewDefinition(schema, name, comment));
                continue;
            }
            PostgresTableDefinition t = new PostgresTableDefinition(schema, name, comment);
            result.add(t);
            map.put(DSL.name((String[])new String[]{schema.getName(), name}), t);
        }
        PgClass ct = org.jooq.meta.postgres.pg_catalog.Tables.PG_CLASS.as("ct");
        PgNamespace cn = org.jooq.meta.postgres.pg_catalog.Tables.PG_NAMESPACE.as("cn");
        PgInherits i = org.jooq.meta.postgres.pg_catalog.Tables.PG_INHERITS.as("i");
        PgClass pt = org.jooq.meta.postgres.pg_catalog.Tables.PG_CLASS.as("pt");
        PgNamespace pn = org.jooq.meta.postgres.pg_catalog.Tables.PG_NAMESPACE.as("pn");
        if (this.is84()) {
            for (Record5 inheritance : this.create().select(cn.NSPNAME, ct.RELNAME, pn.NSPNAME, pt.RELNAME, (SelectField)DSL.max(i.INHSEQNO).over().partitionBy(new Field[]{i.INHRELID}).as("m")).from((TableLike)ct).join((TableLike)cn).on(ct.RELNAMESPACE.eq(PostgresDSL.oid((Table)cn))).join((TableLike)i).on(i.INHRELID.eq(PostgresDSL.oid((Table)ct))).join((TableLike)pt).on(i.INHPARENT.eq(PostgresDSL.oid((Table)pt))).join((TableLike)pn).on(pt.RELNAMESPACE.eq(PostgresDSL.oid((Table)pn))).where(cn.NSPNAME.in(this.getInputSchemata())).and(pn.NSPNAME.in(this.getInputSchemata())).fetch()) {
                Name child = DSL.name((String[])new String[]{(String)inheritance.value1(), (String)inheritance.value2()});
                Name parent = DSL.name((String[])new String[]{(String)inheritance.value3(), (String)inheritance.value4()});
                if ((Integer)inheritance.value5() > 1) {
                    log.info((Object)"Multiple inheritance", (Object)("Multiple inheritance is not supported by jOOQ: " + child + " inherits from " + parent));
                    continue;
                }
                PostgresTableDefinition childTable = (PostgresTableDefinition)map.get(child);
                PostgresTableDefinition parentTable = (PostgresTableDefinition)map.get(parent);
                if (childTable == null || parentTable == null) continue;
                childTable.setParentTable(parentTable);
                parentTable.getChildTables().add(childTable);
            }
        }
        return result;
    }

    @Override
    protected List<CatalogDefinition> getCatalogs0() throws SQLException {
        ArrayList<CatalogDefinition> result = new ArrayList<CatalogDefinition>();
        result.add(new CatalogDefinition((Database)this, "", ""));
        return result;
    }

    @Override
    protected List<SchemaDefinition> getSchemata0() throws SQLException {
        ArrayList<SchemaDefinition> result = new ArrayList<SchemaDefinition>();
        for (String name : this.create().select(org.jooq.meta.postgres.pg_catalog.Tables.PG_NAMESPACE.NSPNAME).from((TableLike)org.jooq.meta.postgres.pg_catalog.Tables.PG_NAMESPACE).orderBy(org.jooq.meta.postgres.pg_catalog.Tables.PG_NAMESPACE.NSPNAME).fetch(org.jooq.meta.postgres.pg_catalog.Tables.PG_NAMESPACE.NSPNAME)) {
            result.add(new SchemaDefinition((Database)this, name, ""));
        }
        return result;
    }

    @Override
    protected List<SequenceDefinition> getSequences0() throws SQLException {
        ArrayList<SequenceDefinition> result = new ArrayList<SequenceDefinition>();
        for (Record record : this.create().select(Tables.SEQUENCES.SEQUENCE_SCHEMA, Tables.SEQUENCES.SEQUENCE_NAME, Tables.SEQUENCES.DATA_TYPE, Tables.SEQUENCES.NUMERIC_PRECISION, Tables.SEQUENCES.NUMERIC_SCALE).from((TableLike)Tables.SEQUENCES).where(Tables.SEQUENCES.SEQUENCE_SCHEMA.in(this.getInputSchemata())).orderBy(Tables.SEQUENCES.SEQUENCE_SCHEMA, Tables.SEQUENCES.SEQUENCE_NAME).fetch()) {
            SchemaDefinition schema = this.getSchema((String)record.get(Tables.SEQUENCES.SEQUENCE_SCHEMA));
            DefaultDataTypeDefinition type = new DefaultDataTypeDefinition((Database)this, schema, (String)record.get(Tables.SEQUENCES.DATA_TYPE), (Number)0, (Number)record.get(Tables.SEQUENCES.NUMERIC_PRECISION), (Number)record.get(Tables.SEQUENCES.NUMERIC_SCALE), (Boolean)false, (String)null);
            result.add(new DefaultSequenceDefinition(schema, (String)record.get(Tables.SEQUENCES.SEQUENCE_NAME), type));
        }
        return result;
    }

    @Override
    protected List<EnumDefinition> getEnums0() throws SQLException {
        ArrayList<EnumDefinition> result = new ArrayList<EnumDefinition>();
        if (this.exists((Table<?>)org.jooq.meta.postgres.pg_catalog.Tables.PG_ENUM)) {
            Result types = this.create().select(org.jooq.meta.postgres.pg_catalog.Tables.PG_NAMESPACE.NSPNAME, org.jooq.meta.postgres.pg_catalog.Tables.PG_TYPE.TYPNAME).from((TableLike)org.jooq.meta.postgres.pg_catalog.Tables.PG_TYPE).join((TableLike)org.jooq.meta.postgres.pg_catalog.Tables.PG_NAMESPACE).on(org.jooq.meta.postgres.pg_catalog.Tables.PG_TYPE.TYPNAMESPACE.eq(PostgresDSL.oid((Table)org.jooq.meta.postgres.pg_catalog.Tables.PG_NAMESPACE))).where(org.jooq.meta.postgres.pg_catalog.Tables.PG_NAMESPACE.NSPNAME.in(this.getInputSchemata())).and(PostgresDSL.oid((Table)org.jooq.meta.postgres.pg_catalog.Tables.PG_TYPE).in((Select)DSL.select(org.jooq.meta.postgres.pg_catalog.Tables.PG_ENUM.ENUMTYPID).from((TableLike)org.jooq.meta.postgres.pg_catalog.Tables.PG_ENUM))).orderBy(org.jooq.meta.postgres.pg_catalog.Tables.PG_NAMESPACE.NSPNAME, org.jooq.meta.postgres.pg_catalog.Tables.PG_TYPE.TYPNAME).fetch();
            for (Record2 type : types) {
                String nspname = (String)type.get(org.jooq.meta.postgres.pg_catalog.Tables.PG_NAMESPACE.NSPNAME);
                String typname = (String)type.get(org.jooq.meta.postgres.pg_catalog.Tables.PG_TYPE.TYPNAME);
                AbstractDefinition definition = null;
                for (String label : this.enumLabels(nspname, typname)) {
                    SchemaDefinition schema = this.getSchema(nspname);
                    String typeName = String.valueOf(typname);
                    if (definition == null || !definition.getName().equals(typeName)) {
                        definition = new DefaultEnumDefinition(schema, typeName, null);
                        result.add((EnumDefinition)((Object)definition));
                    }
                    ((DefaultEnumDefinition)definition).addLiteral(label);
                }
            }
        }
        return result;
    }

    @Override
    protected List<DomainDefinition> getDomains0() throws SQLException {
        ArrayList<DomainDefinition> result = new ArrayList<DomainDefinition>();
        if (this.existAll(new Table[]{org.jooq.meta.postgres.pg_catalog.Tables.PG_CONSTRAINT, org.jooq.meta.postgres.pg_catalog.Tables.PG_TYPE})) {
            PgNamespace n = org.jooq.meta.postgres.pg_catalog.Tables.PG_NAMESPACE.as("n");
            PgConstraint c = org.jooq.meta.postgres.pg_catalog.Tables.PG_CONSTRAINT.as("c");
            PgType d = org.jooq.meta.postgres.pg_catalog.Tables.PG_TYPE.as("d");
            PgType b = org.jooq.meta.postgres.pg_catalog.Tables.PG_TYPE.as("b");
            Field src = DSL.field((Name)DSL.name((String[])new String[]{"domains", "src"}), String[].class);
            for (Record record : this.create().withRecursive("domains", "domain_id", "base_id", "typbasetype", "src").as((Select)DSL.select((SelectField)PostgresDSL.oid((Table)d), (SelectField)PostgresDSL.oid((Table)d), d.TYPBASETYPE, (SelectField)PostgresDSL.array((Field[])new Field[]{c.CONSRC})).from((TableLike)d).join((TableLike)n).on(PostgresDSL.oid((Table)n).eq(d.TYPNAMESPACE)).leftJoin((TableLike)c).on(PostgresDSL.oid((Table)d).eq(c.CONTYPID)).where(d.TYPTYPE.eq((Object)"d")).and(n.NSPNAME.in(this.getInputSchemata())).unionAll((Select)DSL.select((SelectField)DSL.field((Name)DSL.name((String[])new String[]{"domains", "domain_id"}), Long.class), (SelectField)PostgresDSL.oid((Table)d), d.TYPBASETYPE, (SelectField)DSL.decode().when(c.CONSRC.isNull(), src).otherwise(PostgresDSL.arrayAppend((Field)src, c.CONSRC))).from(DSL.name((String)"domains")).join((TableLike)d).on(DSL.field((Name)DSL.name((String[])new String[]{"domains", d.TYPBASETYPE.getName()})).eq((Object)PostgresDSL.oid((Table)d))).leftJoin((TableLike)c).on(PostgresDSL.oid((Table)d).eq(c.CONTYPID)))).select(n.NSPNAME, d.TYPNAME, d.TYPNOTNULL, d.TYPDEFAULT, b.TYPNAME, b.TYPLEN, (SelectField)src).from((TableLike)d).join(DSL.name((String)"domains")).on(DSL.field((Name)DSL.name((String[])new String[]{"domains", "typbasetype"})).eq((Object)0)).and(DSL.field((Name)DSL.name((String[])new String[]{"domains", "domain_id"})).eq((Object)PostgresDSL.oid((Table)d))).join((TableLike)b).on(DSL.field((Name)DSL.name((String[])new String[]{"domains", "base_id"})).eq((Object)PostgresDSL.oid((Table)b))).join((TableLike)n).on(PostgresDSL.oid((Table)n).eq(d.TYPNAMESPACE)).where(d.TYPTYPE.eq((Object)"d")).and(n.NSPNAME.in(this.getInputSchemata())).orderBy(n.NSPNAME, d.TYPNAME)) {
                SchemaDefinition schema = this.getSchema((String)record.get(n.NSPNAME));
                DefaultDataTypeDefinition baseType = new DefaultDataTypeDefinition((Database)this, schema, (String)record.get(b.TYPNAME), (Number)record.get(b.TYPLEN), (Number)record.get(b.TYPLEN), (Number)0, (Boolean)((Boolean)record.get(d.TYPNOTNULL, Boolean.TYPE) == false ? 1 : 0), (String)record.get(d.TYPDEFAULT), DSL.name((String[])new String[]{(String)record.get(n.NSPNAME), (String)record.get(b.TYPNAME)}));
                DefaultDomainDefinition domain = new DefaultDomainDefinition(schema, (String)record.get(d.TYPNAME), baseType);
                domain.addCheckClause((String[])record.get(src));
                result.add(domain);
            }
        }
        return result;
    }

    @Override
    protected List<UDTDefinition> getUDTs0() throws SQLException {
        ArrayList<UDTDefinition> result = new ArrayList<UDTDefinition>();
        if (this.exists((Table<?>)Tables.ATTRIBUTES)) {
            for (Record record : this.create().selectDistinct(Tables.ATTRIBUTES.UDT_SCHEMA, Tables.ATTRIBUTES.UDT_NAME).from((TableLike)Tables.ATTRIBUTES).where(Tables.ATTRIBUTES.UDT_SCHEMA.in(this.getInputSchemata())).orderBy(Tables.ATTRIBUTES.UDT_SCHEMA, Tables.ATTRIBUTES.UDT_NAME).fetch()) {
                SchemaDefinition schema = this.getSchema((String)record.get(Tables.ATTRIBUTES.UDT_SCHEMA));
                String name = (String)record.get(Tables.ATTRIBUTES.UDT_NAME);
                result.add(new PostgresUDTDefinition(schema, name, null));
            }
        }
        return result;
    }

    @Override
    protected List<ArrayDefinition> getArrays0() throws SQLException {
        ArrayList<ArrayDefinition> result = new ArrayList<ArrayDefinition>();
        return result;
    }

    @Override
    protected List<RoutineDefinition> getRoutines0() throws SQLException {
        ArrayList<RoutineDefinition> result = new ArrayList<RoutineDefinition>();
        if (!this.canUseRoutines()) {
            return result;
        }
        Routines r1 = Tables.ROUTINES.as("r1");
        Field isAgg = (this.is11() ? DSL.field((Condition)org.jooq.meta.postgres.pg_catalog.Tables.PG_PROC.PROKIND.eq((Field)DSL.inline((String)"a"))) : DSL.field((String)"{0}.proisagg", (DataType)SQLDataType.BOOLEAN, (QueryPart[])new QueryPart[]{org.jooq.meta.postgres.pg_catalog.Tables.PG_PROC})).as("is_agg");
        for (Record record : this.create().select(r1.ROUTINE_SCHEMA, r1.ROUTINE_NAME, r1.SPECIFIC_NAME, (SelectField)(this.canCombineArrays() ? DSL.when((Condition)DSL.condition((String)"{0} && ARRAY['o','b']::\"char\"[]", (QueryPart[])new QueryPart[]{org.jooq.meta.postgres.pg_catalog.Tables.PG_PROC.PROARGMODES}), (Field)DSL.inline((String)"void")).otherwise(r1.DATA_TYPE).as("data_type") : r1.DATA_TYPE.as("data_type")), r1.CHARACTER_MAXIMUM_LENGTH, r1.NUMERIC_PRECISION, r1.NUMERIC_SCALE, r1.TYPE_UDT_SCHEMA, r1.TYPE_UDT_NAME, (SelectField)DSL.when((Condition)DSL.count().over((WindowSpecification)DSL.partitionBy((Field[])new Field[]{r1.ROUTINE_SCHEMA, r1.ROUTINE_NAME})).gt((Field)DSL.one()), (Field)DSL.rowNumber().over((WindowSpecification)DSL.partitionBy((Field[])new Field[]{r1.ROUTINE_SCHEMA, r1.ROUTINE_NAME}).orderBy(new OrderField[]{r1.SPECIFIC_NAME}))).as("overload"), (SelectField)isAgg).from((TableLike)r1).join((TableLike)org.jooq.meta.postgres.pg_catalog.Tables.PG_NAMESPACE).on(org.jooq.meta.postgres.pg_catalog.Tables.PG_NAMESPACE.NSPNAME.eq(r1.SPECIFIC_SCHEMA)).join((TableLike)org.jooq.meta.postgres.pg_catalog.Tables.PG_PROC).on(org.jooq.meta.postgres.pg_catalog.Tables.PG_PROC.PRONAMESPACE.eq(PostgresDSL.oid((Table)org.jooq.meta.postgres.pg_catalog.Tables.PG_NAMESPACE))).and(org.jooq.meta.postgres.pg_catalog.Tables.PG_PROC.PRONAME.concat(new String[]{"_"}).concat(new Field[]{PostgresDSL.oid((Table)org.jooq.meta.postgres.pg_catalog.Tables.PG_PROC)}).eq(r1.SPECIFIC_NAME)).where(r1.ROUTINE_SCHEMA.in(this.getInputSchemata())).and(this.tableValuedFunctions() ? DSL.condition((Field)DSL.not(org.jooq.meta.postgres.pg_catalog.Tables.PG_PROC.PRORETSET)) : DSL.noCondition()).and(!this.getIncludeTriggerRoutines() ? r1.DATA_TYPE.ne((Field)DSL.inline((String)"trigger")) : DSL.noCondition()).orderBy((OrderField)r1.ROUTINE_SCHEMA.asc(), (OrderField)r1.ROUTINE_NAME.asc(), (OrderField)DSL.field((Name)DSL.name((String)"overload")).asc()).fetch()) {
            result.add(new PostgresRoutineDefinition(this, record));
        }
        return result;
    }

    @Override
    protected List<PackageDefinition> getPackages0() throws SQLException {
        ArrayList<PackageDefinition> result = new ArrayList<PackageDefinition>();
        return result;
    }

    @Override
    protected DSLContext create0() {
        return DSL.using((Connection)this.getConnection(), (SQLDialect)SQLDialect.POSTGRES);
    }

    boolean is84() {
        if (is84 == null) {
            try {
                this.create(true).select((SelectField)DSL.count().over()).fetch();
                is84 = true;
            }
            catch (DataAccessException e) {
                is84 = false;
            }
        }
        return is84;
    }

    boolean is94() {
        if (is94 == null) {
            try {
                this.create(true).select(Tables.PARAMETERS.PARAMETER_DEFAULT).from((TableLike)Tables.PARAMETERS).where((Condition)DSL.falseCondition()).fetch();
                is94 = true;
            }
            catch (DataAccessException e) {
                is94 = false;
            }
        }
        return is94;
    }

    boolean is11() {
        if (is11 == null) {
            try {
                this.create(true).select(org.jooq.meta.postgres.pg_catalog.Tables.PG_PROC.PROKIND).from((TableLike)org.jooq.meta.postgres.pg_catalog.Tables.PG_PROC).where((Condition)DSL.falseCondition()).fetch();
                is11 = true;
            }
            catch (DataAccessException e) {
                is11 = false;
            }
        }
        return is11;
    }

    boolean canCombineArrays() {
        if (canCombineArrays == null) {
            try {
                this.create(true).select((SelectField)DSL.field((String)"array[1, 2] && array[2, 3]")).fetch();
                canCombineArrays = true;
            }
            catch (DataAccessException e) {
                canCombineArrays = false;
            }
        }
        return canCombineArrays;
    }

    boolean canUseTupleInPredicates() {
        if (canUseTupleInPredicates == null) {
            try {
                this.create(true).select((SelectField)DSL.field((String)"(1, 2) in (select 1, 2)")).fetch();
                this.create(true).select((SelectField)DSL.field((String)"(1, 2) not in (select 1, 2)")).fetch();
                canUseTupleInPredicates = true;
            }
            catch (DataAccessException e) {
                canUseTupleInPredicates = false;
            }
        }
        return canUseTupleInPredicates;
    }

    boolean canUseRoutines() {
        if (canUseRoutines == null) {
            try {
                this.create(true).fetchExists((Table)Tables.ROUTINES);
                canUseRoutines = true;
            }
            catch (DataAccessException e) {
                canUseRoutines = false;
            }
        }
        return canUseRoutines;
    }

    private List<String> enumLabels(String nspname, String typname) {
        Field cast = DSL.field((String)"{0}::{1}", (QueryPart[])new QueryPart[]{org.jooq.meta.postgres.pg_catalog.Tables.PG_ENUM.ENUMLABEL, DSL.name((String[])new String[]{nspname, typname})});
        if (canCastToEnumType == null) {
            try {
                canCastToEnumType = true;
                return this.enumLabels(nspname, typname, cast);
            }
            catch (DataAccessException e) {
                canCastToEnumType = false;
            }
        }
        return canCastToEnumType != false ? this.enumLabels(nspname, typname, cast) : this.enumLabels(nspname, typname, (Field<?>)org.jooq.meta.postgres.pg_catalog.Tables.PG_ENUM.ENUMLABEL);
    }

    private List<String> enumLabels(String nspname, String typname, Field<?> orderBy) {
        return this.create().select(org.jooq.meta.postgres.pg_catalog.Tables.PG_ENUM.ENUMLABEL).from((TableLike)org.jooq.meta.postgres.pg_catalog.Tables.PG_ENUM).join((TableLike)org.jooq.meta.postgres.pg_catalog.Tables.PG_TYPE).on(org.jooq.meta.postgres.pg_catalog.Tables.PG_ENUM.ENUMTYPID.eq(PostgresDSL.oid((Table)org.jooq.meta.postgres.pg_catalog.Tables.PG_TYPE))).join((TableLike)org.jooq.meta.postgres.pg_catalog.Tables.PG_NAMESPACE).on(org.jooq.meta.postgres.pg_catalog.Tables.PG_TYPE.TYPNAMESPACE.eq(PostgresDSL.oid((Table)org.jooq.meta.postgres.pg_catalog.Tables.PG_NAMESPACE))).where(org.jooq.meta.postgres.pg_catalog.Tables.PG_NAMESPACE.NSPNAME.eq((Object)nspname)).and(org.jooq.meta.postgres.pg_catalog.Tables.PG_TYPE.TYPNAME.eq((Object)typname)).orderBy(orderBy).fetch(org.jooq.meta.postgres.pg_catalog.Tables.PG_ENUM.ENUMLABEL);
    }
}

