/*
 * Decompiled with CFR 0.152.
 */
package jodd.mail;

import java.util.Properties;
import javax.mail.Authenticator;
import javax.mail.NoSuchProviderException;
import javax.mail.Session;
import javax.mail.Store;
import jodd.mail.MailException;
import jodd.mail.ReceiveMailSession;
import jodd.mail.ReceiveMailSessionProvider;
import jodd.mail.SimpleAuthenticator;

public class Pop3Server
implements ReceiveMailSessionProvider {
    protected static final String MAIL_POP3_PORT = "mail.pop3.port";
    protected static final String MAIL_POP3_HOST = "mail.pop3.host";
    protected static final String MAIL_POP3_AUTH = "mail.pop3.auth";
    protected static final String PROTOCOL_POP3 = "pop3";
    protected static final int DEFAULT_POP3_PORT = 110;
    protected final String host;
    protected final int port;
    protected final Authenticator authenticator;
    protected final Properties sessionProperties;

    public Pop3Server(String host) {
        this(host, 110, null);
    }

    public Pop3Server(String host, int port) {
        this(host, port, null);
    }

    public Pop3Server(String host, Authenticator authenticator) {
        this(host, 110, authenticator);
    }

    public Pop3Server(String host, int port, String username, String password) {
        this(host, port, new SimpleAuthenticator(username, password));
    }

    public Pop3Server(String host, int port, Authenticator authenticator) {
        this.host = host;
        this.port = port;
        this.authenticator = authenticator;
        this.sessionProperties = this.createSessionProperties();
    }

    protected Properties createSessionProperties() {
        Properties props = new Properties();
        props.setProperty(MAIL_POP3_HOST, this.host);
        props.setProperty(MAIL_POP3_PORT, String.valueOf(this.port));
        if (this.authenticator != null) {
            props.setProperty(MAIL_POP3_AUTH, "true");
        }
        return props;
    }

    @Override
    public ReceiveMailSession createSession() {
        Store store;
        Session session = Session.getInstance((Properties)this.sessionProperties, (Authenticator)this.authenticator);
        try {
            store = this.getStore(session);
        }
        catch (NoSuchProviderException nspex) {
            throw new MailException("Failed to create POP3 session", nspex);
        }
        return new ReceiveMailSession(session, store);
    }

    protected Store getStore(Session session) throws NoSuchProviderException {
        return session.getStore(PROTOCOL_POP3);
    }

    public String getHost() {
        return this.host;
    }

    public Authenticator getAuthenticator() {
        return this.authenticator;
    }

    public int getPort() {
        return this.port;
    }
}

