/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.tasks;

import java.io.File;
import java.io.Serializable;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.zip.ZipFile;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ResolvedArtifact;
import org.gradle.api.artifacts.ResolvedConfiguration;
import org.gradle.api.artifacts.ResolvedDependency;
import org.gradle.api.plugins.PluginContainer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.gradle.plugin.KotlinBasePluginWrapper;
import org.jetbrains.kotlin.gradle.plugin.KotlinPlugin;
import org.jetbrains.kotlin.gradle.tasks.JarSearchingUtilKt;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=2, d1={"\u0000B\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u001c\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\u001a\u0016\u0010\u0013\u001a\u0004\u0018\u00010\u00142\n\u0010\u0015\u001a\u0006\u0012\u0002\b\u00030\u0016H\u0002\u001a\u0016\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00140\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0000\u001a\u0016\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00140\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0000\u001a\u0016\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00140\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0000\u001a\u0016\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00140\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0000\u001a\u0016\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00140\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0000\u001a\u001a\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u0001H\u0002\u001a&\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00140\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010%\u001a\u00020\u00012\u0006\u0010#\u001a\u00020\u0001H\u0002\u001a\u0016\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00140\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0000\u001a\u0016\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00140\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0000\u001a\u0016\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00140\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0000\u001a\u001e\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00140*2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010#\u001a\u00020\u0001H\u0002\u001a\n\u0010+\u001a\u0004\u0018\u00010\u0014H\u0000\u001a\n\u0010,\u001a\u0004\u0018\u00010\u0014H\u0000\u001a\u001a\u0010-\u001a\u0004\u0018\u00010\u00142\u0006\u0010#\u001a\u00020\u00012\u0006\u0010.\u001a\u00020\u0001H\u0002\u001a\u0012\u0010/\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0019\u001a\u00020\u001aH\u0002\u001a\u0014\u00100\u001a\u000201*\u00020\u00142\u0006\u00102\u001a\u00020\u0001H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082D\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082D\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0082D\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0082D\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0006\u001a\u00020\u0001X\u0082D\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0007\u001a\u00020\u0001X\u0082D\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\b\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\t\u001a\u00020\u0001X\u0082D\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\n\u001a\u00020\u0001X\u0082D\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u000b\u001a\u00020\u0001X\u0082D\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\f\u001a\u00020\u0001X\u0082D\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\r\u001a\u00020\u0001X\u0082D\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u000e\u001a\u00020\u0001X\u0082D\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u000f\u001a\u00020\u0001X\u0082D\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0010\u001a\u00020\u0001X\u0082D\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0011\u001a\u00020\u0001X\u0082D\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0012\u001a\u00020\u0001X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"K2JS_COMPILER_CLASS", "", "K2JS_DCE_CLASS", "K2JVM_COMPILER_CLASS", "K2METADATA_COMPILER_CLASS", "KOTLIN_COMPILER_EMBEDDABLE", "KOTLIN_GRADLE_PLUGIN", "KOTLIN_JVM_SCRIPT_COMPILER_EXPECTED_CLASS", "KOTLIN_MODULE_GROUP", "KOTLIN_REFLECT", "KOTLIN_REFLECT_EXPECTED_CLASS", "KOTLIN_SCRIPT_ANNOTATION_EXPECTED_CLASS", "KOTLIN_SCRIPT_COMMON", "KOTLIN_SCRIPT_JVM", "KOTLIN_SCRIPT_RUNTIME", "KOTLIN_SCRIPT_RUNTIME_EXPECTED_CLASS", "KOTLIN_STDLIB", "KOTLIN_STDLIB_EXPECTED_CLASS", "TROVE4J_EXPECTED_CLASS", "findJarByClass", "Ljava/io/File;", "klass", "Ljava/lang/Class;", "findKotlinCompilerClasspath", "", "project", "Lorg/gradle/api/Project;", "findKotlinJsCompilerClasspath", "findKotlinJsDceClasspath", "findKotlinJvmCompilerClasspath", "findKotlinMetadataCompilerClasspath", "findKotlinModuleDependency", "Lorg/gradle/api/artifacts/ResolvedDependency;", "configuration", "Lorg/gradle/api/artifacts/Configuration;", "moduleId", "findKotlinModuleJar", "expectedClassName", "findKotlinReflectClasspath", "findKotlinScriptRuntimeClasspath", "findKotlinStdlibClasspath", "findPotentialModuleJars", "", "findToolsJar", "findTrove4j", "getModuleFromClassLoader", "moduleVersion", "pluginVersionFromAppliedPlugin", "hasEntry", "", "entryToFind", "kotlin-gradle-plugin"})
public final class JarSearchingUtilKt {
    private static final String K2JVM_COMPILER_CLASS = "org.jetbrains.kotlin.cli.jvm.K2JVMCompiler";
    private static final String K2JS_COMPILER_CLASS = "org.jetbrains.kotlin.cli.js.K2JSCompiler";
    private static final String K2JS_DCE_CLASS = "org.jetbrains.kotlin.cli.js.dce.K2JSDce";
    private static final String K2METADATA_COMPILER_CLASS = "org.jetbrains.kotlin.cli.metadata.K2MetadataCompiler";
    private static final String KOTLIN_STDLIB_EXPECTED_CLASS = "kotlin.collections.ArraysKt";
    private static final String KOTLIN_SCRIPT_RUNTIME_EXPECTED_CLASS = "kotlin.script.templates.AnnotationsKt";
    private static final String KOTLIN_SCRIPT_ANNOTATION_EXPECTED_CLASS = "kotlin.script.experimental.annotations.KotlinScript";
    private static final String KOTLIN_JVM_SCRIPT_COMPILER_EXPECTED_CLASS = "kotlin.script.experimental.jvm.JvmScriptCompiler";
    private static final String KOTLIN_REFLECT_EXPECTED_CLASS = "kotlin.reflect.full.KClasses";
    private static final String TROVE4J_EXPECTED_CLASS = "gnu.trove.THashMap";
    @NotNull
    public static final String KOTLIN_MODULE_GROUP = "org.jetbrains.kotlin";
    private static final String KOTLIN_GRADLE_PLUGIN = "kotlin-gradle-plugin";
    @NotNull
    public static final String KOTLIN_COMPILER_EMBEDDABLE = "kotlin-compiler-embeddable";
    private static final String KOTLIN_STDLIB = "kotlin-stdlib";
    private static final String KOTLIN_SCRIPT_RUNTIME = "kotlin-script-runtime";
    private static final String KOTLIN_SCRIPT_COMMON = "kotlin-scripting-common";
    private static final String KOTLIN_SCRIPT_JVM = "kotlin-scripting-jvm";
    private static final String KOTLIN_REFLECT = "kotlin-reflect";

    @NotNull
    public static final List<File> findKotlinJvmCompilerClasspath(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        List list2 = JarSearchingUtilKt.findKotlinModuleJar(project, K2JVM_COMPILER_CLASS, KOTLIN_COMPILER_EMBEDDABLE);
        boolean bl = false;
        boolean bl2 = false;
        List it = list2;
        boolean bl3 = false;
        return it.isEmpty() ? it : CollectionsKt.plus((Collection)it, (Iterable)JarSearchingUtilKt.findKotlinCompilerClasspath(project));
    }

    @NotNull
    public static final List<File> findKotlinJsCompilerClasspath(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        List list2 = JarSearchingUtilKt.findKotlinModuleJar(project, K2JS_COMPILER_CLASS, KOTLIN_COMPILER_EMBEDDABLE);
        boolean bl = false;
        boolean bl2 = false;
        List it = list2;
        boolean bl3 = false;
        return it.isEmpty() ? it : CollectionsKt.plus((Collection)it, (Iterable)JarSearchingUtilKt.findKotlinCompilerClasspath(project));
    }

    @NotNull
    public static final List<File> findKotlinMetadataCompilerClasspath(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        List list2 = JarSearchingUtilKt.findKotlinModuleJar(project, K2METADATA_COMPILER_CLASS, KOTLIN_COMPILER_EMBEDDABLE);
        boolean bl = false;
        boolean bl2 = false;
        List it = list2;
        boolean bl3 = false;
        return it.isEmpty() ? it : CollectionsKt.plus((Collection)it, (Iterable)JarSearchingUtilKt.findKotlinCompilerClasspath(project));
    }

    @NotNull
    public static final List<File> findKotlinJsDceClasspath(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        List list2 = JarSearchingUtilKt.findKotlinModuleJar(project, K2JS_DCE_CLASS, KOTLIN_COMPILER_EMBEDDABLE);
        boolean bl = false;
        boolean bl2 = false;
        List it = list2;
        boolean bl3 = false;
        return it.isEmpty() ? it : CollectionsKt.plus((Collection)it, (Iterable)JarSearchingUtilKt.findKotlinCompilerClasspath(project));
    }

    @NotNull
    public static final List<File> findKotlinCompilerClasspath(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        return CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)JarSearchingUtilKt.findKotlinStdlibClasspath(project), (Iterable)JarSearchingUtilKt.findKotlinScriptRuntimeClasspath(project)), (Iterable)JarSearchingUtilKt.findKotlinReflectClasspath(project)), (Iterable)CollectionsKt.listOfNotNull((Object)JarSearchingUtilKt.findTrove4j()));
    }

    @Nullable
    public static final File findTrove4j() {
        Class<?> clazz;
        Thread thread = Thread.currentThread();
        Intrinsics.checkExpressionValueIsNotNull((Object)thread, (String)"Thread.currentThread()");
        ClassLoader classLoader = thread.getContextClassLoader();
        try {
            clazz = classLoader.loadClass(TROVE4J_EXPECTED_CLASS);
        }
        catch (ClassNotFoundException e) {
            clazz = null;
        }
        Class<?> clazz2 = clazz;
        if (clazz2 == null) {
            return null;
        }
        Class<?> classFromTrove4j = clazz2;
        return JarSearchingUtilKt.findJarByClass(classFromTrove4j);
    }

    @NotNull
    public static final List<File> findKotlinStdlibClasspath(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        return JarSearchingUtilKt.findKotlinModuleJar(project, KOTLIN_STDLIB_EXPECTED_CLASS, KOTLIN_STDLIB);
    }

    @NotNull
    public static final List<File> findKotlinScriptRuntimeClasspath(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        return JarSearchingUtilKt.findKotlinModuleJar(project, KOTLIN_SCRIPT_RUNTIME_EXPECTED_CLASS, KOTLIN_SCRIPT_RUNTIME);
    }

    @NotNull
    public static final List<File> findKotlinReflectClasspath(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        return JarSearchingUtilKt.findKotlinModuleJar(project, KOTLIN_REFLECT_EXPECTED_CLASS, KOTLIN_REFLECT);
    }

    @Nullable
    public static final File findToolsJar() {
        File file;
        Class<?> javacUtilContextClass;
        Class<?> clazz;
        try {
            clazz = Class.forName("com.sun.tools.javac.util.Context");
        }
        catch (ClassNotFoundException classNotFound) {
            String string;
            String string2;
            boolean bl;
            StringBuilder stringBuilder;
            String string3;
            String javaHome = System.getProperty("java.home");
            StringBuilder stringBuilder2 = new StringBuilder().append("Kotlin could not find the required JDK tools in the Java installation ");
            String string4 = javaHome;
            if (string4 != null) {
                string3 = string4;
                stringBuilder = stringBuilder2;
                bl = false;
                boolean bl2 = false;
                String it = string3;
                boolean bl3 = false;
                string2 = '\'' + it + "' ";
                stringBuilder2 = stringBuilder;
                string = string2;
            } else {
                string = null;
            }
            string3 = string;
            stringBuilder = stringBuilder2;
            bl = false;
            String string5 = string3;
            if (string5 == null) {
                string5 = "";
            }
            string2 = string5;
            Throwable throwable = classNotFound;
            String string6 = stringBuilder.append(string2).append("used by Gradle. Make sure Gradle is running on a JDK, not JRE.").toString();
            throw (Throwable)new GradleException(string6, throwable);
        }
        Class<?> clazz2 = javacUtilContextClass = clazz;
        if (clazz2 != null) {
            clazz = clazz2;
            boolean bl = false;
            boolean bl4 = false;
            Class<?> p1 = clazz;
            boolean bl5 = false;
            file = JarSearchingUtilKt.findJarByClass(p1);
        } else {
            file = null;
        }
        return file;
    }

    private static final File findJarByClass(Class<?> klass) {
        String uri;
        StringBuilder stringBuilder = new StringBuilder();
        String string = klass.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"klass.name");
        String classFileName = stringBuilder.append(StringsKt.substringAfterLast$default((String)string, (String)".", null, (int)2, null)).append(".class").toString();
        URL uRL = klass.getResource(classFileName);
        if (uRL == null) {
            return null;
        }
        URL resource = uRL;
        String string2 = uri = resource.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"uri");
        if (!StringsKt.startsWith$default((String)string2, (String)"jar:file:", (boolean)false, (int)2, null)) {
            return null;
        }
        String fileName = URLDecoder.decode(StringsKt.substringBefore$default((String)StringsKt.removePrefix((String)uri, (CharSequence)"jar:file:"), (String)"!", null, (int)2, null), Charset.defaultCharset().name());
        return new File(fileName);
    }

    private static final List<File> findKotlinModuleJar(Project project, String expectedClassName, String moduleId) {
        Object object;
        block8: {
            block7: {
                Object v6;
                boolean bl;
                block6: {
                    File file;
                    Sequence sequence;
                    Sequence sequence2;
                    String pluginVersion = JarSearchingUtilKt.pluginVersionFromAppliedPlugin(project);
                    Sequence sequence3 = new File[1];
                    Sequence sequence4 = sequence3;
                    Sequence sequence5 = sequence3;
                    int n = 0;
                    String string = pluginVersion;
                    if (string != null) {
                        String string2 = string;
                        int n2 = n;
                        sequence2 = sequence4;
                        sequence = sequence5;
                        boolean bl2 = false;
                        bl = false;
                        String version = string2;
                        boolean bl3 = false;
                        File file2 = JarSearchingUtilKt.getModuleFromClassLoader(moduleId, version);
                        sequence5 = sequence;
                        sequence4 = sequence2;
                        n = n2;
                        file = file2;
                    } else {
                        file = null;
                    }
                    sequence4[n] = file;
                    sequence = SequencesKt.sequenceOf((Object[])sequence5);
                    boolean bl4 = false;
                    sequence2 = (Sequence)new Sequence<File>(project, moduleId){
                        final /* synthetic */ Project $project$inlined;
                        final /* synthetic */ String $moduleId$inlined;
                        {
                            this.$project$inlined = project;
                            this.$moduleId$inlined = string;
                        }

                        @NotNull
                        public Iterator<File> iterator() {
                            boolean bl = false;
                            return JarSearchingUtilKt.access$findPotentialModuleJars(this.$project$inlined, this.$moduleId$inlined).iterator();
                        }
                    };
                    Sequence filesToCheck = SequencesKt.plus((Sequence)sequence, (Sequence)sequence2);
                    String entryToFind = StringsKt.replace$default((String)expectedClassName, (String)".", (String)"/", (boolean)false, (int)4, null) + ".class";
                    Sequence $this$firstOrNull$iv = SequencesKt.filterNotNull((Sequence)filesToCheck);
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        File it = (File)element$iv;
                        boolean bl5 = false;
                        if (!JarSearchingUtilKt.hasEntry(it, entryToFind)) continue;
                        v6 = element$iv;
                        break block6;
                    }
                    v6 = null;
                }
                if ((object = (File)v6) == null) break block7;
                File file = object;
                bl = false;
                boolean bl6 = false;
                File it = file;
                boolean bl7 = false;
                object = CollectionsKt.listOf((Object)it);
                if (object != null) break block8;
            }
            object = CollectionsKt.emptyList();
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    private static final String pluginVersionFromAppliedPlugin(Project project) {
        void $this$filterIsInstanceTo$iv$iv;
        PluginContainer pluginContainer = project.getPlugins();
        Intrinsics.checkExpressionValueIsNotNull((Object)pluginContainer, (String)"project.plugins");
        Iterable $this$filterIsInstance$iv = (Iterable)pluginContainer;
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof KotlinBasePluginWrapper)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        KotlinBasePluginWrapper kotlinBasePluginWrapper = (KotlinBasePluginWrapper)CollectionsKt.firstOrNull((List)((List)destination$iv$iv));
        return kotlinBasePluginWrapper != null ? kotlinBasePluginWrapper.getKotlinPluginVersion() : null;
    }

    private static final File getModuleFromClassLoader(String moduleId, String moduleVersion) {
        Serializable serializable;
        URL uRL;
        block5: {
            ClassLoader classLoader = KotlinPlugin.class.getClassLoader();
            if (!(classLoader instanceof URLClassLoader)) {
                classLoader = null;
            }
            URLClassLoader uRLClassLoader = (URLClassLoader)classLoader;
            if (uRLClassLoader == null) {
                return null;
            }
            URLClassLoader urlClassLoader = uRLClassLoader;
            URL[] uRLArray = urlClassLoader.getURLs();
            Intrinsics.checkExpressionValueIsNotNull((Object)uRLArray, (String)"urlClassLoader.urLs");
            URL[] $this$firstOrNull$iv = uRLArray;
            boolean $i$f$firstOrNull = false;
            URL[] uRLArray2 = $this$firstOrNull$iv;
            int n = uRLArray2.length;
            for (int j = 0; j < n; ++j) {
                URL element$iv;
                URL it = element$iv = uRLArray2[j];
                boolean bl = false;
                String string = it.toString();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"it.toString()");
                if (!StringsKt.endsWith$default((String)string, (String)(moduleId + '-' + moduleVersion + ".jar"), (boolean)false, (int)2, null)) continue;
                uRL = element$iv;
                break block5;
            }
            uRL = null;
        }
        if (uRL != null) {
            Serializable serializable2 = uRL;
            boolean bl = false;
            boolean bl2 = false;
            URL it = serializable2;
            boolean bl3 = false;
            serializable2 = new File(it.toURI());
            bl = false;
            bl2 = false;
            Serializable p1 = serializable2;
            boolean bl4 = false;
            serializable = ((File)p1).exists() ? serializable2 : null;
        } else {
            serializable = null;
        }
        return serializable;
    }

    /*
     * WARNING - void declaration
     */
    private static final Iterable<File> findPotentialModuleJars(Project project, String moduleId) {
        Sequence projects2 = SequencesKt.generateSequence((Object)project, (Function1)findPotentialModuleJars.projects.1.INSTANCE);
        Sequence classpathConfigurations2 = SequencesKt.filterNotNull((Sequence)SequencesKt.map((Sequence)projects2, (Function1)findPotentialModuleJars.classpathConfigurations.1.INSTANCE));
        HashSet allFiles = new HashSet();
        Iterator iterator = classpathConfigurations2.iterator();
        while (iterator.hasNext()) {
            Configuration configuration2;
            Configuration configuration3 = configuration2 = (Configuration)iterator.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)configuration3, (String)"configuration");
            ResolvedDependency compilerEmbeddable = JarSearchingUtilKt.findKotlinModuleDependency(configuration3, moduleId);
            if (compilerEmbeddable != null) {
                void $this$mapTo$iv$iv;
                Set set = compilerEmbeddable.getModuleArtifacts();
                Intrinsics.checkExpressionValueIsNotNull((Object)set, (String)"compilerEmbeddable.moduleArtifacts");
                Iterable $this$map$iv = set;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    ResolvedArtifact resolvedArtifact = (ResolvedArtifact)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    void v2 = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)v2, (String)"it");
                    File file = v2.getFile();
                    collection.add(file);
                }
                return (List)destination$iv$iv;
            }
            allFiles.addAll(configuration2.getFiles());
        }
        return allFiles;
    }

    private static final ResolvedDependency findKotlinModuleDependency(Configuration configuration2, String moduleId) {
        Set firstLevelModuleDependencies;
        findKotlinModuleDependency.1 $fun$findDependency$1 = findKotlinModuleDependency.1.INSTANCE;
        ResolvedConfiguration resolvedConfiguration = configuration2.getResolvedConfiguration();
        Intrinsics.checkExpressionValueIsNotNull((Object)resolvedConfiguration, (String)"configuration.resolvedConfiguration");
        Set set = firstLevelModuleDependencies = resolvedConfiguration.getFirstLevelModuleDependencies();
        Intrinsics.checkExpressionValueIsNotNull((Object)set, (String)"firstLevelModuleDependencies");
        ResolvedDependency gradlePlugin = $fun$findDependency$1.invoke(set, KOTLIN_MODULE_GROUP, KOTLIN_GRADLE_PLUGIN);
        Object object = gradlePlugin;
        return object != null && (object = object.getChildren()) != null ? $fun$findDependency$1.invoke((Iterable)object, KOTLIN_MODULE_GROUP, moduleId) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final boolean hasEntry(@NotNull File $receiver, String entryToFind) {
        try (ZipFile zip = new ZipFile($receiver);){
            boolean bl = zip.getEntry(entryToFind) != null;
            return bl;
        }
    }

    static {
        K2JVM_COMPILER_CLASS = K2JVM_COMPILER_CLASS;
        K2JS_COMPILER_CLASS = K2JS_COMPILER_CLASS;
        K2JS_DCE_CLASS = K2JS_DCE_CLASS;
        K2METADATA_COMPILER_CLASS = K2METADATA_COMPILER_CLASS;
        KOTLIN_STDLIB_EXPECTED_CLASS = KOTLIN_STDLIB_EXPECTED_CLASS;
        KOTLIN_SCRIPT_RUNTIME_EXPECTED_CLASS = KOTLIN_SCRIPT_RUNTIME_EXPECTED_CLASS;
        KOTLIN_SCRIPT_ANNOTATION_EXPECTED_CLASS = KOTLIN_SCRIPT_ANNOTATION_EXPECTED_CLASS;
        KOTLIN_JVM_SCRIPT_COMPILER_EXPECTED_CLASS = KOTLIN_JVM_SCRIPT_COMPILER_EXPECTED_CLASS;
        KOTLIN_REFLECT_EXPECTED_CLASS = KOTLIN_REFLECT_EXPECTED_CLASS;
        TROVE4J_EXPECTED_CLASS = TROVE4J_EXPECTED_CLASS;
        KOTLIN_GRADLE_PLUGIN = KOTLIN_GRADLE_PLUGIN;
        KOTLIN_STDLIB = KOTLIN_STDLIB;
        KOTLIN_SCRIPT_RUNTIME = KOTLIN_SCRIPT_RUNTIME;
        KOTLIN_SCRIPT_COMMON = KOTLIN_SCRIPT_COMMON;
        KOTLIN_SCRIPT_JVM = KOTLIN_SCRIPT_JVM;
        KOTLIN_REFLECT = KOTLIN_REFLECT;
    }

    public static final /* synthetic */ Iterable access$findPotentialModuleJars(Project project, String moduleId) {
        return JarSearchingUtilKt.findPotentialModuleJars(project, moduleId);
    }
}

