/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.plugin.mpp;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Named;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.gradle.plugin.mpp.KotlinNativeCompilation;
import org.jetbrains.kotlin.gradle.plugin.mpp.KotlinNativeTarget;
import org.jetbrains.kotlin.gradle.plugin.mpp.NativeBuildType;
import org.jetbrains.kotlin.gradle.plugin.mpp.NativeOutputKind;
import org.jetbrains.kotlin.gradle.tasks.KotlinNativeLink;
import org.jetbrains.kotlin.gradle.utils.StringUtilsKt;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001B'\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\b\u0010>\u001a\u00020\u0003H\u0016J\u001f\u0010&\u001a\u00020?2\u0012\u0010@\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00030A\"\u00020\u0003\u00a2\u0006\u0002\u0010BJ\u0014\u0010&\u001a\u00020?2\f\u0010@\u001a\b\u0012\u0004\u0012\u00020\u00030CR\u001a\u0010\u0004\u001a\u00020\u0003X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\u00020\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R \u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00030\u001bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR\u0011\u0010 \u001a\u00020!8F\u00a2\u0006\u0006\u001a\u0004\b\"\u0010#R\u0011\u0010$\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b%\u0010\u000bR \u0010&\u001a\b\u0012\u0004\u0012\u00020\u00030\u001bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010\u001d\"\u0004\b(\u0010\u001fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010)\u001a\u00020\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b*\u0010\u0017\"\u0004\b+\u0010\u0019R\u0011\u0010,\u001a\u00020-\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010/R\u0011\u00100\u001a\u00020-8F\u00a2\u0006\u0006\u001a\u0004\b1\u0010/R\u0012\u00102\u001a\u000203X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b4\u00105R\u0011\u00106\u001a\u0002078F\u00a2\u0006\u0006\u001a\u0004\b8\u00109R\u0011\u0010:\u001a\u00020;8F\u00a2\u0006\u0006\u001a\u0004\b<\u0010=\u0082\u0001\u0004DEFG\u00a8\u0006H"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/mpp/NativeBinary;", "Lorg/gradle/api/Named;", "name", "", "baseName", "buildType", "Lorg/jetbrains/kotlin/gradle/plugin/mpp/NativeBuildType;", "compilation", "Lorg/jetbrains/kotlin/gradle/plugin/mpp/KotlinNativeCompilation;", "(Ljava/lang/String;Ljava/lang/String;Lorg/jetbrains/kotlin/gradle/plugin/mpp/NativeBuildType;Lorg/jetbrains/kotlin/gradle/plugin/mpp/KotlinNativeCompilation;)V", "getBaseName", "()Ljava/lang/String;", "setBaseName", "(Ljava/lang/String;)V", "getBuildType", "()Lorg/jetbrains/kotlin/gradle/plugin/mpp/NativeBuildType;", "getCompilation", "()Lorg/jetbrains/kotlin/gradle/plugin/mpp/KotlinNativeCompilation;", "setCompilation", "(Lorg/jetbrains/kotlin/gradle/plugin/mpp/KotlinNativeCompilation;)V", "debuggable", "", "getDebuggable", "()Z", "setDebuggable", "(Z)V", "freeCompilerArgs", "", "getFreeCompilerArgs", "()Ljava/util/List;", "setFreeCompilerArgs", "(Ljava/util/List;)V", "linkTask", "Lorg/jetbrains/kotlin/gradle/tasks/KotlinNativeLink;", "getLinkTask", "()Lorg/jetbrains/kotlin/gradle/tasks/KotlinNativeLink;", "linkTaskName", "getLinkTaskName", "linkerOpts", "getLinkerOpts", "setLinkerOpts", "optimized", "getOptimized", "setOptimized", "outputDirectory", "Ljava/io/File;", "getOutputDirectory", "()Ljava/io/File;", "outputFile", "getOutputFile", "outputKind", "Lorg/jetbrains/kotlin/gradle/plugin/mpp/NativeOutputKind;", "getOutputKind", "()Lorg/jetbrains/kotlin/gradle/plugin/mpp/NativeOutputKind;", "project", "Lorg/gradle/api/Project;", "getProject", "()Lorg/gradle/api/Project;", "target", "Lorg/jetbrains/kotlin/gradle/plugin/mpp/KotlinNativeTarget;", "getTarget", "()Lorg/jetbrains/kotlin/gradle/plugin/mpp/KotlinNativeTarget;", "getName", "", "options", "", "([Ljava/lang/String;)V", "", "Lorg/jetbrains/kotlin/gradle/plugin/mpp/Executable;", "Lorg/jetbrains/kotlin/gradle/plugin/mpp/StaticLibrary;", "Lorg/jetbrains/kotlin/gradle/plugin/mpp/SharedLibrary;", "Lorg/jetbrains/kotlin/gradle/plugin/mpp/Framework;", "kotlin-gradle-plugin"})
public abstract class NativeBinary
implements Named {
    private boolean debuggable;
    private boolean optimized;
    @NotNull
    private List<String> linkerOpts;
    @NotNull
    private List<String> freeCompilerArgs;
    @NotNull
    private final File outputDirectory;
    private final String name;
    @NotNull
    private String baseName;
    @NotNull
    private final NativeBuildType buildType;
    @NotNull
    private KotlinNativeCompilation compilation;

    @NotNull
    public final KotlinNativeTarget getTarget() {
        return this.compilation.getTarget();
    }

    @NotNull
    public final Project getProject() {
        return this.getTarget().getProject();
    }

    @NotNull
    public abstract NativeOutputKind getOutputKind();

    public final boolean getDebuggable() {
        return this.debuggable;
    }

    public final void setDebuggable(boolean bl) {
        this.debuggable = bl;
    }

    public final boolean getOptimized() {
        return this.optimized;
    }

    public final void setOptimized(boolean bl) {
        this.optimized = bl;
    }

    @NotNull
    public final List<String> getLinkerOpts() {
        return this.linkerOpts;
    }

    public final void setLinkerOpts(@NotNull List<String> list2) {
        Intrinsics.checkParameterIsNotNull(list2, (String)"<set-?>");
        this.linkerOpts = list2;
    }

    public final void linkerOpts(String ... options) {
        Intrinsics.checkParameterIsNotNull((Object)options, (String)"options");
        this.linkerOpts.addAll(ArraysKt.toList((Object[])options));
    }

    public final void linkerOpts(@NotNull Iterable<String> options) {
        Intrinsics.checkParameterIsNotNull(options, (String)"options");
        CollectionsKt.addAll((Collection)this.linkerOpts, options);
    }

    @NotNull
    public final List<String> getFreeCompilerArgs() {
        return this.freeCompilerArgs;
    }

    public final void setFreeCompilerArgs(@NotNull List<String> list2) {
        Intrinsics.checkParameterIsNotNull(list2, (String)"<set-?>");
        this.freeCompilerArgs = list2;
    }

    @NotNull
    public final String getLinkTaskName() {
        return StringUtilsKt.lowerCamelCaseName("link", this.name, this.getTarget().getTargetName());
    }

    @NotNull
    public final KotlinNativeLink getLinkTask() {
        Task task = this.getProject().getTasks().getByName(this.getLinkTaskName());
        if (task == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.gradle.tasks.KotlinNativeLink");
        }
        return (KotlinNativeLink)task;
    }

    @NotNull
    public final File getOutputDirectory() {
        return this.outputDirectory;
    }

    @NotNull
    public final File getOutputFile() {
        Object object = this.getLinkTask().getOutputFile().get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"linkTask.outputFile.get()");
        return (File)object;
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    @NotNull
    public String getBaseName() {
        return this.baseName;
    }

    public void setBaseName(@NotNull String string) {
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"<set-?>");
        this.baseName = string;
    }

    @NotNull
    public final NativeBuildType getBuildType() {
        return this.buildType;
    }

    @NotNull
    public final KotlinNativeCompilation getCompilation() {
        return this.compilation;
    }

    public final void setCompilation(@NotNull KotlinNativeCompilation kotlinNativeCompilation) {
        Intrinsics.checkParameterIsNotNull((Object)kotlinNativeCompilation, (String)"<set-?>");
        this.compilation = kotlinNativeCompilation;
    }

    private NativeBinary(String name, String baseName, NativeBuildType buildType, KotlinNativeCompilation compilation) {
        String string;
        boolean bl;
        String string2;
        this.name = name;
        this.baseName = baseName;
        this.buildType = buildType;
        this.compilation = compilation;
        this.debuggable = this.buildType.getDebuggable();
        this.optimized = this.buildType.getOptimized();
        NativeBinary nativeBinary = this;
        boolean bl2 = false;
        Object object = new ArrayList();
        nativeBinary.linkerOpts = object;
        nativeBinary = this;
        bl2 = false;
        object = new ArrayList();
        nativeBinary.freeCompilerArgs = object;
        Project project = this.getProject();
        nativeBinary = this;
        boolean bl3 = false;
        boolean bl4 = false;
        Project $receiver = project;
        boolean bl5 = false;
        String string3 = this.getTarget().getDisambiguationClassifier();
        if (string3 != null) {
            string2 = string3;
            bl = false;
            boolean bl6 = false;
            String it = string2;
            boolean bl7 = false;
            string = it + '/';
        } else {
            string = null;
        }
        string2 = string;
        bl = false;
        String string4 = string2;
        if (string4 == null) {
            string4 = "";
        }
        String targetSubDirectory = string4;
        File file = $receiver.getBuildDir();
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"buildDir");
        nativeBinary.outputDirectory = object = FilesKt.resolve((File)file, (String)("bin/" + targetSubDirectory + this.name));
    }

    public /* synthetic */ NativeBinary(String name, String baseName, NativeBuildType buildType, KotlinNativeCompilation compilation, DefaultConstructorMarker $constructor_marker) {
        this(name, baseName, buildType, compilation);
    }
}

