/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.plugin;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.tooling.provider.model.ToolingModelBuilder;
import org.gradle.tooling.provider.model.ToolingModelBuilderRegistry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.gradle.dsl.KotlinAndroidProjectExtension;
import org.jetbrains.kotlin.gradle.dsl.KotlinProjectExtension;
import org.jetbrains.kotlin.gradle.dsl.KotlinProjectExtensionKt;
import org.jetbrains.kotlin.gradle.model.builder.KotlinModelBuilder;
import org.jetbrains.kotlin.gradle.plugin.AbstractAndroidProjectHandler;
import org.jetbrains.kotlin.gradle.plugin.Android25ProjectHandler;
import org.jetbrains.kotlin.gradle.plugin.KotlinConfigurationTools;
import org.jetbrains.kotlin.gradle.plugin.KotlinMultiplatformPluginKt;
import org.jetbrains.kotlin.gradle.plugin.KotlinPluginKt;
import org.jetbrains.kotlin.gradle.plugin.mpp.KotlinAndroidTarget;
import org.jetbrains.kotlin.gradle.tasks.AndroidTasksProvider;
import org.jetbrains.kotlin.gradle.utils.CompatibiltiyKt;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0010\u0018\u0000 \u000b2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u000bB\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0002H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/KotlinAndroidPlugin;", "Lorg/gradle/api/Plugin;", "Lorg/gradle/api/Project;", "kotlinPluginVersion", "", "registry", "Lorg/gradle/tooling/provider/model/ToolingModelBuilderRegistry;", "(Ljava/lang/String;Lorg/gradle/tooling/provider/model/ToolingModelBuilderRegistry;)V", "apply", "", "project", "Companion", "kotlin-gradle-plugin"})
public class KotlinAndroidPlugin
implements Plugin<Project> {
    private final String kotlinPluginVersion;
    private final ToolingModelBuilderRegistry registry;
    public static final Companion Companion = new Companion(null);

    public void apply(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        CompatibiltiyKt.checkGradleCompatibility$default(null, 1, null);
        KotlinAndroidTarget androidTarget = new KotlinAndroidTarget("", project);
        KotlinProjectExtension kotlinProjectExtension = KotlinProjectExtensionKt.getKotlinExtension(project);
        if (kotlinProjectExtension == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.gradle.dsl.KotlinAndroidProjectExtension");
        }
        ((KotlinAndroidProjectExtension)kotlinProjectExtension).setTarget$kotlin_gradle_plugin(androidTarget);
        Companion.applyToTarget(this.kotlinPluginVersion, androidTarget);
        org.jetbrains.kotlin.gradle.plugin.mpp.KotlinMultiplatformPluginKt.applyUserDefinedAttributes(androidTarget);
        this.registry.register((ToolingModelBuilder)new KotlinModelBuilder(this.kotlinPluginVersion, androidTarget));
        KotlinMultiplatformPluginKt.whenEvaluated(project, (Function1)new Function1<Project, Boolean>(project, androidTarget){
            final /* synthetic */ Project $project;
            final /* synthetic */ KotlinAndroidTarget $androidTarget;

            public final boolean invoke(@NotNull Project $receiver) {
                Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                return this.$project.getComponents().addAll((Collection)this.$androidTarget.getComponents());
            }
            {
                this.$project = project;
                this.$androidTarget = kotlinAndroidTarget;
                super(1);
            }
        });
    }

    public KotlinAndroidPlugin(@NotNull String kotlinPluginVersion, @NotNull ToolingModelBuilderRegistry registry) {
        Intrinsics.checkParameterIsNotNull((Object)kotlinPluginVersion, (String)"kotlinPluginVersion");
        Intrinsics.checkParameterIsNotNull((Object)registry, (String)"registry");
        this.kotlinPluginVersion = kotlinPluginVersion;
        this.registry = registry;
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0016\u0010\t\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\b\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/KotlinAndroidPlugin$Companion;", "", "()V", "androidTargetHandler", "Lorg/jetbrains/kotlin/gradle/plugin/AbstractAndroidProjectHandler;", "kotlinPluginVersion", "", "androidTarget", "Lorg/jetbrains/kotlin/gradle/plugin/mpp/KotlinAndroidTarget;", "applyToTarget", "", "kotlinTarget", "kotlin-gradle-plugin"})
    public static final class Companion {
        @NotNull
        public final AbstractAndroidProjectHandler<?> androidTargetHandler(@NotNull String kotlinPluginVersion, @NotNull KotlinAndroidTarget androidTarget) {
            String minimalVersion;
            Intrinsics.checkParameterIsNotNull((Object)kotlinPluginVersion, (String)"kotlinPluginVersion");
            Intrinsics.checkParameterIsNotNull((Object)androidTarget, (String)"androidTarget");
            AndroidTasksProvider tasksProvider = new AndroidTasksProvider(androidTarget.getTargetName());
            String version = KotlinPluginKt.loadAndroidPluginVersion();
            if (version != null && KotlinPluginKt.compareVersionNumbers(version, minimalVersion = "3.0.0") < 0) {
                throw (Throwable)new IllegalStateException("Kotlin: Unsupported version of com.android.tools.build:gradle plugin: version " + minimalVersion + " or higher should be used with kotlin-android plugin");
            }
            KotlinConfigurationTools kotlinTools = new KotlinConfigurationTools(tasksProvider, kotlinPluginVersion);
            return new Android25ProjectHandler(kotlinTools);
        }

        public final void applyToTarget(@NotNull String kotlinPluginVersion, @NotNull KotlinAndroidTarget kotlinTarget) {
            Intrinsics.checkParameterIsNotNull((Object)kotlinPluginVersion, (String)"kotlinPluginVersion");
            Intrinsics.checkParameterIsNotNull((Object)kotlinTarget, (String)"kotlinTarget");
            this.androidTargetHandler(kotlinPluginVersion, kotlinTarget).configureTarget(kotlinTarget);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

