/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.mapviewer.bmng;

import java.awt.Dimension;
import java.awt.geom.Point2D;
import org.jdesktop.swingx.mapviewer.DefaultTileFactory;
import org.jdesktop.swingx.mapviewer.GeoPosition;
import org.jdesktop.swingx.mapviewer.bmng.SLMapServerInfo;

public class CylindricalProjectionTileFactory
extends DefaultTileFactory {
    public CylindricalProjectionTileFactory() {
        this(new SLMapServerInfo());
    }

    public CylindricalProjectionTileFactory(SLMapServerInfo info) {
        super(info);
    }

    @Override
    public Dimension getMapSize(int zoom) {
        int midpoint = ((SLMapServerInfo)this.getInfo()).getMidpoint();
        if (zoom < midpoint) {
            int w = (int)Math.pow(2.0, midpoint - zoom);
            return new Dimension(w, w / 2);
        }
        return new Dimension(2, 1);
    }

    @Override
    public Point2D geoToPixel(GeoPosition c, int zoom) {
        Dimension mapSizeInTiles = this.getMapSize(zoom);
        double size_in_pixels = mapSizeInTiles.getWidth() * (double)this.getInfo().getTileSize(zoom);
        double ppd = size_in_pixels / 360.0;
        double centerX = (double)this.getTileSize(zoom) * mapSizeInTiles.getWidth() / 2.0;
        double centerY = (double)this.getTileSize(zoom) * mapSizeInTiles.getHeight() / 2.0;
        double x = c.getLongitude() * ppd + centerX;
        double y = -c.getLatitude() * ppd + centerY;
        return new Point2D.Double(x, y);
    }

    @Override
    public GeoPosition pixelToGeo(Point2D pix, int zoom) {
        Dimension mapSizeInTiles = this.getMapSize(zoom);
        double size_in_pixels = mapSizeInTiles.getWidth() * (double)this.getInfo().getTileSize(zoom);
        double ppd = size_in_pixels / 360.0;
        double centerX = (double)this.getTileSize(zoom) * mapSizeInTiles.getWidth() / 2.0;
        double centerY = (double)this.getTileSize(zoom) * mapSizeInTiles.getHeight() / 2.0;
        double lon = (pix.getX() - centerX) / ppd;
        double lat = -(pix.getY() - centerY) / ppd;
        return new GeoPosition(lat, lon);
    }
}

