/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workflow.instance.node;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.drools.RuntimeDroolsException;
import org.drools.runtime.process.EventListener;
import org.drools.runtime.process.NodeInstance;
import org.drools.time.TimeUtils;
import org.jbpm.process.core.timer.Timer;
import org.jbpm.process.instance.InternalProcessRuntime;
import org.jbpm.process.instance.context.variable.VariableScopeInstance;
import org.jbpm.process.instance.timer.TimerInstance;
import org.jbpm.workflow.core.node.TimerNode;
import org.jbpm.workflow.instance.impl.NodeInstanceResolverFactory;
import org.jbpm.workflow.instance.node.StateBasedNodeInstance;
import org.mvel2.MVEL;
import org.mvel2.integration.VariableResolverFactory;

public class TimerNodeInstance
extends StateBasedNodeInstance
implements EventListener {
    private static final long serialVersionUID = 510L;
    private static final Pattern PARAMETER_MATCHER = Pattern.compile("#\\{(\\S+)\\}", 32);
    private long timerId;

    public TimerNode getTimerNode() {
        return (TimerNode)this.getNode();
    }

    public long getTimerId() {
        return this.timerId;
    }

    public void internalSetTimerId(long timerId) {
        this.timerId = timerId;
    }

    public void internalTrigger(NodeInstance from, String type) {
        if (!"DROOLS_DEFAULT".equals(type)) {
            throw new IllegalArgumentException("A TimerNode only accepts default incoming connections!");
        }
        TimerInstance timer = this.createTimerInstance();
        if (this.getTimerInstances() == null) {
            this.addTimerListener();
        }
        ((InternalProcessRuntime)this.getProcessInstance().getKnowledgeRuntime().getProcessRuntime()).getTimerManager().registerTimer(timer, this.getProcessInstance());
        this.timerId = timer.getId();
    }

    protected TimerInstance createTimerInstance() {
        Timer timer = this.getTimerNode().getTimer();
        TimerInstance timerInstance = new TimerInstance();
        timerInstance.setDelay(this.resolveValue(timer.getDelay()));
        if (timer.getPeriod() == null) {
            timerInstance.setPeriod(0L);
        } else {
            timerInstance.setPeriod(this.resolveValue(timer.getPeriod()));
        }
        timerInstance.setTimerId(timer.getId());
        return timerInstance;
    }

    private long resolveValue(String s) {
        try {
            return TimeUtils.parseTimeString((String)s);
        }
        catch (RuntimeDroolsException e) {
            HashMap<String, String> replacements = new HashMap<String, String>();
            Matcher matcher = PARAMETER_MATCHER.matcher(s);
            while (matcher.find()) {
                String variableValueString;
                Object variableValue;
                String paramName = matcher.group(1);
                if (replacements.get(paramName) != null) continue;
                VariableScopeInstance variableScopeInstance = (VariableScopeInstance)this.resolveContextInstance("VariableScope", paramName);
                if (variableScopeInstance != null) {
                    variableValue = variableScopeInstance.getVariable(paramName);
                    variableValueString = variableValue == null ? "" : variableValue.toString();
                    replacements.put(paramName, variableValueString);
                    continue;
                }
                try {
                    variableValue = MVEL.eval((String)paramName, (VariableResolverFactory)new NodeInstanceResolverFactory(this));
                    variableValueString = variableValue == null ? "" : variableValue.toString();
                    replacements.put(paramName, variableValueString);
                }
                catch (Throwable t) {
                    System.err.println("Could not find variable scope for variable " + paramName);
                    System.err.println("when trying to replace variable in processId for sub process " + this.getNodeName());
                    System.err.println("Continuing without setting process id.");
                }
            }
            for (Map.Entry replacement : replacements.entrySet()) {
                s = s.replace("#{" + (String)replacement.getKey() + "}", (CharSequence)replacement.getValue());
            }
            return TimeUtils.parseTimeString((String)s);
        }
    }

    public void signalEvent(String type, Object event) {
        TimerInstance timer;
        if ("timerTriggered".equals(type) && (timer = (TimerInstance)event).getId() == this.timerId) {
            this.triggerCompleted(timer.getPeriod() == 0L);
        }
    }

    public String[] getEventTypes() {
        return new String[]{"timerTriggered"};
    }

    public void triggerCompleted(boolean remove) {
        this.triggerCompleted("DROOLS_DEFAULT", remove);
    }

    public void cancel() {
        ((InternalProcessRuntime)this.getProcessInstance().getKnowledgeRuntime().getProcessRuntime()).getTimerManager().cancelTimer(this.timerId);
        super.cancel();
    }

    public void addEventListeners() {
        super.addEventListeners();
        if (this.getTimerInstances() == null) {
            this.addTimerListener();
        }
    }

    public void removeEventListeners() {
        super.removeEventListeners();
        this.getProcessInstance().removeEventListener("timerTriggered", this, false);
    }
}

