/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.marshalling.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Map;
import org.drools.common.InternalWorkingMemory;
import org.drools.marshalling.impl.MarshallerReaderContext;
import org.drools.marshalling.impl.MarshallerWriteContext;
import org.drools.marshalling.impl.ProcessMarshaller;
import org.drools.process.instance.WorkItem;
import org.drools.process.instance.WorkItemManager;
import org.drools.process.instance.impl.WorkItemImpl;
import org.drools.runtime.process.ProcessInstance;
import org.jbpm.marshalling.impl.ProcessMarshallerRegistry;
import org.jbpm.process.instance.InternalProcessRuntime;
import org.jbpm.process.instance.timer.TimerInstance;
import org.jbpm.process.instance.timer.TimerManager;

public class ProcessMarshallerImpl
implements ProcessMarshaller {
    public void writeProcessInstances(MarshallerWriteContext context) throws IOException {
        MarshallerWriteContext stream = context.stream;
        ArrayList processInstances = new ArrayList(context.wm.getProcessInstances());
        Collections.sort(processInstances, new Comparator<ProcessInstance>(){

            @Override
            public int compare(ProcessInstance o1, ProcessInstance o2) {
                return (int)(o1.getId() - o2.getId());
            }
        });
        for (ProcessInstance processInstance : processInstances) {
            stream.writeShort(17);
            String processType = processInstance.getProcess().getType();
            stream.writeUTF(processType);
            ProcessMarshallerRegistry.INSTANCE.getMarshaller(processType).writeProcessInstance(context, processInstance);
        }
        stream.writeShort(1);
    }

    public void writeProcessTimers(MarshallerWriteContext context) throws IOException {
        MarshallerWriteContext stream = context.stream;
        TimerManager timerManager = ((InternalProcessRuntime)context.wm.getProcessRuntime()).getTimerManager();
        long timerId = timerManager.internalGetTimerId();
        stream.writeLong(timerId);
        ArrayList<TimerInstance> timers = new ArrayList<TimerInstance>(timerManager.getTimers());
        Collections.sort(timers, new Comparator<TimerInstance>(){

            @Override
            public int compare(TimerInstance o1, TimerInstance o2) {
                return (int)(o2.getId() - o1.getId());
            }
        });
        for (TimerInstance timer : timers) {
            stream.writeShort(29);
            this.writeTimer(context, timer);
        }
        stream.writeShort(1);
    }

    public void writeTimer(MarshallerWriteContext context, TimerInstance timer) throws IOException {
        MarshallerWriteContext stream = context.stream;
        stream.writeLong(timer.getId());
        stream.writeLong(timer.getTimerId());
        stream.writeLong(timer.getDelay());
        stream.writeLong(timer.getPeriod());
        stream.writeLong(timer.getProcessInstanceId());
        stream.writeLong(timer.getActivated().getTime());
        Date lastTriggered = timer.getLastTriggered();
        if (lastTriggered != null) {
            stream.writeBoolean(true);
            stream.writeLong(timer.getLastTriggered().getTime());
        } else {
            stream.writeBoolean(false);
        }
    }

    public void writeWorkItems(MarshallerWriteContext context) throws IOException {
        MarshallerWriteContext stream = context.stream;
        ArrayList workItems = new ArrayList(((WorkItemManager)context.wm.getWorkItemManager()).getWorkItems());
        Collections.sort(workItems, new Comparator<org.drools.runtime.process.WorkItem>(){

            @Override
            public int compare(org.drools.runtime.process.WorkItem o1, org.drools.runtime.process.WorkItem o2) {
                return (int)(o2.getId() - o1.getId());
            }
        });
        for (org.drools.runtime.process.WorkItem workItem : workItems) {
            stream.writeShort(19);
            ProcessMarshallerImpl.writeWorkItem(context, workItem);
        }
        stream.writeShort(1);
    }

    public static void writeWorkItem(MarshallerWriteContext context, org.drools.runtime.process.WorkItem workItem) throws IOException {
        ProcessMarshallerImpl.writeWorkItem(context, workItem, true);
    }

    public static void writeWorkItem(MarshallerWriteContext context, org.drools.runtime.process.WorkItem workItem, boolean includeVariables) throws IOException {
        MarshallerWriteContext stream = context.stream;
        stream.writeLong(workItem.getId());
        stream.writeLong(workItem.getProcessInstanceId());
        stream.writeUTF(workItem.getName());
        stream.writeInt(workItem.getState());
        if (includeVariables) {
            Map parameters = workItem.getParameters();
            stream.writeInt(parameters.size());
            for (Map.Entry entry : parameters.entrySet()) {
                stream.writeUTF((String)entry.getKey());
                stream.writeObject(entry.getValue());
            }
        }
    }

    public void readProcessInstances(MarshallerReaderContext context) throws IOException {
        MarshallerReaderContext stream = context.stream;
        while (stream.readShort() == 17) {
            String processType = stream.readUTF();
            ProcessMarshallerRegistry.INSTANCE.getMarshaller(processType).readProcessInstance(context);
        }
    }

    public void readWorkItems(MarshallerReaderContext context) throws IOException {
        InternalWorkingMemory wm = context.wm;
        MarshallerReaderContext stream = context.stream;
        while (stream.readShort() == 19) {
            org.drools.runtime.process.WorkItem workItem = ProcessMarshallerImpl.readWorkItem(context);
            ((WorkItemManager)wm.getWorkItemManager()).internalAddWorkItem((WorkItem)workItem);
        }
    }

    public static org.drools.runtime.process.WorkItem readWorkItem(MarshallerReaderContext context) throws IOException {
        return ProcessMarshallerImpl.readWorkItem(context, true);
    }

    public static org.drools.runtime.process.WorkItem readWorkItem(MarshallerReaderContext context, boolean includeVariables) throws IOException {
        MarshallerReaderContext stream = context.stream;
        WorkItemImpl workItem = new WorkItemImpl();
        workItem.setId(stream.readLong());
        workItem.setProcessInstanceId(stream.readLong());
        workItem.setName(stream.readUTF());
        workItem.setState(stream.readInt());
        if (includeVariables) {
            int nbParameters = stream.readInt();
            for (int i = 0; i < nbParameters; ++i) {
                String name = stream.readUTF();
                try {
                    Object value = stream.readObject();
                    workItem.setParameter(name, value);
                    continue;
                }
                catch (ClassNotFoundException e) {
                    throw new IllegalArgumentException("Could not reload parameter " + name);
                }
            }
        }
        return workItem;
    }

    public void readProcessTimers(MarshallerReaderContext context) throws IOException {
        MarshallerReaderContext stream = context.stream;
        TimerManager timerManager = ((InternalProcessRuntime)context.wm.getProcessRuntime()).getTimerManager();
        timerManager.internalSetTimerId(stream.readLong());
        while (stream.readShort() == 29) {
            TimerInstance timer = this.readTimer(context);
            timerManager.internalAddTimer(timer);
        }
    }

    public TimerInstance readTimer(MarshallerReaderContext context) throws IOException {
        MarshallerReaderContext stream = context.stream;
        TimerInstance timer = new TimerInstance();
        timer.setId(stream.readLong());
        timer.setTimerId(stream.readLong());
        timer.setDelay(stream.readLong());
        timer.setPeriod(stream.readLong());
        timer.setProcessInstanceId(stream.readLong());
        timer.setActivated(new Date(stream.readLong()));
        if (stream.readBoolean()) {
            timer.setLastTriggered(new Date(stream.readLong()));
        }
        return timer;
    }
}

