/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.server.netty;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import org.jboss.resteasy.core.SynchronousDispatcher;
import org.jboss.resteasy.core.SynchronousExecutionContext;
import org.jboss.resteasy.plugins.providers.FormUrlEncodedProvider;
import org.jboss.resteasy.plugins.server.netty.NettyHttpResponse;
import org.jboss.resteasy.specimpl.ResteasyHttpHeaders;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.spi.HttpResponse;
import org.jboss.resteasy.spi.NotImplementedYetException;
import org.jboss.resteasy.spi.ResteasyAsynchronousContext;
import org.jboss.resteasy.spi.ResteasyUriInfo;
import org.jboss.resteasy.util.Encode;

public class NettyHttpRequest
implements HttpRequest {
    protected ResteasyHttpHeaders httpHeaders;
    protected SynchronousDispatcher dispatcher;
    protected ResteasyUriInfo uriInfo;
    protected String httpMethod;
    protected MultivaluedMap<String, String> formParameters;
    protected MultivaluedMap<String, String> decodedFormParameters;
    protected InputStream inputStream;
    protected Map<String, Object> attributes = new HashMap<String, Object>();
    protected NettyHttpResponse httpResponse;
    private final boolean is100ContinueExpected;

    public NettyHttpRequest(ResteasyHttpHeaders httpHeaders, ResteasyUriInfo uri, String httpMethod, SynchronousDispatcher dispatcher, NettyHttpResponse httpResponse, boolean is100ContinueExpected) {
        this.is100ContinueExpected = is100ContinueExpected;
        this.httpResponse = httpResponse;
        this.dispatcher = dispatcher;
        this.httpHeaders = httpHeaders;
        this.httpMethod = httpMethod;
        this.uriInfo = uri;
    }

    public MultivaluedMap<String, String> getMutableHeaders() {
        return this.httpHeaders.getMutableHeaders();
    }

    public void setHttpMethod(String method) {
        this.httpMethod = method;
    }

    public Enumeration<String> getAttributeNames() {
        Enumeration<String> en = new Enumeration<String>(){
            private Iterator<String> it;
            {
                this.it = NettyHttpRequest.this.attributes.keySet().iterator();
            }

            @Override
            public boolean hasMoreElements() {
                return this.it.hasNext();
            }

            @Override
            public String nextElement() {
                return this.it.next();
            }
        };
        return en;
    }

    public ResteasyAsynchronousContext getAsyncContext() {
        return new SynchronousExecutionContext(this.dispatcher, (HttpRequest)this, (HttpResponse)this.httpResponse);
    }

    public MultivaluedMap<String, String> getFormParameters() {
        if (this.formParameters != null) {
            return this.formParameters;
        }
        if (this.getHttpHeaders().getMediaType().isCompatible(MediaType.valueOf((String)"application/x-www-form-urlencoded"))) {
            try {
                this.formParameters = FormUrlEncodedProvider.parseForm((InputStream)this.getInputStream());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        } else {
            throw new IllegalArgumentException("Request media type is not application/x-www-form-urlencoded");
        }
        return this.formParameters;
    }

    public MultivaluedMap<String, String> getDecodedFormParameters() {
        if (this.decodedFormParameters != null) {
            return this.decodedFormParameters;
        }
        this.decodedFormParameters = Encode.decode(this.getFormParameters());
        return this.decodedFormParameters;
    }

    public Object getAttribute(String attribute) {
        return this.attributes.get(attribute);
    }

    public void setAttribute(String name, Object value) {
        this.attributes.put(name, value);
    }

    public void removeAttribute(String name) {
        this.attributes.remove(name);
    }

    public HttpHeaders getHttpHeaders() {
        return this.httpHeaders;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public void setInputStream(InputStream stream) {
        this.inputStream = stream;
    }

    public ResteasyUriInfo getUri() {
        return this.uriInfo;
    }

    public String getHttpMethod() {
        return this.httpMethod;
    }

    public void setRequestUri(URI requestUri) throws IllegalStateException {
        this.uriInfo = this.uriInfo.setRequestUri(requestUri);
    }

    public void setRequestUri(URI baseUri, URI requestUri) throws IllegalStateException {
        this.uriInfo = new ResteasyUriInfo(baseUri.resolve(requestUri));
    }

    public boolean isInitial() {
        return true;
    }

    public NettyHttpResponse getResponse() {
        return this.httpResponse;
    }

    public boolean isKeepAlive() {
        return this.httpResponse.isKeepAlive();
    }

    public boolean is100ContinueExpected() {
        return this.is100ContinueExpected;
    }

    public void forward(String path) {
        throw new NotImplementedYetException();
    }

    public boolean wasForwarded() {
        return false;
    }
}

