/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.ide.completion;

import java.util.Arrays;
import java.util.List;
import org.hibernate.cfg.Configuration;
import org.hibernate.tool.ide.completion.CompletionHelper;
import org.hibernate.tool.ide.completion.ConfigurationCompletion;
import org.hibernate.tool.ide.completion.EntityNameReference;
import org.hibernate.tool.ide.completion.HQLAnalyzer;
import org.hibernate.tool.ide.completion.HQLCompletionProposal;
import org.hibernate.tool.ide.completion.IHQLCodeAssist;
import org.hibernate.tool.ide.completion.IHQLCompletionRequestor;
import org.hibernate.tool.ide.completion.SimpleLexerException;

public class HQLCodeAssist
implements IHQLCodeAssist {
    private Configuration configuration;
    private ConfigurationCompletion completion;
    private static final char[] charSeparators = new char[]{',', '(', ')'};

    public HQLCodeAssist(Configuration configuration) {
        this.configuration = configuration;
        this.completion = new ConfigurationCompletion(configuration);
    }

    public void codeComplete(String query, int position, IHQLCompletionRequestor collector) {
        int prefixStart = HQLCodeAssist.findNearestWhiteSpace(query, position);
        String prefix = query.substring(prefixStart, position);
        try {
            boolean showEntityNames = new HQLAnalyzer().shouldShowEntityNames(query, position);
            if (showEntityNames) {
                if (this.hasConfiguration()) {
                    this.completion.getMatchingImports(prefix, position, collector);
                } else {
                    collector.completionFailure("Configuration not available nor open");
                }
            } else {
                List visible = new HQLAnalyzer().getVisibleEntityNames(query.toCharArray(), position);
                int dotIndex = prefix.lastIndexOf(".");
                if (dotIndex == -1) {
                    for (EntityNameReference qt : visible) {
                        String alias = qt.getAlias();
                        if (!alias.startsWith(prefix)) continue;
                        HQLCompletionProposal completionProposal = new HQLCompletionProposal(5, position);
                        completionProposal.setCompletion(alias.substring(prefix.length()));
                        completionProposal.setReplaceStart(position);
                        completionProposal.setReplaceEnd(position + 0);
                        completionProposal.setSimpleName(alias);
                        completionProposal.setShortEntityName(qt.getEntityName());
                        if (this.hasConfiguration()) {
                            String importedName = (String)this.getConfiguration().getImports().get(qt.getEntityName());
                            completionProposal.setEntityName(importedName);
                        }
                        collector.accept(completionProposal);
                    }
                } else if (this.hasConfiguration()) {
                    String path = CompletionHelper.getCanonicalPath(visible, prefix.substring(0, dotIndex));
                    String propertyPrefix = prefix.substring(dotIndex + 1);
                    this.completion.getMatchingProperties(path, propertyPrefix, position, collector);
                } else {
                    collector.completionFailure("Configuration not available nor open");
                }
                this.completion.getMatchingFunctions(prefix, position, collector);
                this.completion.getMatchingKeywords(prefix, position, collector);
            }
        }
        catch (SimpleLexerException sle) {
            collector.completionFailure("Syntax error: " + sle.getMessage());
        }
    }

    private boolean hasConfiguration() {
        return this.configuration != null;
    }

    private Configuration getConfiguration() {
        return this.configuration;
    }

    public static int findNearestWhiteSpace(CharSequence doc, int start) {
        boolean loop = true;
        int offset = 0;
        int tmpOffset = start - 1;
        while (loop && tmpOffset >= 0) {
            char c = doc.charAt(tmpOffset);
            if (HQLCodeAssist.isWhitespace(c)) {
                loop = false;
                continue;
            }
            --tmpOffset;
        }
        offset = tmpOffset + 1;
        return offset;
    }

    private static boolean isWhitespace(char c) {
        return Arrays.binarySearch(charSeparators, c) >= 0 || Character.isWhitespace(c);
    }

    static {
        Arrays.sort(charSeparators);
    }
}

