/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.spatial;

import java.util.Map;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexableField;
import org.hibernate.search.bridge.LuceneOptions;
import org.hibernate.search.bridge.ParameterizedBridge;
import org.hibernate.search.bridge.spi.FieldMetadataBuilder;
import org.hibernate.search.bridge.spi.FieldType;
import org.hibernate.search.spatial.SpatialFieldBridge;
import org.hibernate.search.spatial.impl.Point;
import org.hibernate.search.spatial.impl.SpatialHelper;
import org.hibernate.search.spatial.impl.SpatialNumericDocValueField;

public class SpatialFieldBridgeByHash
extends SpatialFieldBridge
implements ParameterizedBridge {
    public static final int DEFAULT_TOP_SPATIAL_HASH_LEVEL = 0;
    public static final int DEFAULT_BOTTOM_SPATIAL_HASH_LEVEL = 16;
    private int topSpatialHashLevel = 0;
    private int bottomSpatialHashLevel = 16;
    private String[] hashIndexedFieldNames;

    public SpatialFieldBridgeByHash() {
    }

    public SpatialFieldBridgeByHash(int topSpatialHashLevel, int bottomSpatialHashLevel) {
        this.topSpatialHashLevel = topSpatialHashLevel;
        this.bottomSpatialHashLevel = bottomSpatialHashLevel;
    }

    public SpatialFieldBridgeByHash(int topSpatialHashLevel, int bottomSpatialHashLevel, String latitudeField, String longitudeField) {
        this.topSpatialHashLevel = topSpatialHashLevel;
        this.bottomSpatialHashLevel = bottomSpatialHashLevel;
        this.latitudeField = latitudeField;
        this.longitudeField = longitudeField;
    }

    @Override
    public void configureFieldMetadata(String name, FieldMetadataBuilder builder) {
        super.configureFieldMetadata(name, builder);
        this.hashIndexedFieldNames = new String[this.bottomSpatialHashLevel + 1];
        for (int i = this.topSpatialHashLevel; i <= this.bottomSpatialHashLevel; ++i) {
            String fieldName;
            this.hashIndexedFieldNames[i] = fieldName = SpatialHelper.formatFieldName(i, name);
            builder.field(fieldName, FieldType.STRING);
        }
        builder.field(this.latitudeIndexedFieldName, FieldType.DOUBLE);
        builder.field(this.longitudeIndexedFieldName, FieldType.DOUBLE);
    }

    @Override
    public void set(String name, Object value, Document document, LuceneOptions luceneOptions) {
        if (value != null) {
            Double latitude = this.getLatitude(value);
            Double longitude = this.getLongitude(value);
            if (latitude != null && longitude != null) {
                Point point = Point.fromDegrees(latitude, longitude);
                for (int i = this.topSpatialHashLevel; i <= this.bottomSpatialHashLevel; ++i) {
                    luceneOptions.addFieldToDocument(this.hashIndexedFieldNames[i], SpatialHelper.getSpatialHashCellId(point, i), document);
                }
                luceneOptions.addNumericFieldToDocument(this.latitudeIndexedFieldName, latitude, document);
                luceneOptions.addNumericFieldToDocument(this.longitudeIndexedFieldName, longitude, document);
                SpatialNumericDocValueField latitudeDocValuesField = new SpatialNumericDocValueField(this.latitudeIndexedFieldName, latitude);
                document.add((IndexableField)latitudeDocValuesField);
                SpatialNumericDocValueField longitudeDocValuesField = new SpatialNumericDocValueField(this.longitudeIndexedFieldName, longitude);
                document.add((IndexableField)longitudeDocValuesField);
            }
        }
    }

    public void setParameterValues(Map parameters) {
        Object bottomSpatialHashLevel;
        Object topSpatialHashLevel = parameters.get("topSpatialHashLevel");
        if (topSpatialHashLevel instanceof Integer) {
            this.topSpatialHashLevel = (Integer)topSpatialHashLevel;
        }
        if ((bottomSpatialHashLevel = parameters.get("bottomSpatialHashLevel")) instanceof Integer) {
            this.bottomSpatialHashLevel = (Integer)bottomSpatialHashLevel;
        }
    }
}

