/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.impl.lucene;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.LockSupport;
import org.hibernate.search.backend.IndexingMonitor;
import org.hibernate.search.backend.LuceneWork;
import org.hibernate.search.backend.impl.lucene.Changeset;
import org.hibernate.search.backend.impl.lucene.ChangesetList;
import org.hibernate.search.backend.impl.lucene.LuceneBackendQueueTask;
import org.hibernate.search.backend.impl.lucene.LuceneBackendResources;
import org.hibernate.search.backend.impl.lucene.MultiWriteDrainableLinkedList;
import org.hibernate.search.backend.impl.lucene.WorkProcessor;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

final class SyncWorkProcessor
implements WorkProcessor {
    private static final Log log = LoggerFactory.make();
    private final MultiWriteDrainableLinkedList<Changeset> transferQueue = new MultiWriteDrainableLinkedList();
    private volatile LuceneBackendResources resources;
    private final CountDownLatch shutdownLatch = new CountDownLatch(1);
    private final String indexName;
    private volatile boolean stop = false;
    final Thread consumerThread;

    public SyncWorkProcessor(LuceneBackendResources resources, String indexName) {
        this.resources = resources;
        this.indexName = indexName;
        this.consumerThread = new Thread((Runnable)new Consumer(), "Hibernate Search sync consumer thread for index " + indexName);
        this.consumerThread.setDaemon(true);
    }

    public void start() {
        log.startingSyncConsumerThread(this.indexName);
        this.consumerThread.start();
    }

    @Override
    public void submit(List<LuceneWork> workList, IndexingMonitor monitor) {
        if (workList.isEmpty()) {
            if (log.isTraceEnabled()) {
                StringWriter stackTraceStringWriter = new StringWriter();
                PrintWriter stackTracePrintWriter = new PrintWriter(stackTraceStringWriter);
                new Throwable().printStackTrace(stackTracePrintWriter);
                log.workListShouldNeverBeEmpty(stackTraceStringWriter.toString());
            }
            return;
        }
        Changeset changeset = new Changeset(workList, Thread.currentThread(), monitor);
        this.transferQueue.add(changeset);
        this.wakeUpConsumer();
        boolean interrupted = false;
        while (!changeset.isProcessed() && !interrupted) {
            this.parkCurrentThread();
            if (!Thread.interrupted()) continue;
            interrupted = true;
        }
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
    }

    private void wakeUpConsumer() {
        LockSupport.unpark(this.consumerThread);
    }

    @Override
    public void shutdown() {
        this.stop = true;
        LockSupport.unpark(this.consumerThread);
        try {
            this.shutdownLatch.await(Long.MAX_VALUE, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            log.timedOutWaitingShutdown(this.indexName);
        }
    }

    @Override
    public void updateResources(LuceneBackendResources resources) {
        this.resources = resources;
    }

    private void parkCurrentThread() {
        LockSupport.parkNanos(1000000000L);
    }

    private class Consumer
    implements Runnable {
        private Consumer() {
        }

        @Override
        public void run() {
            try {
                while (!SyncWorkProcessor.this.stop) {
                    Iterable<Changeset> changesets = SyncWorkProcessor.this.transferQueue.drainToDetachedIterable();
                    while (changesets == null && !SyncWorkProcessor.this.stop) {
                        SyncWorkProcessor.this.parkCurrentThread();
                        changesets = SyncWorkProcessor.this.transferQueue.drainToDetachedIterable();
                    }
                    if (changesets == null) continue;
                    this.applyChangesets(changesets);
                }
                log.stoppingSyncConsumerThread(SyncWorkProcessor.this.indexName);
            }
            finally {
                SyncWorkProcessor.this.shutdownLatch.countDown();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void applyChangesets(Iterable<Changeset> changesets) {
            ChangesetList changesetList = new ChangesetList(changesets);
            try {
                LuceneBackendQueueTask luceneBackendQueueTask = new LuceneBackendQueueTask(changesetList, SyncWorkProcessor.this.resources, null);
                luceneBackendQueueTask.run();
            }
            finally {
                changesetList.markProcessed();
            }
        }
    }
}

