/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.idm.engine.test;

import java.util.List;
import org.flowable.engine.common.api.FlowableException;
import org.flowable.idm.api.Group;
import org.flowable.idm.api.User;
import org.flowable.idm.engine.IdmEngine;
import org.flowable.idm.engine.IdmEngines;
import org.flowable.idm.engine.test.AbstractFlowableIdmTestCase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PluggableFlowableIdmTestCase
extends AbstractFlowableIdmTestCase {
    private static final Logger pluggabledImTestCaseLogger = LoggerFactory.getLogger(PluggableFlowableIdmTestCase.class);
    protected static IdmEngine cachedIdmEngine;

    @Override
    protected void initializeIdmEngine() {
        if (cachedIdmEngine == null) {
            pluggabledImTestCaseLogger.info("No cached idm engine found for test. Retrieving the default engine.");
            IdmEngines.destroy();
            cachedIdmEngine = IdmEngines.getDefaultIdmEngine();
            if (cachedIdmEngine == null) {
                throw new FlowableException("no default idm engine available");
            }
        }
        this.idmEngine = cachedIdmEngine;
        this.idmEngineConfiguration = this.idmEngine.getIdmEngineConfiguration();
    }

    protected Group createGroup(String id, String name, String type) {
        Group group = this.idmIdentityService.newGroup(id);
        group.setName(name);
        group.setType(type);
        this.idmIdentityService.saveGroup(group);
        return group;
    }

    protected void clearAllUsersAndGroups() {
        List privileges = this.idmIdentityService.createPrivilegeQuery().list();
        for (Object privilege : privileges) {
            this.idmIdentityService.deletePrivilege(privilege.getId());
        }
        List groups = this.idmIdentityService.createGroupQuery().list();
        for (Group group : groups) {
            List members = this.idmIdentityService.createUserQuery().memberOfGroup(group.getId()).list();
            for (User member : members) {
                this.idmIdentityService.deleteMembership(member.getId(), group.getId());
            }
            this.idmIdentityService.deleteGroup(group.getId());
        }
        List users = this.idmIdentityService.createUserQuery().list();
        for (User user : users) {
            this.idmIdentityService.deleteUser(user.getId());
        }
    }
}

