/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.idm.engine.impl.db;

import org.flowable.engine.common.api.FlowableException;
import org.flowable.engine.common.api.FlowableWrongDbException;
import org.flowable.engine.common.impl.db.ServiceSqlScriptBasedDbSchemaManager;
import org.flowable.idm.engine.impl.util.CommandContextUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IdmDbSchemaManager
extends ServiceSqlScriptBasedDbSchemaManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(IdmDbSchemaManager.class);
    private static final String IDM_PROPERTY_TABLE = "ACT_ID_PROPERTY";
    private static final String VERSION_PROPERTY = "schema.version";
    private static final String SCHEMA_COMPONENT = "identity";

    public IdmDbSchemaManager() {
        super(IDM_PROPERTY_TABLE, SCHEMA_COMPONENT, null, VERSION_PROPERTY);
    }

    protected String getResourcesRootDirectory() {
        return "org/flowable/idm/db/";
    }

    protected String getPropertyTable() {
        return IDM_PROPERTY_TABLE;
    }

    protected String getUpgradeStartVersion() {
        return "5.99.0.0";
    }

    protected void internalDbSchemaCreate() {
        if (this.isIdmGroupTablePresent()) {
            this.dbSchemaUpdate();
        } else {
            super.internalDbSchemaCreate();
        }
    }

    protected boolean isUpdateNeeded() {
        boolean propertyTablePresent = this.isTablePresent(IDM_PROPERTY_TABLE);
        if (!propertyTablePresent) {
            return this.isIdmGroupTablePresent();
        }
        return true;
    }

    public boolean isIdmGroupTablePresent() {
        return this.isTablePresent("ACT_ID_GROUP");
    }

    public void dbSchemaCheckVersion() {
        try {
            String dbVersion = this.getSchemaVersion();
            if (!"6.2.1.0".equals(dbVersion)) {
                throw new FlowableWrongDbException("6.2.1.0", dbVersion);
            }
            String errorMessage = null;
            if (!this.isTablePresent(IDM_PROPERTY_TABLE)) {
                errorMessage = this.addMissingComponent(errorMessage, "engine");
            }
            if (errorMessage != null) {
                throw new FlowableException("Flowable IDM database problem: " + errorMessage);
            }
        }
        catch (Exception e) {
            if (this.isMissingTablesException(e)) {
                throw new FlowableException("no flowable tables in db. set <property name=\"databaseSchemaUpdate\" to value=\"true\" or value=\"create-drop\" (use create-drop for testing only!) in bean processEngineConfiguration in flowable.cfg.xml for automatic schema creation", (Throwable)e);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new FlowableException("couldn't get db schema version", (Throwable)e);
        }
        LOGGER.debug("flowable idm db schema check successful");
    }

    protected String addMissingComponent(String missingComponents, String component) {
        if (missingComponents == null) {
            return "Tables missing for component(s) " + component;
        }
        return missingComponents + ", " + component;
    }

    protected boolean isMissingTablesException(Exception e) {
        String exceptionMessage = e.getMessage();
        if (e.getMessage() != null) {
            if (exceptionMessage.indexOf("Table") != -1 && exceptionMessage.indexOf("not found") != -1) {
                return true;
            }
            if ((exceptionMessage.indexOf("Table") != -1 || exceptionMessage.indexOf("table") != -1) && exceptionMessage.indexOf("doesn't exist") != -1) {
                return true;
            }
            if ((exceptionMessage.indexOf("relation") != -1 || exceptionMessage.indexOf("table") != -1) && exceptionMessage.indexOf("does not exist") != -1) {
                return true;
            }
        }
        return false;
    }

    public void performSchemaOperationsIdmEngineBuild() {
        String databaseSchemaUpdate = CommandContextUtil.getIdmEngineConfiguration().getDatabaseSchemaUpdate();
        if ("drop-create".equals(databaseSchemaUpdate)) {
            try {
                this.dbSchemaDrop();
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
        if ("create-drop".equals(databaseSchemaUpdate) || "drop-create".equals(databaseSchemaUpdate) || "create".equals(databaseSchemaUpdate)) {
            this.dbSchemaCreate();
        } else if ("false".equals(databaseSchemaUpdate)) {
            this.dbSchemaCheckVersion();
        } else if ("true".equals(databaseSchemaUpdate)) {
            this.dbSchemaUpdate();
        }
    }
}

