/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.idm.engine.impl.interceptor;

import org.flowable.engine.common.impl.interceptor.CommandConfig;
import org.flowable.idm.engine.IdmEngineConfiguration;
import org.flowable.idm.engine.impl.context.Context;
import org.flowable.idm.engine.impl.interceptor.AbstractCommandInterceptor;
import org.flowable.idm.engine.impl.interceptor.Command;
import org.flowable.idm.engine.impl.interceptor.CommandContext;
import org.flowable.idm.engine.impl.interceptor.CommandContextFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommandContextInterceptor
extends AbstractCommandInterceptor {
    private static final Logger log = LoggerFactory.getLogger(CommandContextInterceptor.class);
    protected CommandContextFactory commandContextFactory;
    protected IdmEngineConfiguration idmEngineConfiguration;

    public CommandContextInterceptor() {
    }

    public CommandContextInterceptor(CommandContextFactory commandContextFactory, IdmEngineConfiguration idmEngineConfiguration) {
        this.commandContextFactory = commandContextFactory;
        this.idmEngineConfiguration = idmEngineConfiguration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T execute(CommandConfig config, Command<T> command) {
        CommandContext context = Context.getCommandContext();
        boolean contextReused = false;
        if (!config.isContextReusePossible() || context == null || context.getException() != null) {
            context = this.commandContextFactory.createCommandContext(command);
        } else {
            log.debug("Valid context found. Reusing it for the current command '{}'", (Object)command.getClass().getCanonicalName());
            contextReused = true;
            context.setReused(true);
        }
        try {
            Context.setCommandContext(context);
            Context.setIdmEngineConfiguration(this.idmEngineConfiguration);
            T t = this.next.execute(config, command);
            return t;
        }
        catch (Exception e) {
            context.exception(e);
        }
        finally {
            try {
                if (!contextReused) {
                    context.close();
                }
            }
            finally {
                Context.removeCommandContext();
                Context.removeIdmEngineConfiguration();
            }
        }
        return null;
    }

    public CommandContextFactory getCommandContextFactory() {
        return this.commandContextFactory;
    }

    public void setCommandContextFactory(CommandContextFactory commandContextFactory) {
        this.commandContextFactory = commandContextFactory;
    }

    public IdmEngineConfiguration getIdmEngineConfiguration() {
        return this.idmEngineConfiguration;
    }

    public void setIdmEngineConfiguration(IdmEngineConfiguration idmEngineConfiguration) {
        this.idmEngineConfiguration = idmEngineConfiguration;
    }
}

