/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.idm.engine.impl.context;

import java.util.Stack;
import org.flowable.engine.common.impl.cfg.BaseTransactionContext;
import org.flowable.engine.common.impl.transaction.TransactionContextHolder;
import org.flowable.idm.engine.IdmEngineConfiguration;
import org.flowable.idm.engine.impl.cfg.TransactionContext;
import org.flowable.idm.engine.impl.interceptor.CommandContext;

public class Context {
    protected static ThreadLocal<Stack<CommandContext>> commandContextThreadLocal = new ThreadLocal();
    protected static ThreadLocal<Stack<IdmEngineConfiguration>> idmEngineConfigurationStackThreadLocal = new ThreadLocal();

    public static CommandContext getCommandContext() {
        Stack stack = Context.getStack(commandContextThreadLocal);
        if (stack.isEmpty()) {
            return null;
        }
        return (CommandContext)((Object)stack.peek());
    }

    public static void setCommandContext(CommandContext commandContext) {
        Context.getStack(commandContextThreadLocal).push((Object)((Object)commandContext));
    }

    public static void removeCommandContext() {
        Context.getStack(commandContextThreadLocal).pop();
    }

    public static IdmEngineConfiguration getIdmEngineConfiguration() {
        Stack stack = Context.getStack(idmEngineConfigurationStackThreadLocal);
        if (stack.isEmpty()) {
            return null;
        }
        return (IdmEngineConfiguration)((Object)stack.peek());
    }

    public static void setIdmEngineConfiguration(IdmEngineConfiguration idmEngineConfiguration) {
        Context.getStack(idmEngineConfigurationStackThreadLocal).push((Object)((Object)idmEngineConfiguration));
    }

    public static void removeIdmEngineConfiguration() {
        Context.getStack(idmEngineConfigurationStackThreadLocal).pop();
    }

    public static TransactionContext getTransactionContext() {
        return (TransactionContext)TransactionContextHolder.getTransactionContext();
    }

    public static void setTransactionContext(TransactionContext transactionContext) {
        TransactionContextHolder.setTransactionContext((BaseTransactionContext)transactionContext);
    }

    public static void removeTransactionContext() {
        TransactionContextHolder.removeTransactionContext();
    }

    protected static <T> Stack<T> getStack(ThreadLocal<Stack<T>> threadLocal) {
        Stack<Object> stack = threadLocal.get();
        if (stack == null) {
            stack = new Stack();
            threadLocal.set(stack);
        }
        return stack;
    }
}

