/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.idm.engine.impl.cmd;

import java.io.Serializable;
import org.flowable.engine.common.api.FlowableIllegalArgumentException;
import org.flowable.engine.common.api.FlowableObjectNotFoundException;
import org.flowable.idm.api.Picture;
import org.flowable.idm.api.User;
import org.flowable.idm.engine.impl.interceptor.Command;
import org.flowable.idm.engine.impl.interceptor.CommandContext;

public class SetUserPictureCmd
implements Command<Object>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String userId;
    protected Picture picture;

    public SetUserPictureCmd(String userId, Picture picture) {
        this.userId = userId;
        this.picture = picture;
    }

    @Override
    public Object execute(CommandContext commandContext) {
        if (this.userId == null) {
            throw new FlowableIllegalArgumentException("userId is null");
        }
        User user = (User)commandContext.getIdmEngineConfiguration().getIdmIdentityService().createUserQuery().userId(this.userId).singleResult();
        if (user == null) {
            throw new FlowableObjectNotFoundException("user " + this.userId + " doesn't exist", User.class);
        }
        commandContext.getUserEntityManager().setUserPicture(user, this.picture);
        return null;
    }
}

