/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.idm.engine.impl.cmd;

import java.io.Serializable;
import org.flowable.engine.common.api.FlowableIllegalArgumentException;
import org.flowable.idm.api.Privilege;
import org.flowable.idm.engine.impl.interceptor.Command;
import org.flowable.idm.engine.impl.interceptor.CommandContext;
import org.flowable.idm.engine.impl.persistence.entity.PrivilegeEntity;

public class CreatePrivilegeCmd
implements Command<Privilege>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String name;

    public CreatePrivilegeCmd(String name) {
        if (name == null) {
            throw new FlowableIllegalArgumentException("Privilege name is null");
        }
        this.name = name;
    }

    @Override
    public Privilege execute(CommandContext commandContext) {
        long count = commandContext.getPrivilegeEntityManager().createNewPrivilegeQuery().privilegeName(this.name).count();
        if (count > 0L) {
            throw new FlowableIllegalArgumentException("Provided privilege name already exists");
        }
        PrivilegeEntity entity = (PrivilegeEntity)commandContext.getPrivilegeEntityManager().create();
        entity.setName(this.name);
        commandContext.getPrivilegeEntityManager().insert(entity);
        return entity;
    }
}

