/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.persistence.entity.data.impl;

import java.util.HashMap;
import java.util.List;
import org.flowable.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.flowable.engine.impl.persistence.entity.CommentEntity;
import org.flowable.engine.impl.persistence.entity.CommentEntityImpl;
import org.flowable.engine.impl.persistence.entity.data.AbstractDataManager;
import org.flowable.engine.impl.persistence.entity.data.CommentDataManager;
import org.flowable.engine.task.Comment;
import org.flowable.engine.task.Event;

public class MybatisCommentDataManager
extends AbstractDataManager<CommentEntity>
implements CommentDataManager {
    public MybatisCommentDataManager(ProcessEngineConfigurationImpl processEngineConfiguration) {
        super(processEngineConfiguration);
    }

    @Override
    public Class<? extends CommentEntity> getManagedEntityClass() {
        return CommentEntityImpl.class;
    }

    public CommentEntity create() {
        return new CommentEntityImpl();
    }

    @Override
    public List<Comment> findCommentsByTaskId(String taskId) {
        return this.getDbSqlSession().selectList("selectCommentsByTaskId", taskId);
    }

    @Override
    public List<Comment> findCommentsByTaskIdAndType(String taskId, String type) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("taskId", taskId);
        params.put("type", type);
        return this.getDbSqlSession().selectListWithRawParameter("selectCommentsByTaskIdAndType", params);
    }

    @Override
    public List<Comment> findCommentsByType(String type) {
        return this.getDbSqlSession().selectList("selectCommentsByType", type);
    }

    @Override
    public List<Event> findEventsByTaskId(String taskId) {
        return this.getDbSqlSession().selectList("selectEventsByTaskId", taskId);
    }

    @Override
    public List<Event> findEventsByProcessInstanceId(String processInstanceId) {
        return this.getDbSqlSession().selectList("selectEventsByProcessInstanceId", processInstanceId);
    }

    @Override
    public void deleteCommentsByTaskId(String taskId) {
        this.getDbSqlSession().delete("deleteCommentsByTaskId", taskId, CommentEntityImpl.class);
    }

    @Override
    public void deleteCommentsByProcessInstanceId(String processInstanceId) {
        this.getDbSqlSession().delete("deleteCommentsByProcessInstanceId", processInstanceId, CommentEntityImpl.class);
    }

    @Override
    public List<Comment> findCommentsByProcessInstanceId(String processInstanceId) {
        return this.getDbSqlSession().selectList("selectCommentsByProcessInstanceId", processInstanceId);
    }

    @Override
    public List<Comment> findCommentsByProcessInstanceId(String processInstanceId, String type) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("processInstanceId", processInstanceId);
        params.put("type", type);
        return this.getDbSqlSession().selectListWithRawParameter("selectCommentsByProcessInstanceIdAndType", params);
    }

    @Override
    public Comment findComment(String commentId) {
        return (Comment)this.findById(commentId);
    }

    @Override
    public Event findEvent(String commentId) {
        return (Event)this.findById(commentId);
    }
}

