/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.persistence.entity;

import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.flowable.engine.common.api.delegate.event.FlowableEvent;
import org.flowable.engine.common.impl.Page;
import org.flowable.engine.delegate.VariableScope;
import org.flowable.engine.delegate.event.FlowableEngineEventType;
import org.flowable.engine.delegate.event.impl.FlowableEventBuilder;
import org.flowable.engine.impl.TimerJobQueryImpl;
import org.flowable.engine.impl.calendar.BusinessCalendar;
import org.flowable.engine.impl.calendar.CycleBusinessCalendar;
import org.flowable.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.flowable.engine.impl.context.Context;
import org.flowable.engine.impl.jobexecutor.TimerEventHandler;
import org.flowable.engine.impl.persistence.CountingExecutionEntity;
import org.flowable.engine.impl.persistence.entity.AbstractEntityManager;
import org.flowable.engine.impl.persistence.entity.ByteArrayRef;
import org.flowable.engine.impl.persistence.entity.ExecutionEntity;
import org.flowable.engine.impl.persistence.entity.JobEntity;
import org.flowable.engine.impl.persistence.entity.TimerJobEntity;
import org.flowable.engine.impl.persistence.entity.TimerJobEntityManager;
import org.flowable.engine.impl.persistence.entity.data.TimerJobDataManager;
import org.flowable.engine.runtime.Job;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimerJobEntityManagerImpl
extends AbstractEntityManager<TimerJobEntity>
implements TimerJobEntityManager {
    private static final Logger logger = LoggerFactory.getLogger(TimerJobEntityManagerImpl.class);
    protected TimerJobDataManager jobDataManager;

    public TimerJobEntityManagerImpl(ProcessEngineConfigurationImpl processEngineConfiguration, TimerJobDataManager jobDataManager) {
        super(processEngineConfiguration);
        this.jobDataManager = jobDataManager;
    }

    @Override
    public TimerJobEntity createAndCalculateNextTimer(JobEntity timerEntity, VariableScope variableScope) {
        int repeatValue = this.calculateRepeatValue(timerEntity);
        if (repeatValue != 0) {
            Date newTimer;
            if (repeatValue > 0) {
                this.setNewRepeat(timerEntity, repeatValue);
            }
            if ((newTimer = this.calculateNextTimer(timerEntity, variableScope)) != null && this.isValidTime(timerEntity, newTimer, variableScope)) {
                TimerJobEntity te = this.createTimer(timerEntity);
                te.setDuedate(newTimer);
                return te;
            }
        }
        return null;
    }

    @Override
    public List<TimerJobEntity> findTimerJobsToExecute(Page page) {
        return this.jobDataManager.findTimerJobsToExecute(page);
    }

    @Override
    public List<TimerJobEntity> findJobsByTypeAndProcessDefinitionId(String jobHandlerType, String processDefinitionId) {
        return this.jobDataManager.findJobsByTypeAndProcessDefinitionId(jobHandlerType, processDefinitionId);
    }

    @Override
    public List<TimerJobEntity> findJobsByTypeAndProcessDefinitionKeyNoTenantId(String jobHandlerType, String processDefinitionKey) {
        return this.jobDataManager.findJobsByTypeAndProcessDefinitionKeyNoTenantId(jobHandlerType, processDefinitionKey);
    }

    @Override
    public List<TimerJobEntity> findJobsByTypeAndProcessDefinitionKeyAndTenantId(String jobHandlerType, String processDefinitionKey, String tenantId) {
        return this.jobDataManager.findJobsByTypeAndProcessDefinitionKeyAndTenantId(jobHandlerType, processDefinitionKey, tenantId);
    }

    @Override
    public List<TimerJobEntity> findJobsByExecutionId(String id) {
        return this.jobDataManager.findJobsByExecutionId(id);
    }

    @Override
    public List<TimerJobEntity> findJobsByProcessInstanceId(String id) {
        return this.jobDataManager.findJobsByProcessInstanceId(id);
    }

    @Override
    public List<Job> findJobsByQueryCriteria(TimerJobQueryImpl jobQuery) {
        return this.jobDataManager.findJobsByQueryCriteria(jobQuery);
    }

    @Override
    public long findJobCountByQueryCriteria(TimerJobQueryImpl jobQuery) {
        return this.jobDataManager.findJobCountByQueryCriteria(jobQuery);
    }

    @Override
    public void updateJobTenantIdForDeployment(String deploymentId, String newTenantId) {
        this.jobDataManager.updateJobTenantIdForDeployment(deploymentId, newTenantId);
    }

    @Override
    public boolean insertTimerJobEntity(TimerJobEntity timerJobEntity) {
        return this.doInsert(timerJobEntity, true);
    }

    @Override
    public void insert(TimerJobEntity jobEntity) {
        this.insert(jobEntity, true);
    }

    @Override
    public void insert(TimerJobEntity jobEntity, boolean fireCreateEvent) {
        this.doInsert(jobEntity, fireCreateEvent);
    }

    protected boolean doInsert(TimerJobEntity jobEntity, boolean fireCreateEvent) {
        if (jobEntity.getExecutionId() != null) {
            ExecutionEntity execution = (ExecutionEntity)this.getExecutionEntityManager().findById(jobEntity.getExecutionId());
            if (execution != null) {
                execution.getTimerJobs().add(jobEntity);
                if (execution.getTenantId() != null) {
                    jobEntity.setTenantId(execution.getTenantId());
                }
                if (this.isExecutionRelatedEntityCountEnabled(execution)) {
                    CountingExecutionEntity countingExecutionEntity = (CountingExecutionEntity)((Object)execution);
                    countingExecutionEntity.setTimerJobCount(countingExecutionEntity.getTimerJobCount() + 1);
                }
            } else {
                return false;
            }
        }
        super.insert(jobEntity, fireCreateEvent);
        return true;
    }

    @Override
    public void delete(TimerJobEntity jobEntity) {
        CountingExecutionEntity executionEntity;
        super.delete(jobEntity);
        this.deleteExceptionByteArrayRef(jobEntity);
        this.removeExecutionLink(jobEntity);
        if (jobEntity.getExecutionId() != null && this.isExecutionRelatedEntityCountEnabledGlobally() && this.isExecutionRelatedEntityCountEnabled(executionEntity = (CountingExecutionEntity)this.getExecutionEntityManager().findById(jobEntity.getExecutionId()))) {
            executionEntity.setTimerJobCount(executionEntity.getTimerJobCount() - 1);
        }
        if (this.getEventDispatcher().isEnabled()) {
            this.getEventDispatcher().dispatchEvent((FlowableEvent)FlowableEventBuilder.createEntityEvent(FlowableEngineEventType.ENTITY_DELETED, this));
        }
    }

    protected void removeExecutionLink(TimerJobEntity jobEntity) {
        ExecutionEntity execution;
        if (jobEntity.getExecutionId() != null && (execution = (ExecutionEntity)this.getExecutionEntityManager().findById(jobEntity.getExecutionId())) != null) {
            execution.getTimerJobs().remove(jobEntity);
        }
    }

    protected void deleteExceptionByteArrayRef(TimerJobEntity jobEntity) {
        ByteArrayRef exceptionByteArrayRef = jobEntity.getExceptionByteArrayRef();
        if (exceptionByteArrayRef != null) {
            exceptionByteArrayRef.delete();
        }
    }

    protected TimerJobEntity createTimer(JobEntity te) {
        TimerJobEntity newTimerEntity = (TimerJobEntity)this.create();
        newTimerEntity.setJobHandlerConfiguration(te.getJobHandlerConfiguration());
        newTimerEntity.setJobHandlerType(te.getJobHandlerType());
        newTimerEntity.setExclusive(te.isExclusive());
        newTimerEntity.setRepeat(te.getRepeat());
        newTimerEntity.setRetries(te.getRetries());
        newTimerEntity.setEndDate(te.getEndDate());
        newTimerEntity.setExecutionId(te.getExecutionId());
        newTimerEntity.setProcessInstanceId(te.getProcessInstanceId());
        newTimerEntity.setProcessDefinitionId(te.getProcessDefinitionId());
        newTimerEntity.setTenantId(te.getTenantId());
        newTimerEntity.setJobType("timer");
        return newTimerEntity;
    }

    protected void setNewRepeat(JobEntity timerEntity, int newRepeatValue) {
        List<String> expression = Arrays.asList(timerEntity.getRepeat().split("/"));
        expression = expression.subList(1, expression.size());
        StringBuilder repeatBuilder = new StringBuilder("R");
        repeatBuilder.append(newRepeatValue);
        for (String value : expression) {
            repeatBuilder.append("/");
            repeatBuilder.append(value);
        }
        timerEntity.setRepeat(repeatBuilder.toString());
    }

    protected boolean isValidTime(JobEntity timerEntity, Date newTimerDate, VariableScope variableScope) {
        BusinessCalendar businessCalendar = this.getProcessEngineConfiguration().getBusinessCalendarManager().getBusinessCalendar(this.getBusinessCalendarName(TimerEventHandler.geCalendarNameFromConfiguration(timerEntity.getJobHandlerConfiguration()), variableScope));
        return businessCalendar.validateDuedate(timerEntity.getRepeat(), timerEntity.getMaxIterations(), timerEntity.getEndDate(), newTimerDate);
    }

    protected Date calculateNextTimer(JobEntity timerEntity, VariableScope variableScope) {
        BusinessCalendar businessCalendar = this.getProcessEngineConfiguration().getBusinessCalendarManager().getBusinessCalendar(this.getBusinessCalendarName(TimerEventHandler.geCalendarNameFromConfiguration(timerEntity.getJobHandlerConfiguration()), variableScope));
        return businessCalendar.resolveDuedate(timerEntity.getRepeat(), timerEntity.getMaxIterations());
    }

    protected int calculateRepeatValue(JobEntity timerEntity) {
        int times = -1;
        List<String> expression = Arrays.asList(timerEntity.getRepeat().split("/"));
        if (expression.size() > 1 && expression.get(0).startsWith("R") && expression.get(0).length() > 1 && (times = Integer.parseInt(expression.get(0).substring(1))) > 0) {
            --times;
        }
        return times;
    }

    protected String getBusinessCalendarName(String calendarName, VariableScope variableScope) {
        String businessCalendarName = CycleBusinessCalendar.NAME;
        if (StringUtils.isNotEmpty((CharSequence)calendarName)) {
            businessCalendarName = (String)Context.getProcessEngineConfiguration().getExpressionManager().createExpression(calendarName).getValue(variableScope);
        }
        return businessCalendarName;
    }

    protected TimerJobDataManager getDataManager() {
        return this.jobDataManager;
    }

    public void setJobDataManager(TimerJobDataManager jobDataManager) {
        this.jobDataManager = jobDataManager;
    }
}

