/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.history.async;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.flowable.engine.common.impl.interceptor.Session;
import org.flowable.engine.impl.history.async.AsyncHistoryDateUtil;
import org.flowable.engine.impl.history.async.AsyncHistoryListener;
import org.flowable.engine.impl.history.async.AsyncHistorySessionCommandContextCloseListener;
import org.flowable.engine.impl.interceptor.CommandContext;
import org.flowable.engine.impl.interceptor.CommandContextCloseListener;

public class AsyncHistorySession
implements Session {
    protected CommandContext commandContext;
    protected AsyncHistoryListener asyncHistoryListener;
    protected CommandContextCloseListener commandContextCloseListener;
    protected String tenantId;
    protected Map<String, List<Map<String, String>>> jobData;

    public AsyncHistorySession(CommandContext commandContext, AsyncHistoryListener asyncHistoryJobListener) {
        this.commandContext = commandContext;
        this.asyncHistoryListener = asyncHistoryJobListener;
        this.initCommandContextCloseListener();
    }

    protected void initCommandContextCloseListener() {
        this.commandContextCloseListener = new AsyncHistorySessionCommandContextCloseListener(this, this.asyncHistoryListener);
    }

    public void addHistoricData(String type, Map<String, String> data) {
        this.addHistoricData(type, data, null);
    }

    public void addHistoricData(String type, Map<String, String> data, String tenantId) {
        data.put("__timeStamp", AsyncHistoryDateUtil.formatDate(this.commandContext.getProcessEngineConfiguration().getClock().getCurrentTime()));
        if (this.jobData == null) {
            this.jobData = new LinkedHashMap<String, List<Map<String, String>>>();
            this.commandContext.addCloseListener(this.commandContextCloseListener);
        }
        if (tenantId != null) {
            this.tenantId = tenantId;
        }
        if (!this.jobData.containsKey(type)) {
            this.jobData.put(type, new ArrayList(1));
        }
        this.jobData.get(type).add(data);
    }

    public void flush() {
    }

    public void close() {
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public Map<String, List<Map<String, String>>> getJobData() {
        return this.jobData;
    }

    public void setJobData(Map<String, List<Map<String, String>>> jobData) {
        this.jobData = jobData;
    }
}

