/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.el;

import java.beans.FeatureDescriptor;
import java.util.Iterator;
import org.flowable.engine.common.impl.javax.el.ELContext;
import org.flowable.engine.common.impl.javax.el.ELException;
import org.flowable.engine.common.impl.javax.el.ELResolver;
import org.flowable.engine.impl.util.ReflectUtil;

public class DynamicBeanPropertyELResolver
extends ELResolver {
    protected Class<?> subject;
    protected String readMethodName;
    protected String writeMethodName;
    protected boolean readOnly;

    public DynamicBeanPropertyELResolver(boolean readOnly, Class<?> subject, String readMethodName, String writeMethodName) {
        this.readOnly = readOnly;
        this.subject = subject;
        this.readMethodName = readMethodName;
        this.writeMethodName = writeMethodName;
    }

    public DynamicBeanPropertyELResolver(Class<?> subject, String readMethodName, String writeMethodName) {
        this(false, subject, readMethodName, writeMethodName);
    }

    public Class<?> getCommonPropertyType(ELContext context, Object base) {
        if (this.subject.isInstance(base)) {
            return Object.class;
        }
        return null;
    }

    public Iterator<FeatureDescriptor> getFeatureDescriptors(ELContext context, Object base) {
        return null;
    }

    public Class<?> getType(ELContext context, Object base, Object property) {
        if (base == null || this.getCommonPropertyType(context, base) == null) {
            return null;
        }
        context.setPropertyResolved(true);
        return Object.class;
    }

    public Object getValue(ELContext context, Object base, Object property) {
        if (base == null || this.getCommonPropertyType(context, base) == null) {
            return null;
        }
        String propertyName = property.toString();
        try {
            Object value = ReflectUtil.invoke(base, this.readMethodName, new Object[]{propertyName});
            context.setPropertyResolved(true);
            return value;
        }
        catch (Exception e) {
            throw new ELException((Throwable)e);
        }
    }

    public boolean isReadOnly(ELContext context, Object base, Object property) {
        return this.readOnly;
    }

    public void setValue(ELContext context, Object base, Object property, Object value) {
        if (base == null || this.getCommonPropertyType(context, base) == null) {
            return;
        }
        String propertyName = property.toString();
        try {
            ReflectUtil.invoke(base, this.writeMethodName, new Object[]{propertyName, value});
            context.setPropertyResolved(true);
        }
        catch (Exception e) {
            throw new ELException((Throwable)e);
        }
    }
}

