/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.cmd;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.flowable.bpmn.model.BpmnModel;
import org.flowable.bpmn.model.FlowElement;
import org.flowable.bpmn.model.Process;
import org.flowable.bpmn.model.StartEvent;
import org.flowable.bpmn.model.ValuedDataObject;
import org.flowable.content.api.ContentItem;
import org.flowable.content.api.ContentService;
import org.flowable.engine.common.api.FlowableObjectNotFoundException;
import org.flowable.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.flowable.engine.impl.interceptor.Command;
import org.flowable.engine.impl.interceptor.CommandContext;
import org.flowable.engine.impl.persistence.deploy.DeploymentManager;
import org.flowable.engine.impl.util.ProcessDefinitionUtil;
import org.flowable.engine.impl.util.ProcessInstanceHelper;
import org.flowable.engine.repository.ProcessDefinition;
import org.flowable.engine.runtime.ProcessInstance;
import org.flowable.form.api.FormRepositoryService;
import org.flowable.form.api.FormService;
import org.flowable.form.model.FormField;
import org.flowable.form.model.FormModel;

public class StartProcessInstanceWithFormCmd
implements Command<ProcessInstance>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String processDefinitionId;
    protected String outcome;
    protected Map<String, Object> variables;
    protected String processInstanceName;

    public StartProcessInstanceWithFormCmd(String processDefinitionId, String outcome, Map<String, Object> variables, String processInstanceName) {
        this.processDefinitionId = processDefinitionId;
        this.outcome = outcome;
        this.variables = variables;
        this.processInstanceName = processInstanceName;
    }

    @Override
    public ProcessInstance execute(CommandContext commandContext) {
        FormRepositoryService formRepositoryService;
        StartEvent startEvent;
        BpmnModel bpmnModel;
        Process process;
        FlowElement startElement;
        ProcessEngineConfigurationImpl processEngineConfiguration = commandContext.getProcessEngineConfiguration();
        DeploymentManager deploymentCache = processEngineConfiguration.getDeploymentManager();
        ProcessDefinition processDefinition = deploymentCache.findDeployedProcessDefinitionById(this.processDefinitionId);
        if (processDefinition == null) {
            throw new FlowableObjectNotFoundException("No process definition found for id = '" + this.processDefinitionId + "'", ProcessDefinition.class);
        }
        FormModel formModel = null;
        Map formVariables = null;
        FormService formService = processEngineConfiguration.getFormEngineFormService();
        if ((this.variables != null || this.outcome != null) && (startElement = (process = (bpmnModel = ProcessDefinitionUtil.getBpmnModel(processDefinition.getId())).getProcessById(processDefinition.getKey())).getInitialFlowElement()) instanceof StartEvent && StringUtils.isNotEmpty((CharSequence)(startEvent = (StartEvent)startElement).getFormKey()) && (formModel = (formRepositoryService = processEngineConfiguration.getFormEngineRepositoryService()).getFormModelByKey(startEvent.getFormKey())) != null) {
            formVariables = formService.getVariablesFromFormSubmission(formModel, this.variables, this.outcome);
        }
        ProcessInstance processInstance = this.createAndStartProcessInstance(processDefinition, this.processInstanceName, formVariables, commandContext);
        if (formModel != null) {
            formService.createFormInstance(formVariables, formModel, null, processInstance.getId());
            this.processUploadFieldsIfNeeded(formModel, processInstance.getId(), commandContext);
        }
        return processInstance;
    }

    protected ProcessInstance createAndStartProcessInstance(ProcessDefinition processDefinition, String processInstanceName, Map<String, Object> variables, CommandContext commandContext) {
        ProcessInstanceHelper processInstanceHelper = commandContext.getProcessEngineConfiguration().getProcessInstanceHelper();
        return processInstanceHelper.createAndStartProcessInstance(processDefinition, null, processInstanceName, variables, null);
    }

    protected Map<String, Object> processDataObjects(Collection<ValuedDataObject> dataObjects) {
        HashMap<String, Object> variablesMap = new HashMap<String, Object>();
        if (dataObjects != null) {
            for (ValuedDataObject dataObject : dataObjects) {
                variablesMap.put(dataObject.getName(), dataObject.getValue());
            }
        }
        return variablesMap;
    }

    protected void processUploadFieldsIfNeeded(FormModel formModel, String processInstanceId, CommandContext commandContext) {
        ProcessEngineConfigurationImpl processEngineConfiguration = commandContext.getProcessEngineConfiguration();
        if (!processEngineConfiguration.isContentEngineInitialized()) {
            return;
        }
        if (formModel != null && formModel.getFields() != null) {
            for (FormField formField : formModel.getFields()) {
                String variableValue;
                String variableName;
                if (!"upload".equals(formField.getType()) || !this.variables.containsKey(variableName = formField.getId()) || !StringUtils.isNotEmpty((CharSequence)(variableValue = (String)this.variables.get(variableName)))) continue;
                String[] contentItemIds = StringUtils.split((String)variableValue, (String)",");
                HashSet contentItemIdSet = new HashSet();
                Collections.addAll(contentItemIdSet, contentItemIds);
                ContentService contentService = processEngineConfiguration.getContentService();
                List contentItems = contentService.createContentItemQuery().ids(contentItemIdSet).list();
                for (ContentItem contentItem : contentItems) {
                    contentItem.setProcessInstanceId(processInstanceId);
                    contentItem.setField(formField.getId());
                    contentService.saveContentItem(contentItem);
                }
            }
        }
    }
}

