/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.cmd;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.Serializable;
import org.flowable.bpmn.model.BpmnModel;
import org.flowable.bpmn.model.SubProcess;
import org.flowable.bpmn.model.ValuedDataObject;
import org.flowable.engine.common.api.FlowableIllegalArgumentException;
import org.flowable.engine.common.api.FlowableObjectNotFoundException;
import org.flowable.engine.compatibility.Flowable5CompatibilityHandler;
import org.flowable.engine.impl.DataObjectImpl;
import org.flowable.engine.impl.context.Context;
import org.flowable.engine.impl.interceptor.Command;
import org.flowable.engine.impl.interceptor.CommandContext;
import org.flowable.engine.impl.persistence.entity.ExecutionEntity;
import org.flowable.engine.impl.persistence.entity.VariableInstance;
import org.flowable.engine.impl.util.Flowable5Util;
import org.flowable.engine.impl.util.ProcessDefinitionUtil;
import org.flowable.engine.runtime.DataObject;
import org.flowable.engine.runtime.Execution;

public class GetDataObjectCmd
implements Command<DataObject>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String executionId;
    protected String dataObjectName;
    protected boolean isLocal;
    protected String locale;
    protected boolean withLocalizationFallback;

    public GetDataObjectCmd(String executionId, String dataObjectName, boolean isLocal) {
        this.executionId = executionId;
        this.dataObjectName = dataObjectName;
        this.isLocal = isLocal;
    }

    public GetDataObjectCmd(String executionId, String dataObjectName, boolean isLocal, String locale, boolean withLocalizationFallback) {
        this.executionId = executionId;
        this.dataObjectName = dataObjectName;
        this.isLocal = isLocal;
        this.locale = locale;
        this.withLocalizationFallback = withLocalizationFallback;
    }

    @Override
    public DataObject execute(CommandContext commandContext) {
        if (this.executionId == null) {
            throw new FlowableIllegalArgumentException("executionId is null");
        }
        if (this.dataObjectName == null) {
            throw new FlowableIllegalArgumentException("dataObjectName is null");
        }
        ExecutionEntity execution = (ExecutionEntity)commandContext.getExecutionEntityManager().findById(this.executionId);
        if (execution == null) {
            throw new FlowableObjectNotFoundException("execution " + this.executionId + " doesn't exist", Execution.class);
        }
        DataObjectImpl dataObject = null;
        VariableInstance variableEntity = null;
        if (Flowable5Util.isFlowable5ProcessDefinitionId(commandContext, execution.getProcessDefinitionId())) {
            Flowable5CompatibilityHandler compatibilityHandler = Flowable5Util.getFlowable5CompatibilityHandler();
            variableEntity = compatibilityHandler.getExecutionVariableInstance(this.executionId, this.dataObjectName, this.isLocal);
        } else {
            variableEntity = this.isLocal ? execution.getVariableInstanceLocal(this.dataObjectName, false) : execution.getVariableInstance(this.dataObjectName, false);
        }
        String localizedName = null;
        String localizedDescription = null;
        if (variableEntity != null) {
            ObjectNode languageNode;
            ExecutionEntity executionEntity = (ExecutionEntity)commandContext.getExecutionEntityManager().findById(variableEntity.getExecutionId());
            while (!executionEntity.isScope()) {
                executionEntity = executionEntity.getParent();
            }
            BpmnModel bpmnModel = ProcessDefinitionUtil.getBpmnModel(executionEntity.getProcessDefinitionId());
            ValuedDataObject foundDataObject = null;
            if (executionEntity.getParentId() == null) {
                for (ValuedDataObject dataObjectDefinition : bpmnModel.getMainProcess().getDataObjects()) {
                    if (!dataObjectDefinition.getName().equals(variableEntity.getName())) continue;
                    foundDataObject = dataObjectDefinition;
                    break;
                }
            } else {
                SubProcess subProcess = (SubProcess)bpmnModel.getFlowElement(execution.getActivityId());
                for (ValuedDataObject dataObjectDefinition : subProcess.getDataObjects()) {
                    if (!dataObjectDefinition.getName().equals(variableEntity.getName())) continue;
                    foundDataObject = dataObjectDefinition;
                    break;
                }
            }
            if (this.locale != null && foundDataObject != null && (languageNode = Context.getLocalizationElementProperties(this.locale, foundDataObject.getId(), execution.getProcessDefinitionId(), this.withLocalizationFallback)) != null) {
                JsonNode descriptionNode;
                JsonNode nameNode = languageNode.get("name");
                if (nameNode != null) {
                    localizedName = nameNode.asText();
                }
                if ((descriptionNode = languageNode.get("description")) != null) {
                    localizedDescription = descriptionNode.asText();
                }
            }
            if (foundDataObject != null) {
                dataObject = new DataObjectImpl(variableEntity.getId(), variableEntity.getProcessInstanceId(), variableEntity.getExecutionId(), variableEntity.getName(), variableEntity.getValue(), foundDataObject.getDocumentation(), foundDataObject.getType(), localizedName, localizedDescription, foundDataObject.getId());
            }
        }
        return dataObject;
    }
}

