/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.cmd;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.flowable.content.api.ContentItem;
import org.flowable.content.api.ContentService;
import org.flowable.engine.common.api.FlowableIllegalArgumentException;
import org.flowable.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.flowable.engine.impl.cmd.NeedsActiveTaskCmd;
import org.flowable.engine.impl.interceptor.CommandContext;
import org.flowable.engine.impl.persistence.entity.TaskEntity;
import org.flowable.engine.impl.util.TaskHelper;
import org.flowable.form.api.FormRepositoryService;
import org.flowable.form.api.FormService;
import org.flowable.form.model.FormField;
import org.flowable.form.model.FormModel;

public class CompleteTaskWithFormCmd
extends NeedsActiveTaskCmd<Void> {
    private static final long serialVersionUID = 1L;
    protected String formDefinitionId;
    protected String outcome;
    protected Map<String, Object> variables;
    protected Map<String, Object> transientVariables;
    protected boolean localScope;

    public CompleteTaskWithFormCmd(String taskId, String formDefinitionId, String outcome, Map<String, Object> variables) {
        super(taskId);
        this.formDefinitionId = formDefinitionId;
        this.outcome = outcome;
        this.variables = variables;
    }

    public CompleteTaskWithFormCmd(String taskId, String formDefinitionId, String outcome, Map<String, Object> variables, boolean localScope) {
        this(taskId, formDefinitionId, outcome, variables);
        this.localScope = localScope;
    }

    public CompleteTaskWithFormCmd(String taskId, String formDefinitionId, String outcome, Map<String, Object> variables, Map<String, Object> transientVariables) {
        this(taskId, formDefinitionId, outcome, variables);
        this.transientVariables = transientVariables;
    }

    @Override
    protected Void execute(CommandContext commandContext, TaskEntity task) {
        ProcessEngineConfigurationImpl processEngineConfiguration = commandContext.getProcessEngineConfiguration();
        if (!processEngineConfiguration.isFormEngineInitialized()) {
            throw new FlowableIllegalArgumentException("Form engine is not initialized");
        }
        FormRepositoryService formRepositoryService = processEngineConfiguration.getFormEngineRepositoryService();
        FormModel formModel = formRepositoryService.getFormModelById(this.formDefinitionId);
        if (formModel != null) {
            FormService formService = processEngineConfiguration.getFormEngineFormService();
            Map formVariables = formService.getVariablesFromFormSubmission(formModel, this.variables, this.outcome);
            formService.saveFormInstance(formVariables, formModel, task.getId(), task.getProcessInstanceId());
            this.processUploadFieldsIfNeeded(formModel, task, commandContext);
            TaskHelper.completeTask(task, formVariables, this.transientVariables, this.localScope, commandContext);
        } else {
            TaskHelper.completeTask(task, this.variables, this.transientVariables, this.localScope, commandContext);
        }
        return null;
    }

    protected void processUploadFieldsIfNeeded(FormModel formModel, TaskEntity task, CommandContext commandContext) {
        ProcessEngineConfigurationImpl processEngineConfiguration = commandContext.getProcessEngineConfiguration();
        if (!processEngineConfiguration.isContentEngineInitialized()) {
            return;
        }
        if (formModel != null && formModel.getFields() != null) {
            for (FormField formField : formModel.getFields()) {
                String variableValue;
                String variableName;
                if (!"upload".equals(formField.getType()) || !this.variables.containsKey(variableName = formField.getId()) || !StringUtils.isNotEmpty((CharSequence)(variableValue = (String)this.variables.get(variableName)))) continue;
                String[] contentItemIds = StringUtils.split((String)variableValue, (String)",");
                HashSet contentItemIdSet = new HashSet();
                Collections.addAll(contentItemIdSet, contentItemIds);
                ContentService contentService = processEngineConfiguration.getContentService();
                List contentItems = contentService.createContentItemQuery().ids(contentItemIdSet).list();
                for (ContentItem contentItem : contentItems) {
                    contentItem.setTaskId(task.getId());
                    contentItem.setProcessInstanceId(task.getProcessInstanceId());
                    contentItem.setField(formField.getId());
                    contentService.saveContentItem(contentItem);
                }
            }
        }
    }

    @Override
    protected String getSuspendedTaskException() {
        return "Cannot complete a suspended task";
    }
}

