/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.bpmn.behavior;

import org.flowable.bpmn.model.Activity;
import org.flowable.bpmn.model.SubProcess;
import org.flowable.engine.common.api.FlowableException;
import org.flowable.engine.common.api.FlowableIllegalArgumentException;
import org.flowable.engine.delegate.BpmnError;
import org.flowable.engine.delegate.DelegateExecution;
import org.flowable.engine.impl.bpmn.behavior.AbstractBpmnActivityBehavior;
import org.flowable.engine.impl.bpmn.behavior.MultiInstanceActivityBehavior;
import org.flowable.engine.impl.context.Context;
import org.flowable.engine.impl.persistence.entity.ExecutionEntity;
import org.flowable.engine.impl.persistence.entity.ExecutionEntityManager;

public class SequentialMultiInstanceBehavior
extends MultiInstanceActivityBehavior {
    private static final long serialVersionUID = 1L;

    public SequentialMultiInstanceBehavior(Activity activity, AbstractBpmnActivityBehavior innerActivityBehavior) {
        super(activity, innerActivityBehavior);
    }

    @Override
    protected int createInstances(DelegateExecution multiInstanceRootExecution) {
        int nrOfInstances = this.resolveNrOfInstances(multiInstanceRootExecution);
        if (nrOfInstances == 0) {
            return nrOfInstances;
        }
        if (nrOfInstances < 0) {
            throw new FlowableIllegalArgumentException("Invalid number of instances: must be a non-negative integer value, but was " + nrOfInstances);
        }
        ExecutionEntity execution = Context.getCommandContext().getExecutionEntityManager().createChildExecution((ExecutionEntity)multiInstanceRootExecution);
        execution.setCurrentFlowElement(multiInstanceRootExecution.getCurrentFlowElement());
        this.setLoopVariable(multiInstanceRootExecution, "nrOfInstances", nrOfInstances);
        this.setLoopVariable(multiInstanceRootExecution, "nrOfCompletedInstances", 0);
        this.setLoopVariable(multiInstanceRootExecution, "nrOfActiveInstances", 1);
        this.logLoopDetails(multiInstanceRootExecution, "initialized", 0, 0, 1, nrOfInstances);
        if (nrOfInstances > 0) {
            this.executeOriginalBehavior(execution, 0);
        }
        return nrOfInstances;
    }

    @Override
    public void leave(DelegateExecution execution) {
        DelegateExecution multiInstanceRootExecution = this.getMultiInstanceRootExecution(execution);
        int loopCounter = this.getLoopVariable(execution, this.getCollectionElementIndexVariable()) + 1;
        int nrOfInstances = this.getLoopVariable(multiInstanceRootExecution, "nrOfInstances");
        int nrOfCompletedInstances = this.getLoopVariable(multiInstanceRootExecution, "nrOfCompletedInstances") + 1;
        int nrOfActiveInstances = this.getLoopVariable(multiInstanceRootExecution, "nrOfActiveInstances");
        this.setLoopVariable(multiInstanceRootExecution, "nrOfCompletedInstances", nrOfCompletedInstances);
        this.logLoopDetails(execution, "instance completed", loopCounter, nrOfCompletedInstances, nrOfActiveInstances, nrOfInstances);
        this.callActivityEndListeners(execution);
        if (loopCounter >= nrOfInstances || this.completionConditionSatisfied(multiInstanceRootExecution)) {
            super.leave(execution);
        } else {
            try {
                if (execution.getCurrentFlowElement() instanceof SubProcess) {
                    ExecutionEntityManager executionEntityManager = Context.getCommandContext().getExecutionEntityManager();
                    ExecutionEntity executionToContinue = executionEntityManager.createChildExecution((ExecutionEntity)multiInstanceRootExecution);
                    executionToContinue.setCurrentFlowElement(execution.getCurrentFlowElement());
                    executionToContinue.setScope(true);
                    this.executeOriginalBehavior(executionToContinue, loopCounter);
                } else {
                    Context.getCommandContext().getHistoryManager().recordActivityEnd((ExecutionEntity)execution, null);
                    this.executeOriginalBehavior(execution, loopCounter);
                }
            }
            catch (BpmnError error) {
                throw error;
            }
            catch (Exception e) {
                throw new FlowableException("Could not execute inner activity behavior of multi instance behavior", (Throwable)e);
            }
        }
    }
}

