/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.agenda;

import java.util.List;
import org.flowable.engine.common.api.FlowableException;
import org.flowable.engine.impl.agenda.AbstractOperation;
import org.flowable.engine.impl.interceptor.CommandContext;
import org.flowable.engine.impl.persistence.entity.DeadLetterJobEntity;
import org.flowable.engine.impl.persistence.entity.DeadLetterJobEntityManager;
import org.flowable.engine.impl.persistence.entity.ExecutionEntity;
import org.flowable.engine.impl.persistence.entity.ExecutionEntityManager;
import org.flowable.engine.impl.persistence.entity.JobEntity;
import org.flowable.engine.impl.persistence.entity.JobEntityManager;
import org.flowable.engine.impl.persistence.entity.SuspendedJobEntity;
import org.flowable.engine.impl.persistence.entity.SuspendedJobEntityManager;
import org.flowable.engine.impl.persistence.entity.TaskEntity;
import org.flowable.engine.impl.persistence.entity.TaskEntityManager;
import org.flowable.engine.impl.persistence.entity.TimerJobEntity;
import org.flowable.engine.impl.persistence.entity.TimerJobEntityManager;
import org.flowable.engine.impl.persistence.entity.VariableInstanceEntity;
import org.flowable.engine.impl.persistence.entity.VariableInstanceEntityManager;

public class DestroyScopeOperation
extends AbstractOperation {
    public DestroyScopeOperation(CommandContext commandContext, ExecutionEntity execution) {
        super(commandContext, execution);
    }

    @Override
    public void run() {
        ExecutionEntity scopeExecution;
        ExecutionEntity executionEntity = scopeExecution = this.execution.isScope() ? this.execution : this.findFirstParentScopeExecution(this.execution);
        if (scopeExecution == null) {
            throw new FlowableException("Programmatic error: no parent scope execution found for boundary event");
        }
        ExecutionEntityManager executionEntityManager = this.commandContext.getExecutionEntityManager();
        List<ExecutionEntity> childExecutions = executionEntityManager.findChildExecutionsByParentExecutionId(scopeExecution.getId());
        for (ExecutionEntity childExecution : childExecutions) {
            executionEntityManager.deleteExecutionAndRelatedData(childExecution, this.execution.getDeleteReason(), false);
        }
        TaskEntityManager taskEntityManager = this.commandContext.getTaskEntityManager();
        List<TaskEntity> tasksForExecution = taskEntityManager.findTasksByExecutionId(scopeExecution.getId());
        for (TaskEntity taskEntity : tasksForExecution) {
            taskEntityManager.deleteTask(taskEntity, this.execution.getDeleteReason(), false, false, true);
        }
        TimerJobEntityManager timerJobEntityManager = this.commandContext.getTimerJobEntityManager();
        List<TimerJobEntity> timerJobsForExecution = timerJobEntityManager.findJobsByExecutionId(scopeExecution.getId());
        for (TimerJobEntity job : timerJobsForExecution) {
            timerJobEntityManager.delete(job);
        }
        JobEntityManager jobEntityManager = this.commandContext.getJobEntityManager();
        List jobsForExecution = jobEntityManager.findJobsByExecutionId(scopeExecution.getId());
        for (JobEntity job : jobsForExecution) {
            jobEntityManager.delete(job);
        }
        SuspendedJobEntityManager suspendedJobEntityManager = this.commandContext.getSuspendedJobEntityManager();
        List<SuspendedJobEntity> suspendedJobsForExecution = suspendedJobEntityManager.findJobsByExecutionId(scopeExecution.getId());
        for (SuspendedJobEntity job : suspendedJobsForExecution) {
            suspendedJobEntityManager.delete(job);
        }
        DeadLetterJobEntityManager deadLetterJobEntityManager = this.commandContext.getDeadLetterJobEntityManager();
        List<DeadLetterJobEntity> deadLetterJobsForExecution = deadLetterJobEntityManager.findJobsByExecutionId(scopeExecution.getId());
        for (DeadLetterJobEntity job : deadLetterJobsForExecution) {
            deadLetterJobEntityManager.delete(job);
        }
        VariableInstanceEntityManager variableInstanceEntityManager = this.commandContext.getVariableInstanceEntityManager();
        List<VariableInstanceEntity> variablesForExecution = variableInstanceEntityManager.findVariableInstancesByExecutionId(scopeExecution.getId());
        for (VariableInstanceEntity variable : variablesForExecution) {
            variableInstanceEntityManager.delete(variable);
        }
        if (scopeExecution.isActive()) {
            this.commandContext.getHistoryManager().recordActivityEnd(scopeExecution, scopeExecution.getDeleteReason());
        }
        executionEntityManager.delete(scopeExecution);
    }
}

