/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.util;

import java.util.Date;
import java.util.TimeZone;
import org.apache.commons.lang3.StringUtils;
import org.flowable.bpmn.model.FlowElement;
import org.flowable.bpmn.model.IntermediateCatchEvent;
import org.flowable.bpmn.model.TimerEventDefinition;
import org.flowable.engine.common.api.FlowableException;
import org.flowable.engine.common.runtime.Clock;
import org.flowable.engine.delegate.Expression;
import org.flowable.engine.delegate.VariableScope;
import org.flowable.engine.impl.calendar.BusinessCalendar;
import org.flowable.engine.impl.calendar.CycleBusinessCalendar;
import org.flowable.engine.impl.calendar.DurationBusinessCalendar;
import org.flowable.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.flowable.engine.impl.context.Context;
import org.flowable.engine.impl.el.ExpressionManager;
import org.flowable.engine.impl.el.NoExecutionVariableScope;
import org.flowable.engine.impl.persistence.entity.ExecutionEntity;
import org.flowable.engine.impl.persistence.entity.TimerJobEntity;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

public class TimerUtil {
    public static TimerJobEntity createTimerEntityForTimerEventDefinition(TimerEventDefinition timerEventDefinition, boolean isInterruptingTimer, ExecutionEntity executionEntity, String jobHandlerType, String jobHandlerConfig) {
        ProcessEngineConfigurationImpl processEngineConfiguration = Context.getProcessEngineConfiguration();
        String businessCalendarRef = null;
        Expression expression = null;
        ExpressionManager expressionManager = processEngineConfiguration.getExpressionManager();
        VariableScope scopeForExpression = executionEntity;
        if (scopeForExpression == null) {
            scopeForExpression = NoExecutionVariableScope.getSharedInstance();
        }
        if (StringUtils.isNotEmpty((CharSequence)timerEventDefinition.getTimeDate())) {
            businessCalendarRef = "dueDate";
            expression = expressionManager.createExpression(timerEventDefinition.getTimeDate());
        } else if (StringUtils.isNotEmpty((CharSequence)timerEventDefinition.getTimeCycle())) {
            businessCalendarRef = CycleBusinessCalendar.NAME;
            expression = expressionManager.createExpression(timerEventDefinition.getTimeCycle());
        } else if (StringUtils.isNotEmpty((CharSequence)timerEventDefinition.getTimeDuration())) {
            businessCalendarRef = DurationBusinessCalendar.NAME;
            expression = expressionManager.createExpression(timerEventDefinition.getTimeDuration());
        }
        if (StringUtils.isNotEmpty((CharSequence)timerEventDefinition.getCalendarName())) {
            businessCalendarRef = timerEventDefinition.getCalendarName();
            Expression businessCalendarExpression = expressionManager.createExpression(businessCalendarRef);
            businessCalendarRef = businessCalendarExpression.getValue(scopeForExpression).toString();
        }
        if (expression == null) {
            throw new FlowableException("Timer needs configuration (either timeDate, timeCycle or timeDuration is needed) (" + timerEventDefinition.getId() + ")");
        }
        BusinessCalendar businessCalendar = processEngineConfiguration.getBusinessCalendarManager().getBusinessCalendar(businessCalendarRef);
        String dueDateString = null;
        Date duedate = null;
        Object dueDateValue = expression.getValue(scopeForExpression);
        if (dueDateValue instanceof String) {
            dueDateString = (String)dueDateValue;
        } else if (dueDateValue instanceof Date) {
            duedate = (Date)dueDateValue;
        } else if (dueDateValue instanceof DateTime) {
            duedate = ((DateTime)dueDateValue).toDate();
        } else if (dueDateValue != null) {
            throw new FlowableException("Timer '" + executionEntity.getActivityId() + "' was not configured with a valid duration/time, either hand in a java.util.Date or a String in format 'yyyy-MM-dd'T'hh:mm:ss'");
        }
        if (duedate == null && dueDateString != null) {
            duedate = businessCalendar.resolveDuedate(dueDateString);
        }
        TimerJobEntity timer = null;
        if (duedate != null) {
            timer = (TimerJobEntity)Context.getCommandContext().getTimerJobEntityManager().create();
            timer.setJobType("timer");
            timer.setRevision(1);
            timer.setJobHandlerType(jobHandlerType);
            timer.setJobHandlerConfiguration(jobHandlerConfig);
            timer.setExclusive(true);
            timer.setRetries(processEngineConfiguration.getAsyncExecutorNumberOfRetries());
            timer.setDuedate(duedate);
            if (executionEntity != null) {
                timer.setExecution(executionEntity);
                timer.setProcessDefinitionId(executionEntity.getProcessDefinitionId());
                timer.setProcessInstanceId(executionEntity.getProcessInstanceId());
                if (executionEntity.getTenantId() != null) {
                    timer.setTenantId(executionEntity.getTenantId());
                }
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)timerEventDefinition.getTimeCycle())) {
            FlowElement currentElement;
            boolean repeat;
            boolean bl = repeat = !isInterruptingTimer;
            if (executionEntity != null && (currentElement = executionEntity.getCurrentFlowElement()) instanceof IntermediateCatchEvent) {
                repeat = false;
            }
            if (repeat) {
                String prepared = TimerUtil.prepareRepeat(dueDateString);
                timer.setRepeat(prepared);
            }
        }
        if (timer != null && executionEntity != null) {
            timer.setExecution(executionEntity);
            timer.setProcessDefinitionId(executionEntity.getProcessDefinitionId());
            if (executionEntity.getTenantId() != null) {
                timer.setTenantId(executionEntity.getTenantId());
            }
        }
        return timer;
    }

    public static String prepareRepeat(String dueDate) {
        if (dueDate.startsWith("R") && dueDate.split("/").length == 2) {
            DateTimeFormatter fmt = ISODateTimeFormat.dateTime();
            Clock clock = Context.getProcessEngineConfiguration().getClock();
            Date now = clock.getCurrentTime();
            return dueDate.replace("/", "/" + fmt.print((ReadableInstant)new DateTime((Object)now, DateTimeZone.forTimeZone((TimeZone)clock.getCurrentTimeZone()))) + "/");
        }
        return dueDate;
    }
}

