/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.cmd;

import java.io.Serializable;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.flowable.engine.common.api.FlowableIllegalArgumentException;
import org.flowable.engine.common.api.delegate.event.FlowableEvent;
import org.flowable.engine.compatibility.Flowable5CompatibilityHandler;
import org.flowable.engine.delegate.event.FlowableEngineEventType;
import org.flowable.engine.delegate.event.impl.FlowableEventBuilder;
import org.flowable.engine.impl.history.HistoryLevel;
import org.flowable.engine.impl.interceptor.Command;
import org.flowable.engine.impl.interceptor.CommandContext;
import org.flowable.engine.impl.persistence.entity.TaskEntity;
import org.flowable.engine.impl.util.Flowable5Util;
import org.flowable.engine.task.Task;
import org.flowable.engine.task.TaskInfo;

public class SaveTaskCmd
implements Command<Void>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected TaskEntity task;

    public SaveTaskCmd(Task task) {
        this.task = (TaskEntity)task;
    }

    @Override
    public Void execute(CommandContext commandContext) {
        if (this.task == null) {
            throw new FlowableIllegalArgumentException("task is null");
        }
        if (this.task.getProcessDefinitionId() != null && Flowable5Util.isFlowable5ProcessDefinitionId(commandContext, this.task.getProcessDefinitionId())) {
            Flowable5CompatibilityHandler compatibilityHandler = Flowable5Util.getFlowable5CompatibilityHandler();
            compatibilityHandler.saveTask(this.task);
            return null;
        }
        if (this.task.getRevision() == 0) {
            commandContext.getTaskEntityManager().insert(this.task, null);
            if (commandContext.getEventDispatcher().isEnabled()) {
                commandContext.getEventDispatcher().dispatchEvent((FlowableEvent)FlowableEventBuilder.createEntityEvent(FlowableEngineEventType.TASK_CREATED, this.task));
            }
        } else {
            TaskInfo originalTaskEntity = null;
            if (commandContext.getProcessEngineConfiguration().getHistoryLevel().isAtLeast(HistoryLevel.AUDIT)) {
                originalTaskEntity = (TaskInfo)commandContext.getHistoricTaskInstanceEntityManager().findById(this.task.getId());
            }
            if (originalTaskEntity == null) {
                originalTaskEntity = (TaskInfo)commandContext.getTaskEntityManager().findById(this.task.getId());
            }
            String originalName = originalTaskEntity.getName();
            String originalAssignee = originalTaskEntity.getAssignee();
            String originalOwner = originalTaskEntity.getOwner();
            String originalDescription = originalTaskEntity.getDescription();
            Date originalDueDate = originalTaskEntity.getDueDate();
            int originalPriority = originalTaskEntity.getPriority();
            String originalCategory = originalTaskEntity.getCategory();
            String originalFormKey = originalTaskEntity.getFormKey();
            String originalParentTaskId = originalTaskEntity.getParentTaskId();
            String originalTaskDefinitionKey = originalTaskEntity.getTaskDefinitionKey();
            if (commandContext.getProcessEngineConfiguration().getHistoryLevel().isAtLeast(HistoryLevel.AUDIT)) {
                if (!StringUtils.equals((CharSequence)originalName, (CharSequence)this.task.getName())) {
                    commandContext.getHistoryManager().recordTaskNameChange(this.task.getId(), this.task.getName());
                }
                if (!StringUtils.equals((CharSequence)originalDescription, (CharSequence)this.task.getDescription())) {
                    commandContext.getHistoryManager().recordTaskDescriptionChange(this.task.getId(), this.task.getDescription());
                }
                if (originalDueDate == null && this.task.getDueDate() != null || originalDueDate != null && this.task.getDueDate() == null || originalDueDate != null && !originalDueDate.equals(this.task.getDueDate())) {
                    commandContext.getHistoryManager().recordTaskDueDateChange(this.task.getId(), this.task.getDueDate());
                }
                if (originalPriority != this.task.getPriority()) {
                    commandContext.getHistoryManager().recordTaskPriorityChange(this.task.getId(), this.task.getPriority());
                }
                if (!StringUtils.equals((CharSequence)originalCategory, (CharSequence)this.task.getCategory())) {
                    commandContext.getHistoryManager().recordTaskCategoryChange(this.task.getId(), this.task.getCategory());
                }
                if (!StringUtils.equals((CharSequence)originalFormKey, (CharSequence)this.task.getFormKey())) {
                    commandContext.getHistoryManager().recordTaskFormKeyChange(this.task.getId(), this.task.getFormKey());
                }
                if (!StringUtils.equals((CharSequence)originalParentTaskId, (CharSequence)this.task.getParentTaskId())) {
                    commandContext.getHistoryManager().recordTaskParentTaskIdChange(this.task.getId(), this.task.getParentTaskId());
                }
                if (!StringUtils.equals((CharSequence)originalTaskDefinitionKey, (CharSequence)this.task.getTaskDefinitionKey())) {
                    commandContext.getHistoryManager().recordTaskDefinitionKeyChange(this.task.getId(), this.task.getTaskDefinitionKey());
                }
            }
            if (!StringUtils.equals((CharSequence)originalOwner, (CharSequence)this.task.getOwner())) {
                if (this.task.getProcessInstanceId() != null) {
                    commandContext.getIdentityLinkEntityManager().involveUser(this.task.getProcessInstance(), this.task.getOwner(), "participant");
                }
                commandContext.getHistoryManager().recordTaskOwnerChange(this.task.getId(), this.task.getOwner());
            }
            if (!StringUtils.equals((CharSequence)originalAssignee, (CharSequence)this.task.getAssignee())) {
                if (this.task.getProcessInstanceId() != null) {
                    commandContext.getIdentityLinkEntityManager().involveUser(this.task.getProcessInstance(), this.task.getAssignee(), "participant");
                }
                commandContext.getHistoryManager().recordTaskAssigneeChange(this.task.getId(), this.task.getAssignee());
                commandContext.getProcessEngineConfiguration().getListenerNotificationHelper().executeTaskListeners(this.task, "assignment");
                commandContext.getHistoryManager().recordTaskAssignment(this.task);
                if (commandContext.getEventDispatcher().isEnabled()) {
                    commandContext.getEventDispatcher().dispatchEvent((FlowableEvent)FlowableEventBuilder.createEntityEvent(FlowableEngineEventType.TASK_ASSIGNED, this.task));
                }
            }
            commandContext.getTaskEntityManager().update(this.task);
        }
        return null;
    }
}

