/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.bpmn.behavior;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.flowable.bpmn.model.Activity;
import org.flowable.bpmn.model.BoundaryEvent;
import org.flowable.bpmn.model.CallActivity;
import org.flowable.bpmn.model.CompensateEventDefinition;
import org.flowable.bpmn.model.FlowElement;
import org.flowable.bpmn.model.SubProcess;
import org.flowable.bpmn.model.Transaction;
import org.flowable.engine.common.api.FlowableIllegalArgumentException;
import org.flowable.engine.common.impl.util.CollectionUtil;
import org.flowable.engine.delegate.DelegateExecution;
import org.flowable.engine.impl.bpmn.behavior.AbstractBpmnActivityBehavior;
import org.flowable.engine.impl.bpmn.behavior.MultiInstanceActivityBehavior;
import org.flowable.engine.impl.bpmn.helper.ScopeUtil;
import org.flowable.engine.impl.context.Context;
import org.flowable.engine.impl.interceptor.CommandContext;
import org.flowable.engine.impl.persistence.entity.ExecutionEntity;
import org.flowable.engine.impl.persistence.entity.ExecutionEntityManager;

public class ParallelMultiInstanceBehavior
extends MultiInstanceActivityBehavior {
    private static final long serialVersionUID = 1L;

    public ParallelMultiInstanceBehavior(Activity activity, AbstractBpmnActivityBehavior originalActivityBehavior) {
        super(activity, originalActivityBehavior);
    }

    @Override
    protected int createInstances(DelegateExecution execution) {
        DelegateExecution concurrentExecution;
        int loopCounter;
        int nrOfInstances = this.resolveNrOfInstances(execution);
        if (nrOfInstances < 0) {
            throw new FlowableIllegalArgumentException("Invalid number of instances: must be non-negative integer value, but was " + nrOfInstances);
        }
        execution.setMultiInstanceRoot(true);
        this.setLoopVariable(execution, "nrOfInstances", nrOfInstances);
        this.setLoopVariable(execution, "nrOfCompletedInstances", 0);
        this.setLoopVariable(execution, "nrOfActiveInstances", nrOfInstances);
        ArrayList<DelegateExecution> concurrentExecutions = new ArrayList<DelegateExecution>();
        for (loopCounter = 0; loopCounter < nrOfInstances; ++loopCounter) {
            concurrentExecution = Context.getCommandContext().getExecutionEntityManager().createChildExecution((ExecutionEntity)execution);
            concurrentExecution.setCurrentFlowElement((FlowElement)this.activity);
            concurrentExecution.setActive(true);
            concurrentExecution.setScope(false);
            concurrentExecutions.add(concurrentExecution);
            this.logLoopDetails(concurrentExecution, "initialized", loopCounter, 0, nrOfInstances, nrOfInstances);
        }
        for (loopCounter = 0; loopCounter < nrOfInstances; ++loopCounter) {
            concurrentExecution = (DelegateExecution)concurrentExecutions.get(loopCounter);
            if (!concurrentExecution.isActive() || concurrentExecution.isEnded() || !concurrentExecution.getParent().isActive() || concurrentExecution.getParent().isEnded()) continue;
            this.setLoopVariable(concurrentExecution, this.getCollectionElementIndexVariable(), loopCounter);
            this.executeOriginalBehavior(concurrentExecution, loopCounter);
        }
        if (!concurrentExecutions.isEmpty()) {
            ExecutionEntity executionEntity = (ExecutionEntity)execution;
            executionEntity.setActive(false);
        }
        return nrOfInstances;
    }

    @Override
    public void leave(DelegateExecution execution) {
        boolean zeroNrOfInstances = false;
        if (this.resolveNrOfInstances(execution) == 0) {
            zeroNrOfInstances = true;
            this.removeLocalLoopVariable(execution, this.getCollectionElementIndexVariable());
            super.leave(execution);
            execution.setMultiInstanceRoot(false);
        }
        int loopCounter = this.getLoopVariable(execution, this.getCollectionElementIndexVariable());
        int nrOfInstances = this.getLoopVariable(execution, "nrOfInstances");
        int nrOfCompletedInstances = this.getLoopVariable(execution, "nrOfCompletedInstances") + 1;
        int nrOfActiveInstances = this.getLoopVariable(execution, "nrOfActiveInstances") - 1;
        Context.getCommandContext().getHistoryManager().recordActivityEnd((ExecutionEntity)execution, null);
        this.callActivityEndListeners(execution);
        if (zeroNrOfInstances) {
            return;
        }
        DelegateExecution miRootExecution = this.getMultiInstanceRootExecution(execution);
        if (miRootExecution != null) {
            this.setLoopVariable(miRootExecution, "nrOfCompletedInstances", nrOfCompletedInstances);
            this.setLoopVariable(miRootExecution, "nrOfActiveInstances", nrOfActiveInstances);
        }
        this.logLoopDetails(execution, "instance completed", loopCounter, nrOfCompletedInstances, nrOfActiveInstances, nrOfInstances);
        ExecutionEntity executionEntity = (ExecutionEntity)execution;
        if (executionEntity.getParent() != null) {
            executionEntity.inactivate();
            this.lockFirstParentScope(executionEntity);
            if (nrOfCompletedInstances >= nrOfInstances || this.completionConditionSatisfied(execution.getParent())) {
                ExecutionEntity executionToUse = null;
                executionToUse = nrOfInstances > 0 ? executionEntity.getParent() : executionEntity;
                boolean hasCompensation = false;
                Activity activity = (Activity)execution.getCurrentFlowElement();
                if (activity instanceof Transaction) {
                    hasCompensation = true;
                } else if (activity instanceof SubProcess) {
                    SubProcess subProcess = (SubProcess)activity;
                    block0: for (FlowElement subElement : subProcess.getFlowElements()) {
                        Object subActivity;
                        if (!(subElement instanceof Activity) || !CollectionUtil.isNotEmpty((Collection)(subActivity = (Activity)subElement).getBoundaryEvents())) continue;
                        for (BoundaryEvent boundaryEvent : subActivity.getBoundaryEvents()) {
                            if (!CollectionUtil.isNotEmpty((Collection)boundaryEvent.getEventDefinitions()) || !(boundaryEvent.getEventDefinitions().get(0) instanceof CompensateEventDefinition)) continue;
                            hasCompensation = true;
                            continue block0;
                        }
                    }
                }
                if (hasCompensation) {
                    ScopeUtil.createCopyOfSubProcessExecutionForCompensation(executionToUse);
                }
                if (activity instanceof CallActivity) {
                    ExecutionEntityManager executionEntityManager = Context.getCommandContext().getExecutionEntityManager();
                    if (executionToUse != null) {
                        ArrayList<String> callActivityExecutionIds = new ArrayList<String>();
                        List<ExecutionEntity> childExecutions = executionEntityManager.collectChildren(executionToUse);
                        if (childExecutions != null) {
                            for (ExecutionEntity childExecution : childExecutions) {
                                if (!activity.getId().equals(childExecution.getCurrentActivityId())) continue;
                                callActivityExecutionIds.add(childExecution.getId());
                            }
                            for (int i = childExecutions.size() - 1; i >= 0; --i) {
                                ExecutionEntity childExecution;
                                childExecution = childExecutions.get(i);
                                if (!StringUtils.isNotEmpty((CharSequence)childExecution.getSuperExecutionId()) || !callActivityExecutionIds.contains(childExecution.getSuperExecutionId())) continue;
                                executionEntityManager.deleteProcessInstanceExecutionEntity(childExecution.getId(), activity.getId(), "call activity completion condition met", true, false);
                            }
                        }
                    }
                }
                this.deleteChildExecutions(executionToUse, false, Context.getCommandContext());
                this.removeLocalLoopVariable(executionToUse, this.getCollectionElementIndexVariable());
                executionToUse.setScope(false);
                executionToUse.setMultiInstanceRoot(false);
                Context.getAgenda().planTakeOutgoingSequenceFlowsOperation(executionToUse, true);
            }
        } else {
            this.removeLocalLoopVariable(execution, this.getCollectionElementIndexVariable());
            execution.setMultiInstanceRoot(false);
            super.leave(execution);
        }
    }

    protected void lockFirstParentScope(DelegateExecution execution) {
        ExecutionEntityManager executionEntityManager = Context.getCommandContext().getExecutionEntityManager();
        boolean found = false;
        ExecutionEntity parentScopeExecution = null;
        ExecutionEntity currentExecution = (ExecutionEntity)execution;
        while (!found && currentExecution != null && currentExecution.getParentId() != null) {
            parentScopeExecution = (ExecutionEntity)executionEntityManager.findById(currentExecution.getParentId());
            if (parentScopeExecution != null && parentScopeExecution.isScope()) {
                found = true;
            }
            currentExecution = parentScopeExecution;
        }
        parentScopeExecution.forceUpdate();
    }

    protected void deleteChildExecutions(ExecutionEntity parentExecution, boolean deleteExecution, CommandContext commandContext) {
        ExecutionEntityManager executionEntityManager = commandContext.getExecutionEntityManager();
        List<ExecutionEntity> childExecutions = executionEntityManager.findChildExecutionsByParentExecutionId(parentExecution.getId());
        if (CollectionUtil.isNotEmpty(childExecutions)) {
            for (ExecutionEntity childExecution : childExecutions) {
                this.deleteChildExecutions(childExecution, true, commandContext);
            }
        }
        if (deleteExecution) {
            executionEntityManager.deleteExecutionAndRelatedData(parentExecution, null, false);
        }
    }
}

