/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.bpmn.behavior;

import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.flowable.bpmn.model.Signal;
import org.flowable.bpmn.model.SignalEventDefinition;
import org.flowable.bpmn.model.ThrowEvent;
import org.flowable.engine.common.api.delegate.event.FlowableEvent;
import org.flowable.engine.delegate.DelegateExecution;
import org.flowable.engine.delegate.Expression;
import org.flowable.engine.delegate.event.FlowableEngineEventType;
import org.flowable.engine.delegate.event.impl.FlowableEventBuilder;
import org.flowable.engine.impl.bpmn.behavior.AbstractBpmnActivityBehavior;
import org.flowable.engine.impl.context.Context;
import org.flowable.engine.impl.interceptor.CommandContext;
import org.flowable.engine.impl.persistence.entity.EventSubscriptionEntityManager;
import org.flowable.engine.impl.persistence.entity.ExecutionEntity;
import org.flowable.engine.impl.persistence.entity.SignalEventSubscriptionEntity;

public class IntermediateThrowSignalEventActivityBehavior
extends AbstractBpmnActivityBehavior {
    private static final long serialVersionUID = 1L;
    protected final SignalEventDefinition signalEventDefinition;
    protected String signalEventName;
    protected String signalExpression;
    protected boolean processInstanceScope;

    public IntermediateThrowSignalEventActivityBehavior(ThrowEvent throwEvent, SignalEventDefinition signalEventDefinition, Signal signal) {
        if (signal != null) {
            this.signalEventName = signal.getName();
            if ("processInstance".equals(signal.getScope())) {
                this.processInstanceScope = true;
            }
        } else if (StringUtils.isNotEmpty((CharSequence)signalEventDefinition.getSignalRef())) {
            this.signalEventName = signalEventDefinition.getSignalRef();
        } else {
            this.signalExpression = signalEventDefinition.getSignalExpression();
        }
        this.signalEventDefinition = signalEventDefinition;
    }

    @Override
    public void execute(DelegateExecution execution) {
        CommandContext commandContext = Context.getCommandContext();
        String eventSubscriptionName = null;
        if (this.signalEventName != null) {
            eventSubscriptionName = this.signalEventName;
        } else {
            Expression expressionObject = commandContext.getProcessEngineConfiguration().getExpressionManager().createExpression(this.signalExpression);
            eventSubscriptionName = expressionObject.getValue(execution).toString();
        }
        EventSubscriptionEntityManager eventSubscriptionEntityManager = commandContext.getEventSubscriptionEntityManager();
        List<SignalEventSubscriptionEntity> subscriptionEntities = null;
        subscriptionEntities = this.processInstanceScope ? eventSubscriptionEntityManager.findSignalEventSubscriptionsByProcessInstanceAndEventName(execution.getProcessInstanceId(), eventSubscriptionName) : eventSubscriptionEntityManager.findSignalEventSubscriptionsByEventName(eventSubscriptionName, execution.getTenantId());
        for (SignalEventSubscriptionEntity signalEventSubscriptionEntity : subscriptionEntities) {
            Context.getProcessEngineConfiguration().getEventDispatcher().dispatchEvent((FlowableEvent)FlowableEventBuilder.createSignalEvent(FlowableEngineEventType.ACTIVITY_SIGNALED, signalEventSubscriptionEntity.getActivityId(), eventSubscriptionName, null, signalEventSubscriptionEntity.getExecutionId(), signalEventSubscriptionEntity.getProcessInstanceId(), signalEventSubscriptionEntity.getProcessDefinitionId()));
            eventSubscriptionEntityManager.eventReceived(signalEventSubscriptionEntity, null, this.signalEventDefinition.isAsync());
        }
        commandContext.getAgenda().planTakeOutgoingSequenceFlowsOperation((ExecutionEntity)execution, true);
    }
}

