/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.app;

import java.util.Map;
import org.flowable.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.flowable.engine.impl.context.Context;
import org.flowable.engine.impl.persistence.deploy.Deployer;
import org.flowable.engine.impl.persistence.deploy.DeploymentManager;
import org.flowable.engine.impl.persistence.entity.DeploymentEntity;
import org.flowable.engine.impl.persistence.entity.ResourceEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AppDeployer
implements Deployer {
    private static final Logger log = LoggerFactory.getLogger(AppDeployer.class);

    @Override
    public void deploy(DeploymentEntity deployment, Map<String, Object> deploymentSettings) {
        log.debug("Processing app deployment {}", (Object)deployment.getName());
        ProcessEngineConfigurationImpl processEngineConfiguration = Context.getProcessEngineConfiguration();
        DeploymentManager deploymentManager = processEngineConfiguration.getDeploymentManager();
        Object appResourceObject = null;
        Map<String, ResourceEntity> resources = deployment.getResources();
        for (String resourceName : resources.keySet()) {
            if (!resourceName.endsWith(".app")) continue;
            log.info("Processing app resource {}", (Object)resourceName);
            ResourceEntity resourceEntity = resources.get(resourceName);
            byte[] resourceBytes = resourceEntity.getBytes();
            appResourceObject = processEngineConfiguration.getAppResourceConverter().convertAppResourceToModel(resourceBytes);
        }
        if (appResourceObject != null) {
            deploymentManager.getAppResourceCache().add(deployment.getId(), appResourceObject);
        }
    }
}

