/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.cmd;

import java.util.GregorianCalendar;
import java.util.List;
import org.activiti.engine.impl.Page;
import org.activiti.engine.impl.asyncexecutor.AcquiredJobEntities;
import org.activiti.engine.impl.asyncexecutor.AsyncExecutor;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.entity.JobEntity;

public class AcquireAsyncJobsDueCmd
implements Command<AcquiredJobEntities> {
    private final AsyncExecutor asyncExecutor;
    private final int remainingCapacity;

    public AcquireAsyncJobsDueCmd(AsyncExecutor asyncExecutor) {
        this(asyncExecutor, Integer.MAX_VALUE);
    }

    public AcquireAsyncJobsDueCmd(AsyncExecutor asyncExecutor, int remainingCapacity) {
        this.asyncExecutor = asyncExecutor;
        this.remainingCapacity = remainingCapacity;
    }

    @Override
    public AcquiredJobEntities execute(CommandContext commandContext) {
        int maxResults = Math.min(this.remainingCapacity, this.asyncExecutor.getMaxAsyncJobsDuePerAcquisition());
        List<JobEntity> jobs = commandContext.getJobEntityManager().findAsyncJobsDueToExecute(new Page(0, maxResults));
        AcquiredJobEntities acquiredJobs = new AcquiredJobEntities();
        for (JobEntity job : jobs) {
            this.lockJob(commandContext, job, this.asyncExecutor.getAsyncJobLockTimeInMillis());
            acquiredJobs.addJob(job);
        }
        return acquiredJobs;
    }

    protected void lockJob(CommandContext commandContext, JobEntity job, int lockTimeInMillis) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTime(commandContext.getProcessEngineConfiguration().getClock().getCurrentTime());
        gregorianCalendar.add(14, lockTimeInMillis);
        job.setLockExpirationTime(gregorianCalendar.getTime());
    }
}

