/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.asyncexecutor;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.activiti.engine.ActivitiOptimisticLockingException;
import org.activiti.engine.impl.asyncexecutor.AcquiredJobEntities;
import org.activiti.engine.impl.asyncexecutor.AsyncExecutor;
import org.activiti.engine.impl.cmd.AcquireAsyncJobsDueCmd;
import org.activiti.engine.impl.cmd.UnacquireJobsCmd;
import org.activiti.engine.impl.interceptor.CommandExecutor;
import org.activiti.engine.impl.persistence.entity.JobEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AcquireAsyncJobsDueRunnable
implements Runnable {
    private static Logger log = LoggerFactory.getLogger(AcquireAsyncJobsDueRunnable.class);
    protected final AsyncExecutor asyncExecutor;
    protected volatile boolean isInterrupted = false;
    protected final Object MONITOR = new Object();
    protected final AtomicBoolean isWaiting = new AtomicBoolean(false);

    public AcquireAsyncJobsDueRunnable(AsyncExecutor asyncExecutor) {
        this.asyncExecutor = asyncExecutor;
    }

    @Override
    public synchronized void run() {
        log.info("starting to acquire async jobs due");
        CommandExecutor commandExecutor = this.asyncExecutor.getCommandExecutor();
        while (!this.isInterrupted) {
            long millisToWait;
            int remainingCapacity = this.asyncExecutor.getRemainingCapacity();
            if (remainingCapacity > 0) {
                millisToWait = this.acquireAndExecuteJobs(commandExecutor, remainingCapacity);
                if (log.isDebugEnabled()) {
                    log.debug("acquired and queued new jobs; sleeping for {} ms", (Object)millisToWait);
                }
            } else {
                millisToWait = this.asyncExecutor.getDefaultAsyncJobAcquireWaitTimeInMillis();
                if (log.isDebugEnabled()) {
                    log.debug("queue is full; sleeping for {} ms", (Object)millisToWait);
                }
            }
            if (millisToWait <= 0L) continue;
            this.sleep(millisToWait);
        }
        log.info("stopped async job due acquisition");
    }

    protected long acquireAndExecuteJobs(CommandExecutor commandExecutor, int remainingCapacity) {
        try {
            AcquiredJobEntities acquiredJobs = commandExecutor.execute(new AcquireAsyncJobsDueCmd(this.asyncExecutor, remainingCapacity));
            List<JobEntity> rejectedJobs = this.offerJobs(acquiredJobs);
            log.debug("Jobs acquired: {}, rejected: {}", (Object)acquiredJobs.size(), (Object)rejectedJobs.size());
            if (rejectedJobs.size() > 0) {
                this.unacquireJobs(commandExecutor, rejectedJobs);
                return this.asyncExecutor.getDefaultAsyncJobAcquireWaitTimeInMillis();
            }
            if (acquiredJobs.size() >= this.asyncExecutor.getMaxAsyncJobsDuePerAcquisition()) {
                return 0L;
            }
        }
        catch (ActivitiOptimisticLockingException optimisticLockingException) {
            if (log.isDebugEnabled()) {
                log.debug("Optimistic locking exception during async job acquisition. If you have multiple async executors running against the same database, this exception means that this thread tried to acquire a due async job, which already was acquired by another async executor acquisition thread.This is expected behavior in a clustered environment. You can ignore this message if you indeed have multiple async executor acquisition threads running against the same database. Exception message: {}", (Object)optimisticLockingException.getMessage());
            }
        }
        catch (Throwable e) {
            log.error("exception during async job acquisition: {}", (Object)e.getMessage(), (Object)e);
        }
        return this.asyncExecutor.getDefaultAsyncJobAcquireWaitTimeInMillis();
    }

    private List<JobEntity> offerJobs(AcquiredJobEntities acquiredJobs) {
        ArrayList<JobEntity> rejected = new ArrayList<JobEntity>();
        for (JobEntity job : acquiredJobs.getJobs()) {
            boolean jobSuccessFullyOffered = this.asyncExecutor.executeAsyncJob(job);
            if (jobSuccessFullyOffered) continue;
            rejected.add(job);
        }
        return rejected;
    }

    private void unacquireJobs(CommandExecutor commandExecutor, List<JobEntity> rejectedJobs) {
        commandExecutor.execute(new UnacquireJobsCmd(rejectedJobs));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sleep(long millisToWait) {
        try {
            if (log.isDebugEnabled()) {
                log.debug("async job acquisition thread sleeping for {} millis", (Object)millisToWait);
            }
            Object object = this.MONITOR;
            synchronized (object) {
                if (!this.isInterrupted) {
                    this.isWaiting.set(true);
                    this.MONITOR.wait(millisToWait);
                }
            }
            if (log.isDebugEnabled()) {
                log.debug("async job acquisition thread woke up");
            }
        }
        catch (InterruptedException e) {
            if (log.isDebugEnabled()) {
                log.debug("async job acquisition wait interrupted");
            }
        }
        finally {
            this.isWaiting.set(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.MONITOR;
        synchronized (object) {
            this.isInterrupted = true;
            if (this.isWaiting.compareAndSet(true, false)) {
                this.MONITOR.notifyAll();
            }
        }
    }
}

