/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.dynamic;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.UserTask;
import org.activiti.engine.dynamic.BasePropertiesParser;

public class UserTaskPropertiesParser
extends BasePropertiesParser {
    @Override
    protected ObjectNode createPropertiesNode(FlowElement flowElement, ObjectNode flowElementNode, ObjectMapper objectMapper) {
        UserTask userTask = (UserTask)flowElement;
        ObjectNode taskNameNode = objectMapper.createObjectNode();
        this.putPropertyValue("bpmnmodel", userTask.getName(), taskNameNode);
        this.putPropertyValue("dynamic", flowElementNode.path("userTaskName"), taskNameNode);
        ObjectNode assigneeNode = objectMapper.createObjectNode();
        this.putPropertyValue("bpmnmodel", userTask.getAssignee(), assigneeNode);
        this.putPropertyValue("dynamic", flowElementNode.path("userTaskAssignee"), assigneeNode);
        ObjectNode candidateUsersNode = objectMapper.createObjectNode();
        this.putPropertyValue("bpmnmodel", userTask.getCandidateUsers(), candidateUsersNode);
        this.putPropertyValue("dynamic", flowElementNode.path("userTaskCandidateUsers"), candidateUsersNode);
        ObjectNode candidateGroupsNode = objectMapper.createObjectNode();
        this.putPropertyValue("bpmnmodel", userTask.getCandidateGroups(), candidateGroupsNode);
        this.putPropertyValue("dynamic", flowElementNode.path("userTaskCandidateGroups"), candidateGroupsNode);
        ObjectNode propertiesNode = objectMapper.createObjectNode();
        propertiesNode.set("userTaskName", (JsonNode)taskNameNode);
        propertiesNode.set("userTaskAssignee", (JsonNode)assigneeNode);
        propertiesNode.set("userTaskCandidateUsers", (JsonNode)candidateUsersNode);
        propertiesNode.set("userTaskCandidateGroups", (JsonNode)candidateGroupsNode);
        return propertiesNode;
    }

    @Override
    public boolean supports(FlowElement flowElement) {
        return flowElement instanceof UserTask;
    }
}

