/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.bpmn.converter;

import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.commons.lang3.StringUtils;
import org.flowable.bpmn.converter.BaseBpmnXMLConverter;
import org.flowable.bpmn.converter.util.BpmnXMLUtil;
import org.flowable.bpmn.model.BaseElement;
import org.flowable.bpmn.model.BoundaryEvent;
import org.flowable.bpmn.model.BpmnModel;
import org.flowable.bpmn.model.ErrorEventDefinition;
import org.flowable.bpmn.model.Event;
import org.flowable.bpmn.model.EventDefinition;

public class BoundaryEventXMLConverter
extends BaseBpmnXMLConverter {
    @Override
    public Class<? extends BaseElement> getBpmnElementType() {
        return BoundaryEvent.class;
    }

    @Override
    protected String getXMLElementName() {
        return "boundaryEvent";
    }

    @Override
    protected BaseElement convertXMLToElement(XMLStreamReader xtr, BpmnModel model) throws Exception {
        EventDefinition eventDef;
        String cancelActivity;
        BoundaryEvent boundaryEvent = new BoundaryEvent();
        BpmnXMLUtil.addXMLLocation((BaseElement)boundaryEvent, xtr);
        if (StringUtils.isNotEmpty((CharSequence)xtr.getAttributeValue(null, "cancelActivity")) && "false".equalsIgnoreCase(cancelActivity = xtr.getAttributeValue(null, "cancelActivity"))) {
            boundaryEvent.setCancelActivity(false);
        }
        boundaryEvent.setAttachedToRefId(xtr.getAttributeValue(null, "attachedToRef"));
        this.parseChildElements(this.getXMLElementName(), (BaseElement)boundaryEvent, model, xtr);
        if (boundaryEvent.getEventDefinitions().size() == 1 && (eventDef = (EventDefinition)boundaryEvent.getEventDefinitions().get(0)) instanceof ErrorEventDefinition) {
            boundaryEvent.setCancelActivity(false);
        }
        return boundaryEvent;
    }

    @Override
    protected void writeAdditionalAttributes(BaseElement element, BpmnModel model, XMLStreamWriter xtw) throws Exception {
        EventDefinition eventDef;
        BoundaryEvent boundaryEvent = (BoundaryEvent)element;
        if (boundaryEvent.getAttachedToRef() != null) {
            this.writeDefaultAttribute("attachedToRef", boundaryEvent.getAttachedToRef().getId(), xtw);
        }
        if (boundaryEvent.getEventDefinitions().size() == 1 && !((eventDef = (EventDefinition)boundaryEvent.getEventDefinitions().get(0)) instanceof ErrorEventDefinition)) {
            this.writeDefaultAttribute("cancelActivity", String.valueOf(boundaryEvent.isCancelActivity()).toLowerCase(), xtw);
        }
    }

    @Override
    protected void writeAdditionalChildElements(BaseElement element, BpmnModel model, XMLStreamWriter xtw) throws Exception {
        BoundaryEvent boundaryEvent = (BoundaryEvent)element;
        this.writeEventDefinitions((Event)boundaryEvent, boundaryEvent.getEventDefinitions(), model, xtw);
    }
}

