/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.bpmn.converter;

import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.activiti.bpmn.converter.BaseBpmnXMLConverter;
import org.activiti.bpmn.converter.export.FieldExtensionExport;
import org.activiti.bpmn.converter.util.BpmnXMLUtil;
import org.activiti.bpmn.model.BaseElement;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.CustomProperty;
import org.activiti.bpmn.model.ImplementationType;
import org.activiti.bpmn.model.ServiceTask;
import org.apache.commons.lang3.StringUtils;

public class ServiceTaskXMLConverter
extends BaseBpmnXMLConverter {
    @Override
    public Class<? extends BaseElement> getBpmnElementType() {
        return ServiceTask.class;
    }

    @Override
    protected String getXMLElementName() {
        return "serviceTask";
    }

    @Override
    protected BaseElement convertXMLToElement(XMLStreamReader xtr, BpmnModel model) throws Exception {
        ServiceTask serviceTask = new ServiceTask();
        BpmnXMLUtil.addXMLLocation((BaseElement)serviceTask, xtr);
        if (StringUtils.isNotEmpty((CharSequence)BpmnXMLUtil.getAttributeValue("class", xtr))) {
            serviceTask.setImplementationType(ImplementationType.IMPLEMENTATION_TYPE_CLASS);
            serviceTask.setImplementation(BpmnXMLUtil.getAttributeValue("class", xtr));
        } else if (StringUtils.isNotEmpty((CharSequence)BpmnXMLUtil.getAttributeValue("expression", xtr))) {
            serviceTask.setImplementationType(ImplementationType.IMPLEMENTATION_TYPE_EXPRESSION);
            serviceTask.setImplementation(BpmnXMLUtil.getAttributeValue("expression", xtr));
        } else if (StringUtils.isNotEmpty((CharSequence)BpmnXMLUtil.getAttributeValue("delegateExpression", xtr))) {
            serviceTask.setImplementationType(ImplementationType.IMPLEMENTATION_TYPE_DELEGATEEXPRESSION);
            serviceTask.setImplementation(BpmnXMLUtil.getAttributeValue("delegateExpression", xtr));
        } else if ("##WebService".equals(xtr.getAttributeValue(null, "implementation"))) {
            serviceTask.setImplementationType(ImplementationType.IMPLEMENTATION_TYPE_WEBSERVICE);
            serviceTask.setOperationRef(this.parseOperationRef(xtr.getAttributeValue(null, "operationRef"), model));
        }
        serviceTask.setResultVariableName(BpmnXMLUtil.getAttributeValue("resultVariableName", xtr));
        if (StringUtils.isEmpty((CharSequence)serviceTask.getResultVariableName())) {
            serviceTask.setResultVariableName(BpmnXMLUtil.getAttributeValue("resultVariable", xtr));
        }
        serviceTask.setType(BpmnXMLUtil.getAttributeValue("type", xtr));
        serviceTask.setExtensionId(BpmnXMLUtil.getAttributeValue("extensionId", xtr));
        if (StringUtils.isNotEmpty((CharSequence)BpmnXMLUtil.getAttributeValue("skipExpression", xtr))) {
            serviceTask.setSkipExpression(BpmnXMLUtil.getAttributeValue("skipExpression", xtr));
        }
        this.parseChildElements(this.getXMLElementName(), (BaseElement)serviceTask, model, xtr);
        return serviceTask;
    }

    @Override
    protected void writeAdditionalAttributes(BaseElement element, BpmnModel model, XMLStreamWriter xtw) throws Exception {
        ServiceTask serviceTask = (ServiceTask)element;
        if (ImplementationType.IMPLEMENTATION_TYPE_CLASS.equals(serviceTask.getImplementationType())) {
            this.writeQualifiedAttribute("class", serviceTask.getImplementation(), xtw);
        } else if (ImplementationType.IMPLEMENTATION_TYPE_EXPRESSION.equals(serviceTask.getImplementationType())) {
            this.writeQualifiedAttribute("expression", serviceTask.getImplementation(), xtw);
        } else if (ImplementationType.IMPLEMENTATION_TYPE_DELEGATEEXPRESSION.equals(serviceTask.getImplementationType())) {
            this.writeQualifiedAttribute("delegateExpression", serviceTask.getImplementation(), xtw);
        }
        if (StringUtils.isNotEmpty((CharSequence)serviceTask.getResultVariableName())) {
            this.writeQualifiedAttribute("resultVariableName", serviceTask.getResultVariableName(), xtw);
        }
        if (StringUtils.isNotEmpty((CharSequence)serviceTask.getType())) {
            this.writeQualifiedAttribute("type", serviceTask.getType(), xtw);
        }
        if (StringUtils.isNotEmpty((CharSequence)serviceTask.getExtensionId())) {
            this.writeQualifiedAttribute("extensionId", serviceTask.getExtensionId(), xtw);
        }
        if (StringUtils.isNotEmpty((CharSequence)serviceTask.getSkipExpression())) {
            this.writeQualifiedAttribute("skipExpression", serviceTask.getSkipExpression(), xtw);
        }
    }

    @Override
    protected boolean writeExtensionChildElements(BaseElement element, boolean didWriteExtensionStartElement, XMLStreamWriter xtw) throws Exception {
        ServiceTask serviceTask = (ServiceTask)element;
        if (!serviceTask.getCustomProperties().isEmpty()) {
            for (CustomProperty customProperty : serviceTask.getCustomProperties()) {
                if (StringUtils.isEmpty((CharSequence)customProperty.getSimpleValue())) continue;
                if (!didWriteExtensionStartElement) {
                    xtw.writeStartElement("extensionElements");
                    didWriteExtensionStartElement = true;
                }
                xtw.writeStartElement("flowable", "field", "http://flowable.org/bpmn");
                xtw.writeAttribute("name", customProperty.getName());
                if ((customProperty.getSimpleValue().contains("${") || customProperty.getSimpleValue().contains("#{")) && customProperty.getSimpleValue().contains("}")) {
                    xtw.writeStartElement("flowable", "expression", "http://flowable.org/bpmn");
                } else {
                    xtw.writeStartElement("flowable", "string", "http://flowable.org/bpmn");
                }
                xtw.writeCData(customProperty.getSimpleValue());
                xtw.writeEndElement();
                xtw.writeEndElement();
            }
        } else {
            didWriteExtensionStartElement = FieldExtensionExport.writeFieldExtensions(serviceTask.getFieldExtensions(), didWriteExtensionStartElement, xtw);
        }
        return didWriteExtensionStartElement;
    }

    @Override
    protected void writeAdditionalChildElements(BaseElement element, BpmnModel model, XMLStreamWriter xtw) throws Exception {
    }

    protected String parseOperationRef(String operationRef, BpmnModel model) {
        String result = null;
        if (StringUtils.isNotEmpty((CharSequence)operationRef)) {
            int indexOfP = operationRef.indexOf(58);
            if (indexOfP != -1) {
                String prefix = operationRef.substring(0, indexOfP);
                String resolvedNamespace = model.getNamespace(prefix);
                result = resolvedNamespace + ":" + operationRef.substring(indexOfP + 1);
            } else {
                result = model.getTargetNamespace() + ":" + operationRef;
            }
        }
        return result;
    }
}

