/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.p2.tools.mirroring.facade;

import java.util.Arrays;

public class IUDescription {
    private String id;
    private String version;
    private String queryMatchExpression;
    private String[] queryParameters;

    public IUDescription(String id, String version) {
        this(id, version, null, null);
    }

    public IUDescription(String id, String version, String queryMatchExpression, String[] queryParameters) {
        if (id == null && queryMatchExpression == null) {
            throw new NullPointerException("either id or query must be specified");
        }
        this.id = id;
        this.version = version;
        this.queryMatchExpression = queryMatchExpression;
        this.queryParameters = queryParameters;
    }

    public String getId() {
        return this.id;
    }

    public String getVersion() {
        return this.version;
    }

    public String toString() {
        if (this.queryMatchExpression != null) {
            return "[query expression='" + this.queryMatchExpression + ", parameters=" + Arrays.asList(this.queryParameters) + "]";
        }
        return "[" + this.id + ", " + (this.version != null ? this.version : "0.0.0") + "]";
    }

    public String getQueryMatchExpression() {
        return this.queryMatchExpression;
    }

    public String[] getQueryParameters() {
        return this.queryParameters;
    }
}

