/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.ignore.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.jgit.errors.InvalidPatternException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Strings {
    static final List<String> POSIX_CHAR_CLASSES = Arrays.asList("alnum", "alpha", "blank", "cntrl", "digit", "graph", "lower", "print", "punct", "space", "upper", "xdigit", "word");
    private static final String DL = "\\p{javaDigit}\\p{javaLetter}";
    static final List<String> JAVA_CHAR_CLASSES = Arrays.asList("\\p{Alnum}", "\\p{javaLetter}", "\\p{Blank}", "\\p{Cntrl}", "\\p{javaDigit}", "[\\p{Graph}\\p{javaDigit}\\p{javaLetter}]", "\\p{Ll}", "[\\p{Print}\\p{javaDigit}\\p{javaLetter}]", "\\p{Punct}", "\\p{Space}", "\\p{Lu}", "\\p{XDigit}", "[\\p{javaDigit}\\p{javaLetter}_]");
    static final Pattern UNSUPPORTED = Pattern.compile("\\[\\[[.=]\\w+[.=]\\]\\]");

    static char getPathSeparator(Character pathSeparator) {
        return pathSeparator == null ? (char)'/' : (char)pathSeparator.charValue();
    }

    public static String stripTrailing(String pattern, char c) {
        while (pattern.length() > 0 && pattern.charAt(pattern.length() - 1) == c) {
            pattern = pattern.substring(0, pattern.length() - 1);
        }
        return pattern;
    }

    static int count(String s, char c, boolean ignoreFirstLast) {
        int start = 0;
        int count = 0;
        while ((start = s.indexOf(c, start)) != -1) {
            if (!ignoreFirstLast || start != 0 && start != s.length()) {
                ++count;
            }
            ++start;
        }
        return count;
    }

    public static List<String> split(String pattern, char slash) {
        int count = Strings.count(pattern, slash, true);
        if (count < 1) {
            throw new IllegalStateException("Pattern must have at least two segments: " + pattern);
        }
        ArrayList<String> segments = new ArrayList<String>(count);
        int right = 0;
        while (true) {
            int left = ++right;
            if ((right = pattern.indexOf(slash, right)) == -1) {
                if (left >= pattern.length()) break;
                segments.add(pattern.substring(left));
                break;
            }
            if (right - left <= 0) continue;
            if (left == 1) {
                segments.add(pattern.substring(left - 1, right));
                continue;
            }
            if (right == pattern.length() - 1) {
                segments.add(pattern.substring(left, right + 1));
                continue;
            }
            segments.add(pattern.substring(left, right));
        }
        return segments;
    }

    static boolean isWildCard(String pattern) {
        return pattern.indexOf(42) != -1 || Strings.isComplexWildcard(pattern);
    }

    private static boolean isComplexWildcard(String pattern) {
        int idx2;
        int idx1 = pattern.indexOf(91);
        if (idx1 != -1 && (idx2 = pattern.indexOf(93)) > idx1) {
            return true;
        }
        return pattern.indexOf(63) != -1 || pattern.indexOf(92) != -1;
    }

    static PatternState checkWildCards(String pattern) {
        if (Strings.isComplexWildcard(pattern)) {
            return PatternState.COMPLEX;
        }
        int startIdx = pattern.indexOf(42);
        if (startIdx < 0) {
            return PatternState.NONE;
        }
        if (startIdx == pattern.length() - 1) {
            return PatternState.TRAILING_ASTERISK_ONLY;
        }
        if (pattern.lastIndexOf(42) == 0) {
            return PatternState.LEADING_ASTERISK_ONLY;
        }
        return PatternState.COMPLEX;
    }

    static Pattern convertGlob(String pattern) throws InvalidPatternException {
        if (UNSUPPORTED.matcher(pattern).find()) {
            throw new InvalidPatternException("Collating symbols [[.a.]] or equivalence class expressions [[=a=]] are not supported", pattern);
        }
        StringBuilder sb = new StringBuilder(pattern.length());
        int in_brackets = 0;
        boolean seenEscape = false;
        boolean ignoreLastBracket = false;
        boolean in_char_class = false;
        char[] charClass = new char[6];
        for (int i = 0; i < pattern.length(); ++i) {
            char c = pattern.charAt(i);
            switch (c) {
                case '*': {
                    if (seenEscape || in_brackets > 0) {
                        sb.append(c);
                        break;
                    }
                    sb.append('.').append(c);
                    break;
                }
                case '.': {
                    if (seenEscape) {
                        sb.append(c);
                        break;
                    }
                    sb.append('\\').append('.');
                    break;
                }
                case '?': {
                    if (seenEscape || in_brackets > 0) {
                        sb.append(c);
                        break;
                    }
                    sb.append('.');
                    break;
                }
                case ':': {
                    if (in_brackets > 0 && Strings.lookBehind(sb) == '[' && Character.isLetter(Strings.lookAhead(pattern, i))) {
                        in_char_class = true;
                    }
                    sb.append(':');
                    break;
                }
                case '-': {
                    if (in_brackets > 0) {
                        if (Strings.lookAhead(pattern, i) == ']') {
                            sb.append('\\').append(c);
                            break;
                        }
                        sb.append(c);
                        break;
                    }
                    sb.append('-');
                    break;
                }
                case '\\': {
                    char lookAhead;
                    if (in_brackets > 0 && ((lookAhead = Strings.lookAhead(pattern, i)) == ']' || lookAhead == '[')) {
                        ignoreLastBracket = true;
                    }
                    sb.append(c);
                    break;
                }
                case '[': {
                    if (in_brackets > 0) {
                        sb.append('\\').append('[');
                        ignoreLastBracket = true;
                        break;
                    }
                    if (!seenEscape) {
                        ++in_brackets;
                        ignoreLastBracket = false;
                    }
                    sb.append('[');
                    break;
                }
                case ']': {
                    if (seenEscape) {
                        sb.append(']');
                        ignoreLastBracket = true;
                        break;
                    }
                    if (in_brackets <= 0) {
                        sb.append('\\').append(']');
                        ignoreLastBracket = true;
                        break;
                    }
                    char lookBehind = Strings.lookBehind(sb);
                    if (lookBehind == '[' && !ignoreLastBracket || lookBehind == '^') {
                        sb.append('\\');
                        sb.append(']');
                        ignoreLastBracket = true;
                        break;
                    }
                    ignoreLastBracket = false;
                    if (!in_char_class) {
                        --in_brackets;
                        sb.append(']');
                        break;
                    }
                    in_char_class = false;
                    String charCl = Strings.checkPosixCharClass(charClass);
                    if (charCl != null) {
                        sb.setLength(sb.length() - 4);
                        sb.append(charCl);
                    }
                    Strings.reset(charClass);
                    break;
                }
                case '!': {
                    if (in_brackets > 0) {
                        if (Strings.lookBehind(sb) == '[') {
                            sb.append('^');
                            break;
                        }
                        sb.append(c);
                        break;
                    }
                    sb.append(c);
                    break;
                }
                default: {
                    if (in_char_class) {
                        Strings.setNext(charClass, c);
                        break;
                    }
                    sb.append(c);
                }
            }
            seenEscape = c == '\\';
        }
        if (in_brackets > 0) {
            throw new InvalidPatternException("Not closed bracket?", pattern);
        }
        return Pattern.compile(sb.toString());
    }

    private static char lookBehind(StringBuilder buffer) {
        return buffer.length() > 0 ? buffer.charAt(buffer.length() - 1) : (char)'\u0000';
    }

    private static char lookAhead(String pattern, int i) {
        int idx = i + 1;
        return idx >= pattern.length() ? (char)'\u0000' : pattern.charAt(idx);
    }

    private static void setNext(char[] buffer, char c) {
        for (int i = 0; i < buffer.length; ++i) {
            if (buffer[i] != '\u0000') continue;
            buffer[i] = c;
            break;
        }
    }

    private static void reset(char[] buffer) {
        for (int i = 0; i < buffer.length; ++i) {
            buffer[i] = '\u0000';
        }
    }

    private static String checkPosixCharClass(char[] buffer) {
        for (int i = 0; i < POSIX_CHAR_CLASSES.size(); ++i) {
            String clazz = POSIX_CHAR_CLASSES.get(i);
            boolean match = true;
            for (int j = 0; j < clazz.length(); ++j) {
                if (buffer[j] == clazz.charAt(j)) continue;
                match = false;
                break;
            }
            if (!match) continue;
            return JAVA_CHAR_CLASSES.get(i);
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum PatternState {
        LEADING_ASTERISK_ONLY,
        TRAILING_ASTERISK_ONLY,
        COMPLEX,
        NONE;

    }
}

