/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.spdy.generator;

import java.nio.ByteBuffer;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.spdy.frames.ControlFrame;
import org.eclipse.jetty.spdy.frames.GoAwayFrame;
import org.eclipse.jetty.spdy.generator.ControlFrameGenerator;
import org.eclipse.jetty.util.BufferUtil;

public class GoAwayGenerator
extends ControlFrameGenerator {
    public GoAwayGenerator(ByteBufferPool bufferPool) {
        super(bufferPool);
    }

    @Override
    public ByteBuffer generate(ControlFrame frame) {
        GoAwayFrame goAway = (GoAwayFrame)frame;
        int frameBodyLength = 8;
        int totalLength = 8 + frameBodyLength;
        ByteBuffer buffer = this.getByteBufferPool().acquire(totalLength, true);
        BufferUtil.clearToFill(buffer);
        this.generateControlFrameHeader(goAway, frameBodyLength, buffer);
        buffer.putInt(goAway.getLastStreamId() & Integer.MAX_VALUE);
        this.writeStatusCode(goAway, buffer);
        buffer.flip();
        return buffer;
    }

    private void writeStatusCode(GoAwayFrame goAway, ByteBuffer buffer) {
        switch (goAway.getVersion()) {
            case 2: {
                break;
            }
            case 3: {
                buffer.putInt(goAway.getStatusCode());
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }
}

