/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.impl;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.directwebremoting.extend.DownloadManager;
import org.directwebremoting.extend.FileGenerator;
import org.directwebremoting.impl.PurgingDownloadManager;

public class InMemoryDownloadManager
extends PurgingDownloadManager
implements DownloadManager {
    protected Object contentsLock = new Object();
    protected final Map<String, TimedFileGenerator> contents = Collections.synchronizedMap(new HashMap());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void putFileGenerator(String id, FileGenerator generator) {
        Object object = this.contentsLock;
        synchronized (object) {
            this.contents.put(id, new TimedFileGenerator(generator));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected FileGenerator getFileGenerator(String id) {
        Object object = this.contentsLock;
        synchronized (object) {
            TimedFileGenerator generator = this.contents.remove(id);
            if (generator == null) {
                return null;
            }
            return generator.fileGenerator;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void purge() {
        long now = System.currentTimeMillis();
        Object object = this.contentsLock;
        synchronized (object) {
            Iterator<Map.Entry<String, TimedFileGenerator>> it = this.contents.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<String, TimedFileGenerator> entry = it.next();
                try {
                    if (now <= entry.getValue().timeInserted + this.purgeDownloadsAfter) continue;
                    it.remove();
                }
                catch (Exception ex) {
                    log.warn((Object)("Deletion queue processing error: " + ex.getMessage()));
                }
            }
        }
    }

    protected static class TimedFileGenerator {
        FileGenerator fileGenerator;
        long timeInserted;

        protected TimedFileGenerator(FileGenerator fileGenerator) {
            this.fileGenerator = fileGenerator;
            this.timeInserted = System.currentTimeMillis();
        }
    }
}

